/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.costtypecategories.service.impl.CostTypeCategoriesServiceHelper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeCategoriesException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TmpCostTypeCategoriesServiceExpandImpl"})
public class TpmCostTypeCategoriesServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmCostTypeCategoriesMapper, TpmCostTypeCategoriesEntity>
implements ITpmCostTypeCategoriesService {
    private static final Logger log = LoggerFactory.getLogger(TpmCostTypeCategoriesServiceImpl.class);
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Autowired
    private CostTypeCategoriesServiceHelper serviceHelper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;
    @Resource
    private MdmFunctionSubFeign mdmFunctionSubFeign;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;

    @Override
    @CrmLog
    public PageResult<TpmCostTypeCategoriesRespVo> findList(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmCostTypeCategoriesReqVo.getPageNum(), (Integer)tpmCostTypeCategoriesReqVo.getPageSize());
        List<TpmCostTypeCategoriesRespVo> list = this.tpmCostTypeCategoriesMapper.findList((Page<TpmCostTypeCategoriesRespVo>)page, tpmCostTypeCategoriesReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmCostTypeCategoriesRespVo query(String id) {
        Result respVoResult;
        TpmFinanceSubjectEntity tpmFinanceSubjectEntity;
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo = new TpmCostTypeCategoriesReqVo();
        tpmCostTypeCategoriesReqVo.setId(id);
        List list = this.findList(tpmCostTypeCategoriesReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmCostTypeCategoriesRespVo();
        }
        TpmCostTypeCategoriesRespVo respVo = (TpmCostTypeCategoriesRespVo)list.get(0);
        if (StringUtils.isNotEmpty((CharSequence)respVo.getFinanceSubjectCode()) && (tpmFinanceSubjectEntity = (TpmFinanceSubjectEntity)((Object)this.financeSubjectMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmFinanceSubjectEntity.class).eq(TpmFinanceSubjectEntity::getFinanceSubjectCode, (Object)respVo.getFinanceSubjectCode())))) != null) {
            respVo.setFinanceSubjectName(tpmFinanceSubjectEntity.getFinanceSubjectName());
        }
        TpmCostTypeCategoriesRangeReqVo rangeReqVo = new TpmCostTypeCategoriesRangeReqVo();
        rangeReqVo.setPageSize(Integer.valueOf(-1));
        rangeReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List rangeVos = this.rangeService.findList(rangeReqVo).getData();
        Map<String, List<TpmCostTypeCategoriesRangeRespVo>> map = rangeVos.stream().collect(Collectors.groupingBy(o -> o.getRangeType() + o.getIsContain()));
        map.keySet().forEach(o -> {
            List vos = (List)map.get(o);
            if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "Y"), (CharSequence)o)) {
                respVo.setContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "Y"), (CharSequence)o)) {
                respVo.setContainOrgTypeRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgTypeRangeVos(vos);
            } else {
                throw new BusinessException("\u6d3b\u52a8\u5927\u7c7b" + respVo.getCategoriesCode() + "\u8303\u56f4\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
            }
        });
        TpmCostTypeCategoriesFineReqVo fineReqVo = new TpmCostTypeCategoriesFineReqVo();
        fineReqVo.setPageSize(Integer.valueOf(-1));
        fineReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List fineVos = this.fineService.findList(fineReqVo).getData();
        respVo.setFineVos(fineVos);
        if (StringUtils.isNotEmpty((CharSequence)respVo.getFormCode()) && ObjectUtils.isNotEmpty((Object)(respVoResult = this.mdmFunctionSubFeign.query(new MdmFunctionSubReqVo().setFunctionCode(respVo.getFormCode()))).getResult())) {
            respVo.setFormName(((MdmFunctionSubRespVo)respVoResult.getResult()).getFunctionName());
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmCostTypeCategoriesReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeCategoriesEntity entity = (TpmCostTypeCategoriesEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmCostTypeCategoriesEntity.class));
        this.save((Object)entity);
        this.serviceHelper.saveRanges(reqVo);
        this.serviceHelper.saveFines(reqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmCostTypeCategoriesRespVo newData = (TpmCostTypeCategoriesRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeCategoriesRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getCategoriesCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmCostTypeCategoriesEntity entity = (TpmCostTypeCategoriesEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)CostTypeCategoriesException.DATA_NOT_EXIST, (String[])new String[0]);
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeCategoriesRespVo oldData = (TpmCostTypeCategoriesRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeCategoriesRespVo.class);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.serviceHelper.saveRanges(reqVo);
        this.serviceHelper.saveFines(reqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmCostTypeCategoriesRespVo newData = (TpmCostTypeCategoriesRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeCategoriesRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getCategoriesCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo = new TpmCostTypeCategoriesReqVo().setIds(ids);
        this.serviceHelper.deleteCheck(tpmCostTypeCategoriesReqVo);
        PageResult<TpmCostTypeCategoriesRespVo> oldDatList = this.findList(tpmCostTypeCategoriesReqVo);
        this.tpmCostTypeCategoriesMapper.deleteByParams(tpmCostTypeCategoriesReqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        oldDatList.getData().stream().forEach(o -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), o.getId(), o.getCategoriesCode(), o));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmCostTypeCategoriesMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeCategoriesRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(entities);
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeCategoriesRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmCostTypeCategoriesRespVo)newDataList.get(i)).getId(), ((TpmCostTypeCategoriesRespVo)newDataList.get(i)).getCategoriesCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmCostTypeCategoriesMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeCategoriesRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(entities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeCategoriesRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmCostTypeCategoriesRespVo)newDataList.get(i)).getId(), ((TpmCostTypeCategoriesRespVo)newDataList.get(i)).getCategoriesCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    public List<TpmCostTypeCategoriesRespVo> getCategoriesByBudget(ActGetCategoriesByBudgetReqVo reqVo) {
        List respVos;
        AssertUtils.isNotEmpty((Collection)reqVo.getControlIds(), (String)"\u8d39\u7528\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user)) {
            ArrayList rangeCodes = Lists.newArrayList();
            if (StringUtils.isNotEmpty((CharSequence)user.getOrgcode())) {
                rangeCodes.add(user.getOrgcode());
                MdmOrgRespVo orgByCode = OrgUtil.getOrgByCode((String)user.getOrgcode());
                AssertUtils.isNotNull((Object)orgByCode, (String)"\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                if (StringUtils.isNotEmpty((CharSequence)orgByCode.getOrgType())) {
                    rangeCodes.add(orgByCode.getOrgType());
                }
            }
            reqVo.setRangeCodes((List)rangeCodes);
        }
        if (CollectionUtils.isNotEmpty(respVos = this.tpmCostTypeCategoriesMapper.getCategoriesByBudget(reqVo))) {
            respVos = respVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmCostTypeCategoriesRespVo>(Comparator.comparing(UuidVo::getId))), ArrayList::new));
        }
        return respVos;
    }

    @Override
    public List<TpmBudgetSubjectsEntity> findAllIsActBudget() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmBudgetSubjectsEntity::getIsActBudget, (Object)GlobalWhetherEnum.YES.getCode());
        wrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode());
        List list = this.budgetSubjectsMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public Map<String, MdmCustomerMsgSelectRespVo> getCusMap(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgReqVo reqVo = new MdmCustomerMsgReqVo();
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        Result result = null;
        try {
            result = this.mdmCustomerMsgFeign.findCustomerSelectList(reqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u5927\u7c7b\u65b0\u589e\u83b7\u53d6\u5ba2\u6237,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        List list = (List)ApiResultUtil.objResult((Result)result, (boolean)true);
        Map<String, MdmCustomerMsgSelectRespVo> map = list.stream().collect(Collectors.toMap(MdmCustomerMsgSelectRespVo::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        return map;
    }
}

