/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.LiqueurAuditVo;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiquerAuditServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(LiquerAuditServiceHelper.class);
    @Resource
    private TpmAuditMapper auditMapper;
    @Resource
    private TpmLiqueurActMapper tpmLiqueurActMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper tpmLiqueurActRegisterDetailMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;
    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;
    @Resource
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;
    @Resource
    private ITpmLiqueurActRegisterDetailService actRegisterDetailService;
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Resource
    private ITpmLiqueurAuditService tpmLiqueurAuditService;
    @Resource
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;

    public void convertListDate(List<TpmLiqueurAuditRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName((String)o.getApproveStatus()));
                }
            });
        }
    }

    public void deleteCheck(List<TpmLiqueurAuditEntity> tpmAuditEntities, List<String> ids) {
        tpmAuditEntities.forEach(tpmAuditEntity -> AssertUtils.isTrue((boolean)ActApproveStatusEnum.CREATE.getCode().equals(tpmAuditEntity.getApproveStatus()), (String)"\u5df2\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u5220\u9664"));
    }

    public void saveCheck(TpmLiqueurAuditReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            TpmLiqueurAuditEntity tpmLiqueurAuditEntity = (TpmLiqueurAuditEntity)((Object)this.tpmLiqueurAuditMapper.selectById((Serializable)((Object)reqVo.getId())));
            AssertUtils.isNotNull((Object)((Object)tpmLiqueurAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            if (!ActApproveStatusEnum.getCanUpdateStatus().contains(tpmLiqueurAuditEntity.getApproveStatus())) {
                throw new BusinessException("\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
            }
            reqVo.setAuditCode(tpmLiqueurAuditEntity.getAuditCode());
        }
        AssertUtils.isNotEmpty((String)reqVo.getAuditName(), (String)"\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getTotalAmount(), (String)"\u6838\u9500\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        if (ActSaveTypeEnum.getSendApproveTypes().contains(reqVo.getSaveType())) {
            reqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)reqVo.getApproveStatus())) {
            reqVo.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        this.saveActCheckDetails(reqVo);
        this.saveCheckDetails(reqVo);
        this.checkDataExist(reqVo);
        this.saveActCheckAttach(reqVo);
    }

    private void saveActCheckAttach(TpmLiqueurAuditReqVo reqVo) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAttachVos())) {
            return;
        }
        HashMap detailsReqVoMap = Maps.newHashMap();
        reqVo.getDetailsVos().forEach(detail -> detailsReqVoMap.put(detail.getActDetailCode(), detail));
        HashMap attachMap = Maps.newHashMap();
        reqVo.getAttachVos().forEach(attach -> {
            AssertUtils.isNotNull((Object)detailsReqVoMap.containsKey(attach.getActDetailCode()), (String)("\u6d3b\u52a8\u9644\u52a0\u4fe1\u606f\u7f16\u7801\uff1a" + attach.getActRegisterCode() + "\u6240\u5728\u7684\u6d3b\u52a8\u660e\u7ec6\u672a\u9009\u4e2d"));
            if (ObjectUtils.isNull((Object[])new Object[]{attach.getAuditAmount()})) {
                attach.setAuditAmount(BigDecimal.ZERO);
            }
            ArrayList list = Lists.newArrayList();
            list.add(attach);
            if (attachMap.containsKey(attach.getActDetailCode())) {
                list.addAll((Collection)attachMap.get(attach.getActDetailCode()));
            }
            attachMap.put(attach.getActDetailCode(), list);
        });
        reqVo.getDetailsVos().forEach(detail -> {
            List attach = (List)attachMap.get(detail.getActDetailCode());
            if (CollectionUtil.listNotEmptyNotSizeZero((List)attach)) {
                BigDecimal attachAmount = BigDecimal.ZERO;
                for (TpmLiqueurAuditAttachReqVo a : attach) {
                    attachAmount = attachAmount.add(a.getAuditAmount());
                }
                AssertUtils.isTrue((detail.getBillAuditAmount().compareTo(attachAmount) == 0 ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u660e\u7ec6\uff1a" + detail.getActDetailCode() + "\u4e0a\u8d26\u91d1\u989d\u4e0e\u9644\u52a0\u4fe1\u606f\u91d1\u989d\u4e0d\u4e00\u81f4"));
            }
        });
    }

    private void saveActCheckDetails(TpmLiqueurAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6838\u9500\u7533\u8bf7\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List tpmActEntities = this.tpmLiqueurActMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActEntity::getActCode, (Object)reqVo.getActCode()));
        AssertUtils.isTrue((CollectionUtils.size((Object)tpmActEntities) == 1 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6570\u636e\u5f02\u5e38");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)tpmActEntities.get(0));
        AssertUtils.isNotNull((Object)((Object)entity), (String)("\u6d3b\u52a8\u7f16\u7801:" + reqVo.getActCode() + "\u6570\u636e\u4e0d\u5b58\u5728"));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)entity.getApproveStatus()), (String)("\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6d3b\u52a8:" + entity.getActCode() + "\u4e0d\u80fd\u6838\u9500"));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)entity.getIsAllAudit()), (String)"\u5b8c\u6210\u6838\u9500\u7684\u6d3b\u52a8\u4e0d\u80fd\u518d\u6b21\u6838\u9500");
        reqVo.setFineCode(entity.getFineCode());
    }

    private void saveCheckDetails(TpmLiqueurAuditReqVo reqVo) {
        List detailVos = reqVo.getDetailsVos();
        AssertUtils.isNotEmpty((Collection)detailVos, (String)"\u6838\u9500\u7533\u8bf7\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet actDetailCodes = Sets.newHashSet();
        detailVos.forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)reqVo.getActCode().equals(o.getActCode()), (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + o.getActDetailCode() + "\u4e0d\u5728\u9009\u5b9a\u7684\u6838\u9500\u6d3b\u52a8\u8303\u56f4\u5185"));
            o.setBillAuditAmount(o.getBillAuditAmount());
            o.setMaterialsAmount(o.getMaterialsAmount());
            o.setAmount(o.getAmount());
            actDetailCodes.add(o.getActDetailCode());
        });
        Map<Object, Object> auditDetailEntityMap = Maps.newHashMap();
        List auditEntities = this.tpmLiqueurAuditService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmLiqueurAuditEntity::getActCode, (Object)reqVo.getActCode())).eq(TpmLiqueurAuditEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVING.getCode()));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)auditEntities)) {
            List detailEntities = this.tpmLiqueurAuditDetailsService.getBaseMapper().selectList((Wrapper)new LambdaQueryWrapper().in(TpmLiqueurAuditDetailsEntity::getAuditCode, (Collection)auditEntities.stream().map(TpmLiqueurAuditEntity::getAuditCode).collect(Collectors.toSet())));
            auditDetailEntityMap = detailEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditDetailsEntity::getActDetailCode, Function.identity()));
        }
        AssertUtils.isTrue((detailVos.size() == CollectionUtils.size((Object)actDetailCodes) ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u91cd\u590d\u7684\u6d3b\u52a8\u660e\u7ec6");
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getAuditFileVos())) {
            reqVo.getAuditFileVos().stream().filter(o -> Objects.nonNull(o) && Objects.equals(1, o.getAuditFileType())).forEach(o -> AssertUtils.isTrue((boolean)actDetailCodes.contains(o.getAuditDetailCode()), (String)("\u6838\u9500\u8d44\u6599\u5bf9\u5e94\u7684\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + o.getAuditDetailCode() + "\u4e0d\u5728\u9009\u5b9a\u7684\u6d3b\u52a8\u660e\u7ec6\u8303\u56f4\u5185")));
        }
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        AssertUtils.isNotEmpty((Collection)fineEntities, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u6570\u636e\u5f02\u5e38");
        TpmCostTypeFineEntity typeFineEntity = (TpmCostTypeFineEntity)((Object)fineEntities.get(0));
        AssertUtils.isNotNull((Object)((Object)typeFineEntity), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u4e0d\u5b58\u5728");
        List tpmLiqueurActRegisterDetailEntities = this.tpmLiqueurActRegisterDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, (Collection)actDetailCodes));
        AssertUtils.isNotEmpty((Collection)tpmLiqueurActRegisterDetailEntities, (String)"\u60a8\u9009\u62e9\u7684\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e");
        Map actDetailMap = tpmLiqueurActRegisterDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        BigDecimal allMaterialsAmount = BigDecimal.ZERO;
        BigDecimal allAuditAmount = BigDecimal.ZERO;
        for (int i = 0; i < detailVos.size(); ++i) {
            TpmLiqueurAuditDetailsReqVo detailReqVo = (TpmLiqueurAuditDetailsReqVo)detailVos.get(i);
            AssertUtils.isTrue((!auditDetailEntityMap.containsKey(detailReqVo.getActDetailCode()) ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + detailReqVo.getActDetailCode() + "\u5df2\u7ecf\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u6838\u9500"));
            AssertUtils.isNotNull((Object)detailReqVo.getAmount(), (String)"\u672c\u6b21\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            detailReqVo.setAmount(detailReqVo.getBillAuditAmount().add(detailReqVo.getMaterialsAmount()));
            allMaterialsAmount = allMaterialsAmount.add(detailReqVo.getMaterialsAmount());
            allAuditAmount = allAuditAmount.add(detailReqVo.getAmount());
            TpmLiqueurActRegisterDetailEntity tpmLiqueurActRegisterDetailEntity = (TpmLiqueurActRegisterDetailEntity)((Object)actDetailMap.get(detailReqVo.getActDetailCode()));
            AssertUtils.isNotNull((Object)((Object)tpmLiqueurActRegisterDetailEntity), (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + detailReqVo.getActDetailCode() + "\u4e0d\u5b58\u5728,\u6216\u8005\u4e0d\u80fd\u8fdb\u884c\u6838\u9500\u64cd\u4f5c"));
            BigDecimal extraAuditRatio = typeFineEntity.getExtraAuditRatio();
            BigDecimal addAmount = detailReqVo.getAmount().add(detailReqVo.getAuditAmount());
            BigDecimal maxAuditAmount = Optional.ofNullable(extraAuditRatio).orElse(BigDecimal.ZERO).multiply(detailReqVo.getApplyAmount()).divide(BigDecimal.valueOf(100L)).add(detailReqVo.getApplyAmount());
            AssertUtils.isTrue((addAmount.compareTo(maxAuditAmount) < 1 ? 1 : 0) != 0, (String)("\u7b2c" + (i + 1) + "\u884c\u8d85\u8fc7\u5141\u8bb8\u6700\u5927\u6838\u9500\u91d1\u989d:" + maxAuditAmount.subtract(Optional.ofNullable(detailReqVo.getFeeUsed()).orElse(BigDecimal.ZERO))));
            if (StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)typeFineEntity.getIsAllowRepeatAudit())) {
                detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            }
            if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)typeFineEntity.getIsAllowRepeatAudit())) continue;
            if (Objects.isNull(typeFineEntity.getExtraAuditRatio()) && addAmount.compareTo(detailReqVo.getApplyAmount()) == 0) {
                detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            }
            if (!Objects.nonNull(typeFineEntity.getExtraAuditRatio()) || addAmount.compareTo(maxAuditAmount) != 0) continue;
            detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        }
        reqVo.setTotalAmount(allAuditAmount);
        reqVo.setMaterialsAmount(allMaterialsAmount);
        reqVo.setBillAuditAmount(allAuditAmount.subtract(allMaterialsAmount));
    }

    private void checkDataExist(TpmLiqueurAuditReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditEntity::getAuditCode, (Object)reqVo.getAuditCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmAuditEntity entity = (TpmAuditEntity)((Object)this.auditMapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AuditException.DATA_CODE_DUPLICATE, (String[])new String[0]);
    }

    public void sendToActivity(TpmAuditReqVo reqVo) {
    }

    public TpmAuditEntity rejectAndInterruptCheck(TpmAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditEntity entity = (TpmAuditEntity)((Object)this.auditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.REJECTED.getCode(), (CharSequence)reqVo.getApproveStatus())) {
            entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        }
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.INTERRUPT.getCode(), (CharSequence)reqVo.getApproveStatus())) {
            entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        }
        return entity;
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurAuditEntity entity, TpmLiqueurAuditReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurAuditCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getAuditCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileVos()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getAddressUrl());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void approveCheck(TpmLiqueurAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)this.tpmLiqueurAuditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)tpmAuditReqVo.getId())));
        Set canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(entity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        tpmAuditReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
    }

    public void convertTransactionMap(Set<String> businessLineCodes, LiqueurAuditVo auditVo) {
        List transactionEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, businessLineCodes)).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap transactionMap = Maps.newHashMap();
        transactionEntities.forEach(transactionEntity -> {
            ArrayList list = transactionMap.containsKey(transactionEntity.getBusinessLineCode()) ? (List)transactionMap.get(transactionEntity.getBusinessLineCode()) : Lists.newArrayList();
            list.add(transactionEntity);
            transactionMap.put(transactionEntity.getBusinessLineCode(), list);
        });
        auditVo.setTransactionEntities(transactionEntities);
        auditVo.setTransactionMap(transactionMap);
    }

    public void convertActBudgetMap(Set<String> actBudgetCodes, LiqueurAuditVo auditVo) {
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(actBudgetCodes)) {
            return;
        }
        List tpmLiqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetEntity::getActBudgetCode, actBudgetCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map<String, TpmLiqueurActBudgetEntity> actBudgetEntityMap = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
        auditVo.setTpmLiqueurActBudgetEntities(tpmLiqueurActBudgetEntities);
        auditVo.setActBudgetEntityMap(actBudgetEntityMap);
    }

    public void convertFeeBudgetDetailMap(Set<String> businessLineCodes, LiqueurAuditVo auditVo) {
        List feeBudgetDetailsEntities = this.tpmFeeBudgetDetailsService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmFeeBudgetDetailsEntity::getBusinessLineCode, businessLineCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap feeBudgetDetailMap = Maps.newHashMap();
        feeBudgetDetailsEntities.forEach(feeBudgetDetail -> {
            ArrayList list = feeBudgetDetailMap.containsKey(feeBudgetDetail.getBusinessLineCode()) ? (List)feeBudgetDetailMap.get(feeBudgetDetail.getBusinessLineCode()) : Lists.newArrayList();
            list.add(feeBudgetDetail);
            feeBudgetDetailMap.put(feeBudgetDetail.getBusinessLineCode(), list);
        });
        auditVo.setFeeBudgetDetailsEntities(feeBudgetDetailsEntities);
        auditVo.setFeeBudgetDetailMap(feeBudgetDetailMap);
    }

    public void convertFeeBudgetData(Set<String> feeBudgetCodes, LiqueurAuditVo auditVo) {
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeBudgetCodes)) {
            return;
        }
        List budgetEntities = this.tpmFeeBudgetService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        List controlEntities = this.tpmFeeBudgetControlService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, (Collection)budgetEntities.stream().map(TpmFeeBudgetEntity::getControlId).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = controlEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap = budgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        auditVo.setFeeBudgetEntities(budgetEntities);
        auditVo.setFeeBudgetControlEntities(controlEntities);
        auditVo.setFeeBudgetControlEntityMap(controlEntityMap);
        auditVo.setFeeBudgetEntityMap(feeBudgetEntityMap);
    }

    public void convertActRegisterDetail(Set<String> actDetailCodes, LiqueurAuditVo auditVo) {
        List actRegisterDetailEntities = this.actRegisterDetailService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map<String, TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntityMap = actRegisterDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        auditVo.setActRegisterDetailEntities(actRegisterDetailEntities);
        auditVo.setActRegisterDetailEntityMap(actRegisterDetailEntityMap);
    }
}

