/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostDutyOrgReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmLiqueurActController"})
@Api(tags={"\u9152\u7c7btpm \u6d3b\u52a8\u4e3b\u8868"})
public class TpmLiqueurActController {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActController.class);
    @Autowired
    private TpmLiqueurActService tpmLiqueurActService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmLiqueurActRespVo>> list(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        PageResult<TpmLiqueurActRespVo> result = this.tpmLiqueurActService.findList(tpmLiqueurActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmLiqueurActRespVo> query(@RequestParam(value="id", required=false) String id) {
        TpmLiqueurActRespVo tpmLiqueurActRespVo = this.tpmLiqueurActService.query(id);
        return Result.ok((Object)tpmLiqueurActRespVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurActService.save(tpmLiqueurActReqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurActService.update(tpmLiqueurActReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmLiqueurActService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmLiqueurActService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmLiqueurActService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6d3b\u52a8\u5173\u95ed")
    @PostMapping(value={"/closed"})
    @CrmLog
    public Result closed(@RequestBody List<String> ids) {
        TpmLiqueurActReqVo tpmLiqueurActReqVo = new TpmLiqueurActReqVo();
        if (CollectionUtils.isNotEmpty(ids)) {
            tpmLiqueurActReqVo.setIds(ids);
        }
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurActService.closed(tpmLiqueurActReqVo);
        return Result.ok((String)"\u6d3b\u52a8\u5173\u95ed\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/approve"})
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurActService.approve(tpmLiqueurActReqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/approved"})
    @CrmLog
    public Result approved(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.tpmLiqueurActService.approved(tpmLiqueurActReqVo);
        return Result.ok((String)"\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5ba1\u6279\u9a73\u56de")
    @PostMapping(value={"/reject"})
    @CrmLog
    public Result reject(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.tpmLiqueurActService.reject(tpmLiqueurActReqVo);
        return Result.ok((String)"\u5ba1\u6279\u9a73\u56de\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u6d41\u7a0b\u8ffd\u56de")
    @PostMapping(value={"/interrupt"})
    @CrmLog
    public Result interrupt(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.tpmLiqueurActService.interrupt(tpmLiqueurActReqVo);
        return Result.ok((String)"\u6d41\u7a0b\u8ffd\u56de\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u636e \u767b\u5f55 \u4eba \u548c\u662f\u5426\u9009\u62e9 \u8de8\u7ec4\u7ec7 \u6765 \u83b7\u53d6\u7ec4\u7ec7List")
    @PostMapping(value={"/findOrgMapByCodeAndIsCross"})
    @CrmLog
    public Result<List<MdmOrgRespVo>> findOrgMapByCodeAndIsCross(@RequestBody TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo) {
        List<MdmOrgRespVo> orgList = this.tpmLiqueurActService.getOrgList(tpmCostDutyOrgReqVo);
        return Result.ok(orgList);
    }

    @ApiOperation(value="\u636e\u7ec4\u7ec7 \u6765 \u83b7\u53d6\u5ba2\u6237List")
    @PostMapping(value={"/findCusMapByOrgCode"})
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> findCusMapByOrgCode(@RequestBody ActGetCustomerCodeByOrgCodeReqVo reqVo) {
        List<MdmCustomerMsgRespVo> list = this.tpmLiqueurActService.getCustomerMsgByOrgCodes(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e\u53ef\u9009\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6")
    @PostMapping(value={"/findBudgetController"})
    @CrmLog
    public Result<PageResult<TpmFeeBudgetControlRespVo>> findBudgetController(@RequestBody TpmLiqueurActReqVo reqVo) {
        PageResult<TpmFeeBudgetControlRespVo> result = this.tpmLiqueurActService.findBudgetController(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.tpmLiqueurActService.activityCallBack(activitiCallBackVo);
        return Result.ok((String)"\u6d3b\u52a8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }
}

