/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetBusinessTypeEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditFileMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.LiqueurAuditVo;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditFileEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditAttachService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditFileService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.liqueraudit.service.LiquerAuditServiceHelper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurAuditServiceExpandImpl"})
public class TpmLiqueurAuditServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurAuditMapper, TpmLiqueurAuditEntity>
implements ITpmLiqueurAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditServiceImpl.class);
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Autowired
    private LiquerAuditServiceHelper helper;
    @Autowired
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;
    @Autowired
    private ITpmLiqueurAuditFileService tpmLiqueurAuditFileService;
    @Resource
    private ITpmLiqueurActRegisterDetailService actRegisterDetailService;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;
    @Resource
    private ITpmLiqueurActBudgetTransactionService liqueurActBudgetTransactionService;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private ITpmCostTypeFineService tpmCostTypeFineService;
    @Resource
    private ITpmLiqueurActRegisterService tpmLiqueurActRegisterService;
    @Resource
    private TpmLiqueurActBudgetService tpmLiqueurActBudgetService;
    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;
    @Autowired
    private TaActBaseFeign activityFeign;
    @Resource
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;
    @Resource
    private TpmLiqueurActService tpmLiqueurActService;
    @Resource
    private TpmLiqueurActMapper liqueurActMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper liqueurActRegisterDetailMapper;
    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper liqueurActRegisterDetailAttachMapper;
    @Resource
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private TpmLiqueurAuditDetailsMapper auditDetailsMapper;
    @Resource
    private TpmLiqueurAuditAttachMapper auditAttachMapper;
    @Resource
    private ITpmLiqueurAuditAttachService auditAttachService;
    @Resource
    private TpmLiqueurAuditFileMapper auditFileMapper;

    @Override
    public PageResult<TpmLiqueurAuditRespVo> findList(TpmLiqueurAuditReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmLiqueurAuditRespVo> list = this.tpmLiqueurAuditMapper.findList((Page<TpmLiqueurAuditRespVo>)page, reqVo);
        this.helper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurAuditRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurAuditReqVo reqVo = new TpmLiqueurAuditReqVo();
        reqVo.setId(id);
        PageResult<TpmLiqueurAuditRespVo> pageResult = this.findList(reqVo);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)pageResult.getData()), (String)"\u6838\u9500\u6570\u636e\u4e0d\u5b58\u5728");
        TpmLiqueurAuditRespVo respVo = (TpmLiqueurAuditRespVo)pageResult.getData().get(0);
        List attachEntities = this.auditAttachMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).eq(TpmLiqueurAuditAttachEntity::getAuditCode, (Object)respVo.getAuditCode()));
        List attachRespVos = CrmBeanUtil.copyList((List)attachEntities, TpmLiqueurAuditAttachRespVo.class);
        respVo.setAttachVos(attachRespVos);
        List detailsEntities = this.auditDetailsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditDetailsEntity.class).eq(TpmLiqueurAuditDetailsEntity::getAuditCode, (Object)respVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)detailsEntities)) {
            List auditFileEntities = this.auditFileMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditFileEntity.class).eq(TpmLiqueurAuditFileEntity::getAuditCode, (Object)respVo.getAuditCode()));
            Map<String, List<TpmLiqueurAuditFileRespVo>> fileRespVosMap = auditFileEntities.stream().map(o -> {
                TpmLiqueurAuditFileRespVo fileRespVo = (TpmLiqueurAuditFileRespVo)CrmBeanUtil.copy((Object)o, TpmLiqueurAuditFileRespVo.class);
                return fileRespVo;
            }).collect(Collectors.groupingBy(TpmLiqueurAuditFileRespVo::getAuditDetailCode));
            List detailsRespVos = detailsEntities.stream().map(o -> {
                TpmLiqueurAuditDetailsRespVo detailsRespVo = (TpmLiqueurAuditDetailsRespVo)CrmBeanUtil.copy((Object)o, TpmLiqueurAuditDetailsRespVo.class);
                if (MapUtils.isNotEmpty((Map)fileRespVosMap)) {
                    List tpmLiqueurAuditFileRespVos = (List)fileRespVosMap.get(o.getAuditDetailCode());
                    detailsRespVo.setFileVos(tpmLiqueurAuditFileRespVos);
                }
                return detailsRespVo;
            }).collect(Collectors.toList());
            respVo.setDetailsVos(detailsRespVos);
        }
        this.buildAuditOtherData(respVo);
        return respVo;
    }

    @Override
    public TpmLiqueurAuditRespVo buildAuditOtherData(TpmLiqueurAuditRespVo respVo) {
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAudit", "#reqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void save(TpmLiqueurAuditReqVo reqVo) {
        this.helper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmLiqueurAuditEntity.class));
        entity.setBillAuditAmount(BigDecimal.ZERO);
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        this.saveActAttach(reqVo, entity);
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), (CharSequence)reqVo.getSaveType())) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(entity, reqVo);
        }
        this.saveMaterials();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAudit", "#reqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void update(TpmLiqueurAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.helper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmLiqueurAuditEntity tpmLiqueurAuditEntity = (TpmLiqueurAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmLiqueurAuditEntity.class));
        this.updateById((Object)tpmLiqueurAuditEntity);
        this.updateAuditDetail(reqVo, tpmLiqueurAuditEntity);
        this.updateAuditFile(reqVo, tpmLiqueurAuditEntity);
        this.updateAuditAttach(reqVo, tpmLiqueurAuditEntity);
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)tpmLiqueurAuditEntity.getApproveStatus())) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(tpmLiqueurAuditEntity, reqVo);
        }
        this.saveMaterials();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            this.helper.deleteCheck(tpmAuditEntities, ids);
            List auditCodes = tpmAuditEntities.stream().map(TpmLiqueurAuditEntity::getAuditCode).collect(Collectors.toList());
            this.tpmLiqueurAuditDetailsService.getBaseMapper().delete((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurAuditDetailsEntity::getAuditCode, auditCodes));
            this.auditAttachService.getBaseMapper().delete((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurAuditAttachEntity::getAuditCode, auditCodes));
            this.tpmLiqueurAuditMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    public PageResult<TpmLiqueurActRespVo> getActList(TpmLiqueurActReqVo reqVo) {
        reqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        reqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        reqVo.setAllowAuditEndDate(DateUtil.formatDate());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmLiqueurActRespVo> list = this.liqueurActMapper.findList((Page<TpmLiqueurActRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<TpmLiqueurActRegisterDetailRespVo> getActDetailList(TpmLiqueurActRegisterDetailReqVo reqVo) {
        reqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailRespVo> list = this.liqueurActRegisterDetailMapper.findDetailByRegisterStatus((Page<TpmLiqueurActRegisterDetailRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<TpmLiqueurActRegisterDetailAttachRespVo> getAttachList(TpmLiqueurActRegisterDetailAttachReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailAttachRespVo> list = this.liqueurActRegisterDetailAttachMapper.findList((Page<TpmLiqueurActRegisterDetailAttachRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmAuditReqVo reqVo = new TpmAuditReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            String actId = this.auditApproved(reqVo);
            TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(actId).type(ActSendMessageTypeEnum.ALL_AUDIT.getCode()).build();
            RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(this.topic).tag("TPM_ACT_APPROVED_AND_CLOSED").bizKey("tpm").msgBody(JSON.toJSONString((Object)actSendMessageVo)).build();
            log.info("\u5b8c\u5168\u6838\u9500,\u53d1\u9001MQ\u6d88\u606f,messageBody={}", (Object)rocketMQMessageBody.getMsgBody());
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    @Override
    @Klock(keys={"liqueurAudit", "#reqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    @Transactional(rollbackFor={Exception.class})
    public void approve(TpmLiqueurAuditReqVo reqVo) {
        this.helper.approveCheck(reqVo);
        this.update(reqVo);
    }

    public void saveAuditDetailInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List detailVos = reqVo.getDetailsVos();
        detailVos.forEach(o -> {
            o.setId(null);
            AssertUtils.isNotNull((Object)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u5b58\u5728");
            o.setAuditCode(entity.getAuditCode());
            o.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit"));
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmLiqueurAuditDetailsEntity.class);
        this.tpmLiqueurAuditDetailsService.saveBatch(tpmAuditDetailEntities);
    }

    private void saveAuditFileInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmLiqueurAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                AssertUtils.isNotNull((Object)tpmAuditFileEntity.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
            });
            this.tpmLiqueurAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    private void saveActAttach(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAttachVos())) {
            return;
        }
        HashMap map = Maps.newHashMap();
        reqVo.getDetailsVos().forEach(detail -> map.put(detail.getActDetailCode(), detail));
        reqVo.getAttachVos().forEach(attach -> {
            TpmLiqueurAuditDetailsReqVo detailsReqVo = (TpmLiqueurAuditDetailsReqVo)map.get(attach.getActDetailCode());
            attach.setAuditCode(entity.getAuditCode());
            attach.setActCode(entity.getActCode());
            attach.setFineCode(attach.getFineCode());
            attach.setAccountAmount(BigDecimal.ZERO);
            attach.setAuditDetailCode(detailsReqVo.getAuditDetailCode());
            attach.setIsAllAudit(detailsReqVo.getIsAllAudit());
            attach.setIsAllFeeUsed(detailsReqVo.getIsAllFeeUsed());
            attach.setFeeUsed(detailsReqVo.getFeeUsed());
        });
        this.auditAttachService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)reqVo.getAttachVos(), TpmLiqueurAuditAttachEntity.class));
    }

    private void occupyTheBudget(TpmLiqueurAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getDetailsVos();
        if (CollectionUtils.isEmpty((Collection)occupyFeeBudgetDetails)) {
            return;
        }
        TpmCostTypeFineEntity tpmCostTypeFineEntity = (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineService.getOne((Wrapper)new LambdaQueryWrapper().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode())));
        TpmLiqueurActEntity tpmLiqueurActEntity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActEntity::getActCode, (Object)reqVo.getActCode())));
        tpmLiqueurActEntity.setAuditTotalAmount(tpmLiqueurActEntity.getAuditTotalAmount().add(reqVo.getBillAuditAmount()));
        this.checkAuditDetail(reqVo, tpmCostTypeFineEntity.getIsAllowRepeatAudit());
        this.checkActAudit(reqVo);
        this.checkFeeBudget(reqVo);
        this.liqueurActMapper.updateById((Object)tpmLiqueurActEntity);
    }

    public Map<String, TpmBudgetSubjectsEntity> findBudgetSubjectsByCodes(Collection<String> subjectsCodes) {
        List subjectsEntities;
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(subjectsCodes) && CollectionUtils.isNotEmpty((Collection)(subjectsEntities = this.budgetSubjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectsCodes))))) {
            subjectsEntities.forEach(o -> map.put(o.getBudgetSubjectsCode(), o));
        }
        return map;
    }

    public void checkAuditDetail(TpmLiqueurAuditReqVo reqVo, String isAllowRepeatAudit) {
        List occupyFeeBudgetDetails = reqVo.getDetailsVos();
        List actDetailsCodes = occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toList());
        ArrayList tpmLiqueurAuditDetailsRespVos = Lists.newArrayList();
        List detailEntityList = this.actRegisterDetailService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailsCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map actDetailMap = detailEntityList.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            TpmLiqueurActRegisterDetailEntity actDetail = (TpmLiqueurActRegisterDetailEntity)((Object)actDetailMap.get(p.getActDetailCode()));
            AssertUtils.isNotNull((Object)((Object)actDetail), (String)(p.getActDetailCode() + "\u5bf9\u5e94\u7684\u6d3b\u52a8\u660e\u7ec6\u4e0d\u5b58\u5728\uff01"));
            if (Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getApplyAmount()) > 0) {
                p.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
                p.setWaitAmount(p.getAmount());
                tpmLiqueurAuditDetailsRespVos.add(p);
                continue;
            }
            if (Optional.ofNullable(p.getAuditAmount().abs()).orElse(BigDecimal.ZERO).add(p.getAmount()).compareTo(p.getApplyAmount()) > 0) {
                BigDecimal waitAudit = p.getAmount().add(p.getAuditAmount().abs()).subtract(p.getApplyAmount());
                actDetail.setAuditAmount(p.getAmount().add(p.getAuditAmount().abs()));
                p.setWaitAmount(waitAudit);
                tpmLiqueurAuditDetailsRespVos.add(p);
                continue;
            }
            actDetail.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
        }
        this.actRegisterDetailService.saveOrUpdateBatch(detailEntityList);
        reqVo.setOccupyFeeBudgetDetails((List)tpmLiqueurAuditDetailsRespVos);
    }

    public void checkActAudit(TpmLiqueurAuditReqVo reqVo) {
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getOccupyFeeBudgetDetails())) {
            return;
        }
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        ArrayList waitAuditList = Lists.newArrayList();
        ArrayList addTransaction = Lists.newArrayList();
        Set actDetailCode = reqVo.getOccupyFeeBudgetDetails().stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toSet());
        List budgetDetailsEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCode)).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap budgetDetailEntityMap = Maps.newHashMap();
        budgetDetailsEntities.forEach(budgetDetailsEntity -> {
            List list = Lists.newArrayList();
            if (budgetDetailEntityMap.containsKey(budgetDetailsEntity.getBusinessLineCode())) {
                list = (List)budgetDetailEntityMap.get(budgetDetailsEntity.getBusinessLineCode());
            }
            list.add(budgetDetailsEntity);
            budgetDetailEntityMap.put(budgetDetailsEntity.getBusinessLineCode(), list);
        });
        List tpmLiqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetEntity::getActBudgetCode, (Collection)budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toList()))).in(TpmLiqueurActBudgetEntity::getFeeBudgetCode, (Collection)budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        List tpmLiqueurActEntities = this.liqueurActMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActEntity::getActCode, (Collection)tpmLiqueurActBudgetEntities.stream().map(TpmLiqueurActBudgetEntity::getActCode).collect(Collectors.toSet()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map actMap = tpmLiqueurActEntities.stream().collect(Collectors.toMap(TpmLiqueurActEntity::getActCode, Function.identity()));
        Map map = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getFeeBudgetCode, Function.identity()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            AssertUtils.isTrue((boolean)budgetDetailEntityMap.containsKey(p.getActDetailCode()), (String)("\u6d3b\u52a8\u8be6\u7ec6\u7f16\u7801\uff1a" + p.getActDetailCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u660e\u7ec6\u4fe1\u606f"));
            List transactions = (List)budgetDetailEntityMap.get(p.getActDetailCode());
            BigDecimal waitAudit = p.getWaitAmount();
            for (TpmLiqueurActBudgetTransactionEntity transaction : transactions) {
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) break;
                TpmLiqueurActBudgetEntity actBudgetEntity = (TpmLiqueurActBudgetEntity)((Object)map.get(transaction.getFeeBudgetCode()));
                TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)actMap.get(actBudgetEntity.getActCode()));
                AssertUtils.isNotNull((Object)((Object)actBudgetEntity), (String)(transaction.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u6d3b\u52a8\u9884\u7b97\u4e0d\u5b58\u5728"));
                TpmLiqueurActBudgetTransactionEntity newTransaction = (TpmLiqueurActBudgetTransactionEntity)((Object)CrmBeanUtil.copy((Object)((Object)transaction), TpmLiqueurActBudgetTransactionEntity.class));
                newTransaction.setBusinessCode(reqVo.getAuditCode());
                newTransaction.setBusinessLineCode(p.getAuditDetailCode());
                newTransaction.setBusinessType(LiqueurActBudgetBusinessTypeEnum.AUDIT.getCode());
                this.helper.setPublicParamsNull((CrmBaseEntity)newTransaction);
                if (actBudgetEntity.getCanUseAmount().compareTo(waitAudit) > 0) {
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().subtract(waitAudit));
                    actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().add(waitAudit));
                    actEntity.setCanUseAmount(actEntity.getCanUseAmount().subtract(waitAudit));
                    actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().add(waitAudit));
                    newTransaction.setFeeAmount(waitAudit.negate());
                    waitAudit = BigDecimal.ZERO;
                    addTransaction.add(newTransaction);
                    continue;
                }
                if (actBudgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                waitAudit = waitAudit.subtract(actBudgetEntity.getCanUseAmount());
                newTransaction.setFeeAmount(actBudgetEntity.getCanUseAmount().negate());
                actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().add(actBudgetEntity.getCanUseAmount()));
                actEntity.setCanUseAmount(actEntity.getCanUseAmount().subtract(actBudgetEntity.getCanUseAmount()));
                actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().add(actBudgetEntity.getCanUseAmount()));
                actBudgetEntity.setCanUseAmount(BigDecimal.ZERO);
                addTransaction.add(newTransaction);
            }
            if (waitAudit.compareTo(BigDecimal.ZERO) <= 0) continue;
            p.setWaitAmount(waitAudit);
            p.setFeeBudgetCodes(transactions.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()));
            waitAuditList.add(p);
        }
        this.tpmLiqueurActBudgetService.saveOrUpdateBatch(tpmLiqueurActBudgetEntities);
        this.liqueurActBudgetTransactionService.saveBatch(addTransaction);
        this.tpmLiqueurActService.updateBatchById(tpmLiqueurActEntities);
        reqVo.setOccupyFeeBudgetDetails((List)waitAuditList);
    }

    public void checkFeeBudget(TpmLiqueurAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getOccupyFeeBudgetDetails())) {
            return;
        }
        ArrayList addDetailsList = Lists.newArrayList();
        ArrayList feeBudgetCodes = Lists.newArrayList();
        List<List> codes = occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getFeeBudgetCodes).collect(Collectors.toList());
        codes.forEach(feeBudgetCodes::addAll);
        List budgetEntities = this.tpmFeeBudgetService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getFeeBudgetCode, (Collection)feeBudgetCodes)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        List controlEntities = this.tpmFeeBudgetControlService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, (Collection)budgetEntities.stream().map(TpmFeeBudgetEntity::getControlId).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map controlEntityMap = controlEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        Map feeBudgetEntityMap = budgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(budgetEntities.stream().map(TpmFeeBudgetEntity::getBudgetSubjectsCode).collect(Collectors.toList()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            BigDecimal waitAudit = p.getWaitAmount();
            int reduceOrder = 1;
            for (String feeBudgetCode : p.getFeeBudgetCodes()) {
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) break;
                AssertUtils.isTrue((boolean)feeBudgetEntityMap.containsKey(feeBudgetCode), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801" + feeBudgetCode + "\u5bf9\u5e94\u7684\u9884\u7b97\u4e0d\u5b58\u5728"));
                TpmFeeBudgetEntity budget = (TpmFeeBudgetEntity)((Object)feeBudgetEntityMap.get(feeBudgetCode));
                TpmFeeBudgetControlEntity control = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(budget.getControlId()));
                TpmFeeBudgetDetailsEntity detailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)budget), (Object)((Object)detailsEntity));
                detailsEntity.setFeeBudgetCode(feeBudgetCode);
                detailsEntity.setFeeBudgetType(budget.getFeeBudgetType());
                detailsEntity.setOrgType(budget.getOrgType());
                detailsEntity.setBusinessCode(reqVo.getAuditCode());
                detailsEntity.setBusinessLineCode(p.getAuditDetailCode());
                detailsEntity.setBusinessName(reqVo.getTitle());
                detailsEntity.setYear(String.valueOf(DateUtil.getCurrentYear()));
                detailsEntity.setMonth(String.valueOf(DateUtil.getCurrentMonth()));
                detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                detailsEntity.setReduceOrder(reduceOrder);
                detailsEntity.setBudgetSubjectsCode(budget.getBudgetSubjectsCode());
                detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                detailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                this.helper.setPublicParamsNull((CrmBaseEntity)detailsEntity);
                if (StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntityMap.get(budget.getBudgetSubjectsCode()).getControlType())) {
                    waitAudit = this.getBigDecimal(waitAudit, feeBudgetCode, budget, detailsEntity, waitAudit);
                    control.setCanUseAmount(control.getCanUseAmount().subtract(detailsEntity.getFeeAmount().abs()));
                    addDetailsList.add(detailsEntity);
                } else if (budget.getCanUseAmount().compareTo(waitAudit) > 0) {
                    waitAudit = this.getBigDecimal(waitAudit, feeBudgetCode, budget, detailsEntity, budget.getUsedAmount());
                    addDetailsList.add(detailsEntity);
                    control.setCanUseAmount(control.getCanUseAmount().subtract(detailsEntity.getFeeAmount().abs()));
                } else if (budget.getCanUseAmount().compareTo(BigDecimal.ZERO) > 0) {
                    detailsEntity.setFeeAmount(budget.getCanUseAmount().negate());
                    detailsEntity.setBeforAmount(budget.getCanUseAmount());
                    detailsEntity.setAfterAmount(BigDecimal.ZERO);
                    budget.setUsedAmount(budget.getCanUseAmount().add(budget.getCanUseAmount()));
                    budget.setCanUseAmount(BigDecimal.ZERO);
                    waitAudit = waitAudit.subtract(budget.getCanUseAmount());
                    control.setCanUseAmount(control.getCanUseAmount().subtract(budget.getCanUseAmount()));
                    addDetailsList.add(detailsEntity);
                }
                ++reduceOrder;
            }
            AssertUtils.isTrue((waitAudit.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u660e\u7ec6\uff1a" + p.getActDetailCode() + "\u6838\u9500\u8d39\u7528\u8d85\u51fa\u8d39\u7528\u9884\u7b97"));
        }
        this.tpmFeeBudgetService.saveOrUpdateBatch(budgetEntities);
        this.tpmFeeBudgetControlService.saveOrUpdateBatch(controlEntities);
        this.tpmFeeBudgetDetailsService.saveOrUpdateBatch(addDetailsList);
    }

    private BigDecimal getBigDecimal(BigDecimal waitAudit, String feeBudgetCode, TpmFeeBudgetEntity budget, TpmFeeBudgetDetailsEntity detailsEntity, BigDecimal usedAmount) {
        detailsEntity.setFeeAmount(waitAudit.negate());
        detailsEntity.setBeforAmount(budget.getCanUseAmount());
        detailsEntity.setAfterAmount(budget.getCanUseAmount().subtract(waitAudit));
        budget.setUsedAmount(usedAmount.add(waitAudit));
        budget.setCanUseAmount(budget.getCanUseAmount().subtract(waitAudit));
        return BigDecimal.ZERO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmLiqueurAuditEntity entity, TpmLiqueurAuditReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            log.info("\u6838\u9500\u63d0\u4ea4\u5ba1\u6279,\u5de5\u4f5c\u6d41\u8fd4\u56de\u53c2\u6570={}", (Object)JSON.toJSONString((Object)processCommonVoResult));
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public String auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurAuditEntity tpmAuditEntity = (TpmLiqueurAuditEntity)((Object)this.getById((Serializable)((Object)tpmAuditReqVo.getId())));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)tpmAuditEntity.getApproveStatus()), (String)"\u6b64\u6838\u9500\u72b6\u6001\u975e\u5ba1\u6279\u4e2d,\u65e0\u6cd5\u5ba1\u6279\u901a\u8fc7\uff01");
        tpmAuditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        this.updateById((Object)tpmAuditEntity);
        ArrayList addTransactions = Lists.newArrayList();
        TpmLiqueurActEntity tpmLiqueurActEntity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActEntity::getActCode, (Object)tpmAuditEntity.getActCode())));
        List auditDetailsEntities = this.tpmLiqueurAuditDetailsService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmLiqueurAuditDetailsEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).eq(TpmLiqueurAuditDetailsEntity::getIsAllAudit, (Object)GlobalWhetherEnum.YES.getCode()));
        List actDetailCode = auditDetailsEntities.stream().map(TpmLiqueurAuditDetailsEntity::getActDetailCode).collect(Collectors.toList());
        if (!CollectionUtil.listNotEmptyNotSizeZero(actDetailCode)) {
            return tpmAuditEntity.getId();
        }
        List actRegisterDetailEntities = this.actRegisterDetailService.getBaseMapper().selectList((Wrapper)new LambdaQueryWrapper().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailCode));
        List budgetTransactionEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCode)).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap transactionMap = Maps.newHashMap();
        budgetTransactionEntities.forEach(transactionEntity -> {
            List list = (List)transactionMap.get(transactionEntity.getBusinessLineCode());
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                list = Lists.newArrayList();
            }
            list.add(transactionEntity);
            transactionMap.put(transactionEntity.getBusinessLineCode(), list);
        });
        List tpmLiqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetEntity::getActBudgetCode, (Collection)budgetTransactionEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map actBudgetEntityMap = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
        block0: for (TpmLiqueurActRegisterDetailEntity actDetail : actRegisterDetailEntities) {
            if (actDetail.getApplyAmount().compareTo(actDetail.getAuditAmount()) <= 0) continue;
            AtomicReference<BigDecimal> needRollBackAmount = new AtomicReference<BigDecimal>(actDetail.getApplyAmount().subtract(actDetail.getAuditAmount()));
            List transactionEntities = (List)transactionMap.get(actDetail.getActDetailCode());
            AssertUtils.isTrue((boolean)CollectionUtil.listNotEmptyNotSizeZero((List)transactionEntities), (String)("\u6d3b\u52a8\u660e\u7ec6" + actDetail.getActDetailCode() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9884\u7b97\u4f7f\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u9000\u8fd8\u91d1\u989d\uff01"));
            transactionEntities.sort(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder).reversed());
            for (TpmLiqueurActBudgetTransactionEntity transactionEntity2 : transactionEntities) {
                if (needRollBackAmount.get().compareTo(BigDecimal.ZERO) == 0) continue block0;
                if (!actBudgetEntityMap.containsKey(transactionEntity2.getActBudgetCode())) continue;
                BigDecimal used = transactionEntity2.getFeeAmount().abs();
                TpmLiqueurActBudgetTransactionEntity newTransaction = (TpmLiqueurActBudgetTransactionEntity)((Object)CrmBeanUtil.copy((Object)((Object)transactionEntity2), TpmLiqueurActBudgetTransactionEntity.class));
                newTransaction.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                if (needRollBackAmount.get().compareTo(used) > 0) {
                    needRollBackAmount.set(needRollBackAmount.get().subtract(used));
                    newTransaction.setFeeAmount(used);
                } else {
                    needRollBackAmount.set(BigDecimal.ZERO);
                    newTransaction.setFeeAmount(used.subtract(needRollBackAmount.get()));
                }
                this.helper.setPublicParamsNull((CrmBaseEntity)newTransaction);
                addTransactions.add(newTransaction);
                TpmLiqueurActBudgetEntity actBudgetEntity = (TpmLiqueurActBudgetEntity)((Object)actBudgetEntityMap.get(transactionEntity2.getActBudgetCode()));
                actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(newTransaction.getFeeAmount()));
                tpmLiqueurActEntity.setCanUseAmount(tpmLiqueurActEntity.getCanUseAmount().add(newTransaction.getFeeAmount()));
            }
        }
        this.tpmLiqueurActBudgetService.saveOrUpdateBatch(tpmLiqueurActBudgetEntities);
        this.liqueurActBudgetTransactionService.saveBatch(addTransactions);
        this.liqueurActMapper.updateById((Object)tpmLiqueurActEntity);
        return tpmAuditEntity.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejectAndInterrupt(TpmAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurAuditEntity tpmAuditEntity = (TpmLiqueurAuditEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)tpmAuditEntity.getApproveStatus()), (String)"\u6b64\u6838\u9500\u72b6\u6001\u975e\u5ba1\u6279\u4e2d,\u65e0\u6cd5\u9a73\u56de/\u64a4\u9500\uff01");
        tpmAuditEntity.setApproveStatus(reqVo.getApproveStatus());
        this.updateById((Object)tpmAuditEntity);
        LiqueurAuditVo auditVo = new LiqueurAuditVo();
        List auditDetailsEntities = this.tpmLiqueurAuditDetailsService.getBaseMapper().selectList((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurAuditDetailsEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
        Set<String> actDetailCodes = auditDetailsEntities.stream().map(TpmLiqueurAuditDetailsEntity::getActDetailCode).collect(Collectors.toSet());
        Set<String> auditDetailCodes = auditDetailsEntities.stream().map(TpmLiqueurAuditDetailsEntity::getAuditDetailCode).collect(Collectors.toSet());
        this.helper.convertActRegisterDetail(actDetailCodes, auditVo);
        this.helper.convertTransactionMap(auditDetailCodes, auditVo);
        this.helper.convertActBudgetMap(auditVo.getTransactionEntities().stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toSet()), auditVo);
        this.helper.convertFeeBudgetDetailMap(auditDetailCodes, auditVo);
        this.helper.convertFeeBudgetData(auditVo.getFeeBudgetDetailsEntities().stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet()), auditVo);
        for (TpmLiqueurAuditDetailsEntity auditDetail : auditDetailsEntities) {
            List<TpmLiqueurActBudgetTransactionEntity> transactionEntityList;
            BigDecimal needBackAmount = auditDetail.getAmount();
            List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntityList = auditVo.getFeeBudgetDetailMap().get(auditDetail.getAuditDetailCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(feeBudgetDetailsEntityList)) {
                for (TpmFeeBudgetDetailsEntity tpmFeeBudgetDetailsEntity : feeBudgetDetailsEntityList) {
                    TpmFeeBudgetEntity feeBudgetEntity = auditVo.getFeeBudgetEntityMap().get(tpmFeeBudgetDetailsEntity.getFeeBudgetCode());
                    AssertUtils.isNotNull((Object)((Object)feeBudgetEntity), (String)("\u6838\u9500\u660e\u7ec6" + auditDetail.getActDetailCode() + "\u9700\u8981\u9000\u8fd8\u7684\u8d39\u7528\u9884\u7b97" + tpmFeeBudgetDetailsEntity.getFeeBudgetCode() + "\u4e0d\u5b58\u5728"));
                    feeBudgetEntity.setCanUseAmount(tpmFeeBudgetDetailsEntity.getBeforAmount());
                    TpmFeeBudgetControlEntity feeBudgetControlEntity = auditVo.getFeeBudgetControlEntityMap().get(feeBudgetEntity.getControlId());
                    feeBudgetControlEntity.setCanUseAmount(feeBudgetControlEntity.getCanUseAmount().add(tpmFeeBudgetDetailsEntity.getFeeAmount().abs()));
                    needBackAmount = needBackAmount.subtract(tpmFeeBudgetDetailsEntity.getFeeAmount().abs());
                    tpmFeeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(transactionEntityList = auditVo.getTransactionMap().get(auditDetail.getAuditDetailCode()))) {
                for (TpmLiqueurActBudgetTransactionEntity transactionEntity : transactionEntityList) {
                    TpmLiqueurActBudgetEntity actBudgetEntity = auditVo.getActBudgetEntityMap().get(transactionEntity.getActBudgetCode());
                    AssertUtils.isNotNull((Object)((Object)actBudgetEntity), (String)("\u6838\u9500\u660e\u7ec6" + auditDetail.getActDetailCode() + "\u9700\u8981\u9000\u8fd8\u7684\u6d3b\u52a8\u9884\u7b97" + transactionEntity.getActBudgetCode() + "\u4e0d\u5b58\u5728"));
                    TpmLiqueurActEntity actEntity = auditVo.getActEntityMap().get(actBudgetEntity.getActCode());
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                    actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().subtract(transactionEntity.getFeeAmount().abs()));
                    actEntity.setCanUseAmount(actEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                    actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().subtract(transactionEntity.getFeeAmount().abs()));
                    needBackAmount = needBackAmount.subtract(transactionEntity.getFeeAmount().abs());
                    transactionEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                }
            }
            TpmLiqueurActRegisterDetailEntity tpmLiqueurActRegisterDetailEntity = auditVo.getActRegisterDetailEntityMap().get(auditDetail.getActDetailCode());
            AssertUtils.isNotNull((Object)((Object)tpmLiqueurActRegisterDetailEntity), (String)("\u6838\u9500\u660e\u7ec6" + auditDetail.getActDetailCode() + "\u9700\u8981\u9000\u8fd8\u7684\u6d3b\u52a8\u660e\u7ec6" + tpmLiqueurActRegisterDetailEntity.getActDetailCode() + "\u4e0d\u5b58\u5728"));
            tpmLiqueurActRegisterDetailEntity.setAuditAmount(tpmLiqueurActRegisterDetailEntity.getAuditAmount().subtract(auditDetail.getAmount()));
        }
        this.tpmFeeBudgetDetailsService.saveOrUpdateBatch(auditVo.getFeeBudgetDetailsEntities());
        this.tpmFeeBudgetControlService.saveOrUpdateBatch(auditVo.getFeeBudgetControlEntities());
        this.tpmFeeBudgetService.saveOrUpdateBatch(auditVo.getFeeBudgetEntities());
        this.tpmLiqueurActBudgetService.saveOrUpdateBatch(auditVo.getTpmLiqueurActBudgetEntities());
        this.liqueurActBudgetTransactionService.saveOrUpdateBatch(auditVo.getTransactionEntities());
        this.actRegisterDetailService.saveOrUpdateBatch(auditVo.getActRegisterDetailEntities());
        this.tpmLiqueurActService.saveOrUpdateBatch(auditVo.getActEntities());
    }

    public void updateAuditDetail(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity tpmAuditEntity) {
        List detailVos = reqVo.getDetailsVos();
        detailVos.stream().forEach(detailReqVo -> {
            detailReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
            if (StringUtils.isEmpty((CharSequence)detailReqVo.getAuditDetailCode())) {
                detailReqVo.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            }
            if (Objects.isNull(detailReqVo.getFeeUsed())) {
                detailReqVo.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)detailReqVo.getIsAllFeeUsed())) {
                detailReqVo.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List auditDetailIds = detailVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        this.tpmLiqueurAuditDetailsService.getBaseMapper().delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmLiqueurAuditDetailsEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditDetailIds), BaseIdEntity::getId, auditDetailIds));
        this.tpmLiqueurAuditDetailsService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)detailVos, TpmLiqueurAuditDetailsEntity.class));
    }

    public void updateAuditAttach(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List attachReqVos = reqVo.getAttachVos();
        HashMap map = Maps.newHashMap();
        reqVo.getDetailsVos().forEach(detail -> map.put(detail.getActDetailCode(), detail));
        if (CollectionUtils.isNotEmpty((Collection)attachReqVos)) {
            attachReqVos.forEach(attach -> {
                TpmLiqueurAuditDetailsReqVo detailsReqVo = (TpmLiqueurAuditDetailsReqVo)map.get(attach.getActDetailCode());
                attach.setAuditCode(entity.getAuditCode());
                attach.setActCode(entity.getActCode());
                attach.setFineCode(attach.getFineCode());
                attach.setAccountAmount(BigDecimal.ZERO);
                attach.setAuditDetailCode(detailsReqVo.getAuditDetailCode());
                attach.setIsAllAudit(detailsReqVo.getIsAllAudit());
                attach.setIsAllFeeUsed(detailsReqVo.getIsAllFeeUsed());
                attach.setFeeUsed(detailsReqVo.getFeeUsed());
            });
            List auditAttachIds = attachReqVos.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.auditAttachService.getBaseMapper().delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmLiqueurAuditAttachEntity::getAuditCode, (Object)entity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditAttachIds), BaseIdEntity::getId, auditAttachIds));
            this.auditAttachService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)attachReqVos, TpmLiqueurAuditAttachEntity.class));
        } else {
            this.tpmLiqueurAuditFileService.getBaseMapper().delete((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurAuditFileEntity::getAuditCode, (Object)reqVo.getAuditCode()));
        }
    }

    public void updateAuditFile(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity tpmAuditEntity) {
        List auditFileRespVos = reqVo.getAuditFileVos();
        if (CollectionUtils.isNotEmpty((Collection)auditFileRespVos)) {
            auditFileRespVos.stream().forEach(tpmAuditFileRespVo -> {
                AssertUtils.isNotNull((Object)tpmAuditFileRespVo.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileRespVo.setAuditCode(tpmAuditEntity.getAuditCode());
            });
            List auditFileIds = auditFileRespVos.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmLiqueurAuditFileService.getBaseMapper().delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmLiqueurAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditFileIds), BaseIdEntity::getId, auditFileIds));
            this.tpmLiqueurAuditFileService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)auditFileRespVos, TpmLiqueurAuditFileEntity.class));
        } else {
            this.tpmLiqueurAuditFileService.getBaseMapper().delete((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMaterials() {
    }
}

