/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.LiqueurActBuilder;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostDutyOrgReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurActServiceExpandImpl"})
public class TpmLiqueurActServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurActMapper, TpmLiqueurActEntity>
implements TpmLiqueurActService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActServiceImpl.class);
    @Resource
    private TpmLiqueurActMapper tpmLiqueurActMapper;
    @Autowired
    private TpmLiqueurServiceHelper helper;
    @Resource
    private TaActBaseFeign activityFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;
    @Resource
    private MdmOrgFeign orgFeign;
    @Autowired
    private ITpmCostTypeFineService costTypeFineService;
    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;
    @Resource
    private TpmFeeBudgetControlMapper controlMapper;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    @Override
    public PageResult<TpmLiqueurActRespVo> findList(TpmLiqueurActReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurActRespVo> list = this.tpmLiqueurActMapper.findList((Page<TpmLiqueurActRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.helper.setRespVoData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurActRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        TpmLiqueurActReqVo reqVo = new TpmLiqueurActReqVo();
        reqVo.setId(id);
        List actRespVoList = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)actRespVoList)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        TpmLiqueurActRespVo actRespVo = (TpmLiqueurActRespVo)actRespVoList.get(0);
        this.helper.convertCusAndOrgData(actRespVo);
        this.helper.setBudgetData(actRespVo);
        this.helper.setActFileData(actRespVo);
        return actRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAct", "#tpmLiqueurActReqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void save(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        LiqueurActBuilder actOperateBuilder = new LiqueurActBuilder(this.helper, tpmLiqueurActReqVo);
        TpmLiqueurActEntity liqueurActEntity = actOperateBuilder.init().check().convert().save();
        this.sendToActivity(liqueurActEntity, tpmLiqueurActReqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmLiqueurActRespVo newData = (TpmLiqueurActRespVo)CrmBeanUtil.copy((Object)((Object)liqueurActEntity), TpmLiqueurActRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getActCode(), (Object)newData);
    }

    private void sendToActivity(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)liqueurActEntity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(liqueurActEntity, tpmLiqueurActReqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            liqueurActEntity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)liqueurActEntity);
        }
    }

    @Override
    public List<MdmOrgRespVo> getOrgList(TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo) {
        UserRedis userRedis = UserUtils.getUser();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(userRedis.getOrgcode());
        mdmOrgReqVo.setPageNum(tpmCostDutyOrgReqVo.getPageNum());
        mdmOrgReqVo.setPageSize(tpmCostDutyOrgReqVo.getPageSize());
        mdmOrgReqVo.setOrgName(tpmCostDutyOrgReqVo.getOrgName());
        Result respVos = null;
        List data = this.costTypeFineService.findList(new TpmCostTypeFineReqVo().setFineCode(tpmCostDutyOrgReqVo.getFineCode())).getData();
        String isSpanOrgBudget = ((TpmCostTypeFineRespVo)data.get(0)).getIsSpanOrgBudget();
        MdmOrgRespVo parentOrg = new MdmOrgRespVo();
        if (StringUtils.equals((CharSequence)isSpanOrgBudget, (CharSequence)GlobalWhetherEnum.NO.getCode()) || StringUtils.isBlank((CharSequence)isSpanOrgBudget)) {
            try {
                respVos = this.orgFeign.findAllChildrenOrgList(mdmOrgReqVo);
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
                throw new BusinessException("\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
            }
            return (List)ApiResultUtil.objResult((Result)respVos);
        }
        try {
            parentOrg = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.findSingleParentOrg(mdmOrgReqVo), (boolean)true);
            if (parentOrg != null) {
                mdmOrgReqVo.setOrgCode(parentOrg.getOrgCode());
            }
            respVos = this.orgFeign.findAllChildrenOrgList(mdmOrgReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        List<Object> list = Lists.newArrayList();
        if (parentOrg == null) {
            return (List)ApiResultUtil.objResult((Result)respVos);
        }
        list = ((List)ApiResultUtil.objResult((Result)respVos)).stream().filter(org -> !org.getOrgCode().equals(mdmOrgReqVo.getOrgCode())).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getOrgCodeList(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(reqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setPageSize(reqVo.getPageSize());
        mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
        Result currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u5ba2\u6237\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        List respVos = (List)ApiResultUtil.objResult((Result)currentAndSubCustomerList, (boolean)true);
        return respVos;
    }

    @Override
    public PageResult<TpmFeeBudgetControlRespVo> findBudgetController(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        Set<String> selectKeys = this.feeBudgetControlService.getSelectKeys(tpmFeeBudgetControlReqVo);
        tpmFeeBudgetControlReqVo.setSelectKeys(selectKeys);
        List categoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        AssertUtils.isNotEmpty((Collection)categoriesFineEntities, (String)"\u6d3b\u52a8\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u4fe1\u606f");
        Set categoriesCodes = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List categoriesEntities = this.costTypeCategoriesMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        AssertUtils.isNotEmpty((Collection)categoriesEntities, (String)"\u5173\u8054\u6295\u5165\u7c7b\u578b\u6570\u636e\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
        Set budgetSubjectsSet = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        AssertUtils.isNotEmpty(budgetSubjectsSet, (String)"\u6295\u5165\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u9884\u7b97\u79d1\u76ee\uff0c\u65e0\u6cd5\u9009\u62e9\u9884\u7b97");
        List subjectsEntities = this.budgetSubjectsMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, budgetSubjectsSet)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        AssertUtils.isNotEmpty((Collection)subjectsEntities, (String)"\u9884\u7b97\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
        Set budgetSubjectCodes = subjectsEntities.stream().map(TpmBudgetSubjectsEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        tpmFeeBudgetControlReqVo.setOrgCodeList(reqVo.getOrgCodeList());
        tpmFeeBudgetControlReqVo.setCustomerCodeList(reqVo.getCustomerCodeList());
        tpmFeeBudgetControlReqVo.setBudgetSubjectsCodeList((List)Lists.newArrayList(budgetSubjectCodes));
        List<TpmFeeBudgetControlRespVo> respVoList = this.controlMapper.findControlList((Page<TpmFeeBudgetControlRespVo>)page, tpmFeeBudgetControlReqVo);
        this.feeBudgetControlService.convertListData(respVoList);
        return PageResult.builder().data(respVoList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAct", "#tpmLiqueurActReqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void update(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.helper.checkUpdate(tpmLiqueurActReqVo);
        LiqueurActBuilder actOperateBuilder = new LiqueurActBuilder(this.helper, tpmLiqueurActReqVo);
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.getById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        TpmLiqueurActRespVo oldData = (TpmLiqueurActRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmLiqueurActRespVo.class);
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)FeeBudgetException.DATA_NOT_EXIST, (String[])new String[0]);
        TpmLiqueurActEntity liqueurActEntity = actOperateBuilder.init().check().convert().update();
        this.sendToActivity(liqueurActEntity, tpmLiqueurActReqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmLiqueurActRespVo newData = (TpmLiqueurActRespVo)CrmBeanUtil.copy((Object)((Object)liqueurActEntity), TpmLiqueurActRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getActCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            ArrayList needDeleteIds = Lists.newArrayList();
            ArrayList cannotDeleteCodes = Lists.newArrayList();
            entities.forEach(o -> {
                if (o.getApproveStatus().equals(ActApproveStatusEnum.CREATE.getCode()) || StringUtils.isBlank((CharSequence)o.getApproveStatus())) {
                    needDeleteIds.add(o.getId());
                } else {
                    cannotDeleteCodes.add(o.getActCode());
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)cannotDeleteCodes)) {
                throw new BusinessException("\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u4e3a" + ((Object)cannotDeleteCodes).toString() + "\u7684\u6d3b\u52a8\u4e0d\u4e3a\u5f85\u63d0\u4ea4\u72b6\u6001,\u4e0d\u53ef\u5220\u9664");
            }
            this.removeByIds(needDeleteIds);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (TpmLiqueurActEntity oldData : entities) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), oldData.getId(), oldData.getActCode(), (Object)oldData);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(x -> x.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            this.updateBatchById(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(x -> x.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            this.updateBatchById(entities);
        }
    }

    @Override
    @Klock(keys={"liqueurAct", "#tpmLiqueurActReqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    @Transactional(rollbackFor={Exception.class})
    public void closed(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        List<TpmLiqueurActEntity> entities = this.helper.closed(tpmLiqueurActReqVo);
        this.updateBatchById(entities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAct", "#tpmLiqueurActReqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.helper.approve(tpmLiqueurActReqVo);
        this.update(tpmLiqueurActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        this.helper.approved(tpmLiqueurActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.REJECT.getCode());
        this.helper.reject(tpmLiqueurActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.INTERRUPT.getCode());
        this.helper.interrupt(tpmLiqueurActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmLiqueurActReqVo reqVo = new TpmLiqueurActReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.LIQUEUR_TPM.getCode()).build();
        RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(this.topic).tag("TPM_ACT_APPROVED_AND_CLOSED").bizKey("liqueurTpm").msgBody(JSON.toJSONString((Object)actSendMessageVo)).build();
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            this.approved(reqVo);
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            log.info("\u6d3b\u52a8\u5ba1\u6279\u901a\u8fc7,\u53d1\u9001MQ\u6d88\u606f,messageBody={}", (Object)rocketMQMessageBody.getMsgBody());
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.reject(reqVo);
        }
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.interrupt(reqVo);
        }
    }
}

