/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl.actbuilder;

import com.biz.crm.base.BusinessException;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetBusinessTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetRemarkEnum;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurActRegisterServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBaseBuilder;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ActRegisterBuilder
implements ActRegisterBaseBuilder {
    private TpmLiqueurActRegisterServiceHelper helper;
    private TpmLiqueurActRegisterReqVo reqVo;
    private TpmLiqueurActRegisterEntity actRegisterEntity = new TpmLiqueurActRegisterEntity();
    private TpmLiqueurActEntity actEntity;
    private Set<String> controllerIds;
    private List<TpmLiqueurActRegisterDetailBudgetEntity> registerDetailBudgetEntities = Lists.newArrayList();
    private List<TpmLiqueurActRegisterDetailEntity> registerDetailEntities = Lists.newArrayList();
    private List<TpmLiqueurActRegisterDetailAttachEntity> registerDetailAttachEntities = Lists.newArrayList();
    private List<TpmLiqueurActBudgetEntity> actBudgetEntities = Lists.newArrayList();
    private List<TpmLiqueurActBudgetTransactionEntity> actBudgetTransactionEntities = Lists.newArrayList();
    private Map<String, List<TpmLiqueurActBudgetEntity>> actBudgetEntitiesMap;
    private Map<String, TpmCostTypeCategoriesEntity> categoriesEntityMap;

    public ActRegisterBuilder(TpmLiqueurActRegisterServiceHelper helper, TpmLiqueurActRegisterReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static ActRegisterBuilder builder(TpmLiqueurActRegisterServiceHelper helper, TpmLiqueurActRegisterReqVo reqVo) {
        return new ActRegisterBuilder(helper, reqVo);
    }

    @Override
    public ActRegisterBaseBuilder init() {
        AssertUtils.isNotEmpty((String)this.reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity actEntity = this.helper.findActEntityByCode(this.reqVo.getActCode());
        AssertUtils.isNotNull((Object)((Object)actEntity), (String)"\u5f53\u524d\u6d3b\u52a8\u7533\u8bf7\u6570\u636e\u4e0d\u5b58\u5728");
        this.actEntity = actEntity;
        this.categoriesEntityMap = this.helper.findCategoriesMapByFineCode(actEntity.getFineCode());
        List<TpmLiqueurActBudgetEntity> actBudgetEntities = this.helper.findActBudgetByActCode(actEntity.getActCode());
        this.actBudgetEntities = actBudgetEntities;
        AssertUtils.isNotEmpty(actBudgetEntities, (String)"\u6d3b\u52a8\u7533\u8bf7\u7684\u9884\u7b97\u6570\u636e\u5f02\u5e38");
        this.actBudgetEntitiesMap = actBudgetEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetEntity::getControlId));
        Map<String, String> payTypeTypeMap = this.helper.getPayTypeTypeMap("pay_type_d", "pay_type_type");
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getDetailVos())) {
            this.reqVo.getDetailVos().stream().forEach(detailVo -> {
                if (CollectionUtils.isNotEmpty((Collection)detailVo.getAttachVos())) {
                    detailVo.getAttachVos().stream().forEach(attachVo -> {
                        if (StringUtils.isNotEmpty((CharSequence)attachVo.getPayType())) {
                            attachVo.setPayTypeType((String)payTypeTypeMap.get(attachVo.getPayType()));
                        }
                    });
                }
            });
        }
        return this;
    }

    @Override
    public ActRegisterBaseBuilder check() {
        AssertUtils.isNotEmpty((String)this.reqVo.getSaveType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)this.reqVo.getDetailVos(), (String)"\u8bf7\u767b\u8bb0\u6d3b\u52a8\u660e\u7ec6");
        if (ActSaveTypeEnum.getSendApproveTypes().contains(this.reqVo.getSaveType())) {
            AssertUtils.isNotEmpty((String)this.reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        }
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)this.actEntity.getApproveStatus())) {
            throw new BusinessException("\u6d3b\u52a8\u7533\u8bf7\u7684\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7,\u4e0d\u5141\u8bb8\u8fdb\u884c\u6d3b\u52a8\u767b\u8bb0");
        }
        AssertUtils.isTrue((Optional.ofNullable(this.actEntity.getCanUseAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6d3b\u52a8\u7533\u8bf7\u53ef\u7528\u4f59\u989d\u4e0d\u8db3,\u4e0d\u80fd\u8fdb\u884c\u6d3b\u52a8\u767b\u8bb0");
        Date actEndDate = DateUtil.str2Date((String)(this.actEntity.getEndDate() + " " + this.actEntity.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat);
        AssertUtils.isTrue((boolean)DateUtil.equalIsDateMoreThanAnother((Date)actEndDate, (Date)new Date()), (String)"\u5f53\u524d\u6d3b\u52a8\u5df2\u7ed3\u675f,\u4e0d\u80fd\u8fdb\u884c\u6d3b\u52a8\u767b\u8bb0");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getActRegisterCode())) {
            String registerCode = CodeUtil.createOneCode((String)"act_register");
            this.reqVo.setActRegisterCode(registerCode);
        }
        this.reqVo.setTotalAmount(BigDecimal.ZERO);
        this.reqVo.setActCode(this.actEntity.getActCode());
        this.reqVo.setActName(this.actEntity.getActName());
        this.reqVo.setFineCode(this.actEntity.getFineCode());
        this.reqVo.setFineName(this.actEntity.getFineName());
        this.reqVo.getDetailVos().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getActDetailName(), (String)"\u8bf7\u586b\u5199\u6d3b\u52a8\u660e\u7ec6\u540d\u79f0");
            AssertUtils.isNotNull((Object)o.getApplyAmount(), (String)"\u8bf7\u586b\u5199\u767b\u8bb0\u91d1\u989d");
            AssertUtils.isTrue((o.getApplyAmount().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6\u767b\u8bb0\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            AssertUtils.isNotEmpty((Collection)o.getDetailBudgetVos(), (String)"\u8bf7\u9009\u62e9\u5173\u8054\u9884\u7b97");
            if (StringUtils.isEmpty((CharSequence)o.getActDetailCode())) {
                String actDetailCode = CodeUtil.createOneCode((String)"act_register_detail");
                o.setActDetailCode(actDetailCode);
            }
            o.setActCode(this.reqVo.getActCode());
            o.setActRegisterCode(this.reqVo.getActRegisterCode());
            this.reqVo.setTotalAmount(this.reqVo.getTotalAmount().add(o.getApplyAmount()));
            this.checkDetailBudgets((TpmLiqueurActRegisterDetailReqVo)o);
            if (CollectionUtils.isNotEmpty((Collection)o.getAttachVos())) {
                this.checkDetailAttaches((TpmLiqueurActRegisterDetailReqVo)o);
            }
        });
        return this;
    }

    public void checkDetailAttaches(TpmLiqueurActRegisterDetailReqVo detailReqVo) {
        if (CollectionUtils.isNotEmpty((Collection)detailReqVo.getAttachVos())) {
            AtomicReference<BigDecimal> attachTotalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            detailReqVo.getAttachVos().forEach(o -> {
                if (!Objects.nonNull(o.getPrice()) || Objects.nonNull(o.getApplyNumber())) {
                    // empty if block
                }
                o.setActRegisterCode(this.reqVo.getActRegisterCode());
                o.setAttachCode(CodeUtil.createOneCode((String)"act_register_detail_attach"));
                o.setActDetailCode(detailReqVo.getActDetailCode());
                attachTotalAmount.getAndAccumulate(Optional.ofNullable(o.getApplyAmount()).orElse(BigDecimal.ZERO), BigDecimal::add);
            });
            if (attachTotalAmount.get().compareTo(detailReqVo.getApplyAmount()) == 1) {
                throw new BusinessException("\u9644\u52a0\u4fe1\u606f\u7684\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u660e\u7ec6\u7684\u7533\u8bf7\u91d1\u989d");
            }
        }
    }

    public void checkDetailBudgets(TpmLiqueurActRegisterDetailReqVo detailReqVo) {
        List budgetReqVos = detailReqVo.getDetailBudgetVos();
        AssertUtils.isNotEmpty((Collection)budgetReqVos, (String)("\u6d3b\u52a8\u660e\u7ec6:" + detailReqVo.getActDetailName() + ",\u672a\u9009\u62e9\u9884\u7b97"));
        Set controlIds = budgetReqVos.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getControlId())).map(TpmLiqueurActRegisterDetailBudgetReqVo::getControlId).collect(Collectors.toSet());
        AssertUtils.isNotEmpty(controlIds, (String)"\u6d3b\u52a8\u660e\u7ec6\u9009\u62e9\u7684\u8d39\u7528\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6Id\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal applyAmount = detailReqVo.getApplyAmount();
        for (String o2 : controlIds) {
            List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities = this.actBudgetEntitiesMap.get(o2);
            AssertUtils.isNotEmpty(tpmLiqueurActBudgetEntities, (String)("\u6d3b\u52a8\u660e\u7ec6:" + detailReqVo.getActDetailName() + ",\u5bf9\u5e94\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e\u5f02\u5e38,\u8bf7\u91cd\u65b0\u9009\u62e9"));
            List budgetSortedEntities = tpmLiqueurActBudgetEntities.stream().sorted(Comparator.comparing(TpmLiqueurActBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
            AssertUtils.isNotEmpty(tpmLiqueurActBudgetEntities, (String)"\u6d3b\u52a8\u9884\u7b97\u6570\u636e\u5f02\u5e38");
            for (int i = 0; i < budgetSortedEntities.size(); ++i) {
                TpmLiqueurActBudgetEntity p = (TpmLiqueurActBudgetEntity)((Object)budgetSortedEntities.get(i));
                TpmLiqueurActRegisterDetailBudgetEntity detailBudgetEntity = new TpmLiqueurActRegisterDetailBudgetEntity();
                detailBudgetEntity.setActBudgetCode(p.getActBudgetCode());
                detailBudgetEntity.setActDetailCode(detailReqVo.getActDetailCode());
                detailBudgetEntity.setActRegisterCode(this.reqVo.getActRegisterCode());
                detailBudgetEntity.setControlId(p.getControlId());
                detailBudgetEntity.setFeeBudgetCode(p.getFeeBudgetCode());
                detailBudgetEntity.setActCode(p.getActCode());
                detailBudgetEntity.setUsedAmount(BigDecimal.ZERO);
                if (ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType())) {
                    if (p.getCanUseAmount().compareTo(BigDecimal.ZERO) == 1) {
                        if (applyAmount.compareTo(p.getCanUseAmount()) >= 0) {
                            detailBudgetEntity.setUsedAmount(applyAmount.subtract(p.getCanUseAmount()));
                            applyAmount = applyAmount.subtract(p.getCanUseAmount());
                            p.setCanUseAmount(BigDecimal.ZERO);
                        } else {
                            detailBudgetEntity.setUsedAmount(applyAmount);
                            p.setCanUseAmount(p.getCanUseAmount().subtract(applyAmount));
                            applyAmount = BigDecimal.ZERO;
                        }
                    }
                    TpmLiqueurActBudgetTransactionEntity transactionEntity = new TpmLiqueurActBudgetTransactionEntity();
                    transactionEntity.setBusinessCode(this.reqVo.getActRegisterCode());
                    transactionEntity.setBusinessLineCode(detailReqVo.getActDetailCode());
                    transactionEntity.setControlId(p.getControlId());
                    transactionEntity.setBusinessLineName(detailReqVo.getActDetailName());
                    transactionEntity.setBusinessName(this.actEntity.getActName());
                    transactionEntity.setFeeAmount(BigDecimal.ZERO.subtract(detailBudgetEntity.getUsedAmount()));
                    transactionEntity.setActBudgetCode(p.getActBudgetCode());
                    transactionEntity.setBusinessType(LiqueurActBudgetBusinessTypeEnum.ACT_REGISTER.getCode());
                    transactionEntity.setTransactionType(FeeBudgetDetailTypeEnum.USE.getCode());
                    transactionEntity.setTransactionTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                    transactionEntity.setBusinessRemarks(LiqueurActBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
                    transactionEntity.setFeeBudgetCode(p.getFeeBudgetCode());
                    transactionEntity.setReduceOrder(i + 1);
                    this.actBudgetTransactionEntities.add(transactionEntity);
                }
                this.registerDetailBudgetEntities.add(detailBudgetEntity);
            }
        }
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType()) && applyAmount.compareTo(BigDecimal.ZERO) > 0) {
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6:" + detailReqVo.getActDetailName() + ",\u8d85\u8fc7\u6d3b\u52a8\u7533\u8bf7\u53ef\u7528\u4f59\u989d" + ",\u8d85\u989d\u90e8\u5206=" + applyAmount.setScale(2, 4));
        }
    }

    @Override
    public ActRegisterBaseBuilder convert() {
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)this.actRegisterEntity));
        this.actRegisterEntity.setCostFormCode(this.actEntity.getCostFormCode());
        this.actRegisterEntity.setAuditFormCode(this.actEntity.getAuditFormCode());
        this.reqVo.getDetailVos().forEach(o -> {
            TpmLiqueurActRegisterDetailEntity detailEntity = (TpmLiqueurActRegisterDetailEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmLiqueurActRegisterDetailEntity.class)));
            this.registerDetailEntities.add(detailEntity);
            detailEntity.setAuditAmount(BigDecimal.ZERO);
            detailEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
            detailEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            if (CollectionUtils.isNotEmpty((Collection)o.getAttachVos())) {
                List detailAttachEntities = CrmBeanUtil.copyList((List)o.getAttachVos(), TpmLiqueurActRegisterDetailAttachEntity.class);
                this.registerDetailAttachEntities.addAll(detailAttachEntities);
            }
        });
        return this;
    }

    @Override
    public TpmLiqueurActRegisterEntity save() {
        this.helper.saveOrUpdateActRegister(this.actRegisterEntity, this.reqVo);
        this.helper.saveActRegisterDetails(this.registerDetailEntities, this.reqVo);
        this.helper.saveActRegisterAttaches(this.registerDetailAttachEntities, this.reqVo);
        this.helper.saveActRegisterBudgets(this.registerDetailBudgetEntities, this.reqVo);
        this.helper.saveActFeeBudgets(this.actBudgetEntities, this.reqVo);
        this.helper.saveActBudgetTransactions(this.actBudgetTransactionEntities, this.reqVo);
        this.helper.updateActEntity(this.actEntity, this.reqVo);
        return this.actRegisterEntity;
    }

    @Override
    public TpmLiqueurActRegisterEntity update() {
        return this.save();
    }
}

