/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeCategoriesException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CostTypeCategoriesServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(CostTypeCategoriesServiceHelper.class);
    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;
    @Resource
    private TpmCostTypeCategoriesMapper mapper;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("financial_fee_type");
        dictCodes.add("business_fee_type");
        dictCodes.add("act_type");
        dictCodes.add("owned_sales_company");
        dictCodes.add("ERP_bookkeeping_org");
        dictCodes.add("pay_type_d");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmCostTypeCategoriesRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                List<DictItemVo> dictItemVos;
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActivityCategoriesType())) {
                    Map map1 = (Map)map.get("act_type");
                    dictItemVos = super.convertDictList(map1, o.getActivityCategoriesType());
                    o.setActivityCategoriesTypes(dictItemVos);
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayType())) {
                    Map stringMap = (Map)map.get("pay_type_d");
                    dictItemVos = super.convertDictList(stringMap, o.getPayType());
                    o.setPayTypes(dictItemVos);
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getFinancialFeeType())) {
                    o.setFinancialFeeTypeName((String)((Map)Optional.ofNullable(map.get("financial_fee_type")).orElse(Maps.newHashMap())).get(o.getFinancialFeeType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getBusinessFeeType())) {
                    o.setBusinessFeeTypeName((String)((Map)Optional.ofNullable(map.get("business_fee_type")).orElse(Maps.newHashMap())).get(o.getBusinessFeeType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getErpBookkeepingOrg())) {
                    o.setErpBookkeepingOrgDesc((String)((Map)Optional.ofNullable(map.get("ERP_bookkeeping_org")).orElse(Maps.newHashMap())).get(o.getErpBookkeepingOrg()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getOwnedSalesCompany())) {
                    o.setOwnedSalesCompanyDesc((String)((Map)Optional.ofNullable(map.get("owned_sales_company")).orElse(Maps.newHashMap())).get(o.getOwnedSalesCompany()));
                }
            });
        }
    }

    public void updateBySelectAll(TpmCostTypeCategoriesReqVo reqVo, TpmCostTypeCategoriesEntity entity) {
        this.mapper.updateBySelectAll(entity, reqVo);
    }

    public void saveCheckTpm(TpmCostTypeCategoriesReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getCategoriesName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetSubjectsCode(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97\u79d1\u76ee");
        AssertUtils.isNotEmpty((String)reqVo.getActivityCategoriesType(), (String)"\u8bf7\u9009\u62e9\u9002\u7528\u6d3b\u52a8\u7c7b\u578b");
        super.isJsonArray(reqVo.getActivityCategoriesType(), "\u9002\u7528\u6d3b\u52a8\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u7ec4\u7684json\u5b57\u7b26\u4e32\uff01");
        if (StringUtils.isEmpty((CharSequence)reqVo.getCategoriesCode())) {
            reqVo.setCategoriesCode(CodeUtil.createOneCode((String)"tpm_cost_type_categories"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList rangeVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getContainOrgRangeVos())) {
            rangeVos.addAll(reqVo.getContainOrgRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getNonContainOrgRangeVos())) {
            rangeVos.addAll(reqVo.getNonContainOrgRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getContainOrgTypeRangeVos())) {
            rangeVos.addAll(reqVo.getContainOrgTypeRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getNonContainOrgTypeRangeVos())) {
            rangeVos.addAll(reqVo.getNonContainOrgTypeRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)rangeVos)) {
            HashSet rangeSet = Sets.newHashSet();
            rangeVos.stream().forEach(o -> {
                AssertUtils.isNotNull((Object)o.getRangeType(), (String)"\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotNull((Object)o.getRangeCode(), (String)"\u8303\u56f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (Objects.equals(1, o.getRangeType())) {
                    AssertUtils.isNotEmpty((String)o.getIsOnlyCurrent(), (String)"\u7ec4\u7ec7\u8303\u56f4\u4fe1\u606f\u7684\u8303\u56f4\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                }
                rangeSet.add(o.getRangeType() + o.getRangeCode());
            });
            AssertUtils.isTrue((rangeVos.size() == rangeSet.size() ? 1 : 0) != 0, (String)"\u8303\u56f4\u4fe1\u606f\u91cd\u590d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        reqVo.setRangeVos((List)rangeVos);
        if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getFineVos())) {
            HashSet set = Sets.newHashSet();
            reqVo.getFineVos().forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u5173\u8054\u7684\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                set.add(o.getFineCode());
            });
            AssertUtils.isTrue((set.size() == reqVo.getFineVos().size() ? 1 : 0) != 0, (String)"\u5173\u8054\u7ec6\u7c7b\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmCostTypeCategoriesReqVo reqVo) {
        Integer count;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeCategoriesEntity::getCategoriesCode, (Object)reqVo.getCategoriesCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        AssertUtils.isTrue(((count = this.mapper.selectCount((Wrapper)wrapper)) == 0 ? 1 : 0) != 0, (CrmExceptionType)CostTypeCategoriesException.DATA_CODE_DUPLICATE, (String[])new String[0]);
    }

    public void saveRanges(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<Object> ids = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getRangeVos())) {
                ids = reqVo.getRangeVos().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeCategoriesRangeEntity::getCategoriesCode, (Object)reqVo.getCategoriesCode())).notIn(CollectionUtils.isNotEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids);
            this.rangeMapper.delete((Wrapper)queryWrapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getRangeVos())) {
            List rangeEntities = reqVo.getRangeVos().stream().map(o -> {
                TpmCostTypeCategoriesRangeEntity rangeEntity = new TpmCostTypeCategoriesRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)rangeEntity));
                rangeEntity.setCategoriesCode(reqVo.getCategoriesCode());
                return rangeEntity;
            }).collect(Collectors.toList());
            this.rangeService.saveOrUpdateBatch(rangeEntities);
        }
    }

    public void saveFines(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<Object> ids = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getFineVos())) {
                ids = reqVo.getFineVos().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper fineWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeCategoriesFineEntity::getCategoriesCode, (Object)reqVo.getCategoriesCode())).notIn(CollectionUtils.isNotEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids);
            this.fineMapper.delete((Wrapper)fineWrapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getFineVos())) {
            List fineEntities = reqVo.getFineVos().stream().map(o -> {
                TpmCostTypeCategoriesFineEntity fineEntity = new TpmCostTypeCategoriesFineEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fineEntity));
                fineEntity.setCategoriesCode(reqVo.getCategoriesCode());
                return fineEntity;
            }).collect(Collectors.toList());
            this.fineService.saveOrUpdateBatch(fineEntities);
        }
    }

    public void deleteCheck(TpmCostTypeCategoriesReqVo reqVo) {
        List<String> categoriesCode = this.mapper.findActByParams(reqVo);
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty(categoriesCode)) {
            categoriesCode.forEach(o -> errorMsg.append((String)o).append(","));
            errorMsg.append("]").append(",\u5df2\u5b58\u5728\u6d3b\u52a8\u7533\u8bf7\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664");
            throw new BusinessException(errorMsg.toString());
        }
    }

    public void saveCheck(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.equals((CharSequence)TpmProjectNameEnum.LIQUEUR_TPM.getCode(), (CharSequence)reqVo.getTpmProjectName())) {
            this.saveCheckLiqueurTpm(reqVo);
        } else {
            this.saveCheckTpm(reqVo);
        }
    }

    private void saveCheckLiqueurTpm(TpmCostTypeCategoriesReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getCategoriesName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetSubjectsCode(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97\u79d1\u76ee");
        TpmBudgetSubjectsEntity subjectsEntity = (TpmBudgetSubjectsEntity)((Object)this.budgetSubjectsMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode())));
        AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)("\u9884\u7b97\u79d1\u76ee:" + reqVo.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728"));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)subjectsEntity.getIsActBudget()), (String)"\u8be5\u9884\u7b97\u79d1\u76ee\u4e0d\u4e3a\u6d3b\u52a8\u9884\u7b97,\u4e0d\u53ef\u9009\u62e9");
        AssertUtils.isNotEmpty((String)reqVo.getFinanceSubjectCode(), (String)"\u8bf7\u9009\u62e9\u8d22\u52a1\u79d1\u76ee");
        TpmFinanceSubjectEntity financeSubjectEntity = (TpmFinanceSubjectEntity)((Object)this.financeSubjectMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmFinanceSubjectEntity::getFinanceSubjectCode, (Object)reqVo.getFinanceSubjectCode())));
        AssertUtils.isNotNull((Object)((Object)financeSubjectEntity), (String)("\u8d22\u52a1\u79d1\u76ee:" + reqVo.getFinanceSubjectCode() + "\u4e0d\u5b58\u5728"));
        AssertUtils.isNotEmpty((String)reqVo.getPayType(), (String)"\u8bf7\u9009\u62e9\u652f\u4ed8\u7c7b\u578b");
        super.isJsonArray(reqVo.getPayType(), "\u652f\u4ed8\u7c7b\u578b\u5fc5\u987b\u662fJson\u5b57\u7b26\u4e32");
        AssertUtils.isNotEmpty((String)reqVo.getOwnedSalesCompany(), (String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u9500\u552e\u516c\u53f8");
        if (StringUtils.isEmpty((CharSequence)reqVo.getCategoriesCode())) {
            reqVo.setCategoriesCode(CodeUtil.createOneCode((String)"tpm_cost_type_categories"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkDataExist(reqVo);
    }
}

