/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmAuditDetailController"})
@Api(tags={"\u6838\u9500\u7533\u8bf7\u660e\u7ec6\u8868 "})
public class TpmAuditDetailController {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditDetailController.class);
    @Autowired
    private ITpmAuditDetailService tpmAuditDetailService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmAuditDetailRespVo>> list(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        PageResult<TpmAuditDetailRespVo> result = this.tpmAuditDetailService.findList(tpmAuditDetailReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u751f\u6210\u4e0a\u8d26\u603b\u5355\u53f7")
    @GetMapping(value={"/generateAccountCode"})
    @CrmLog
    public Result generateAccountCode(@RequestParam(value="num") Integer num) {
        List codeList = CodeUtil.createCodeList((String)"tpm_account_detail", (int)num);
        return Result.ok((Object)codeList);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        this.tpmAuditDetailService.save(tpmAuditDetailReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        this.tpmAuditDetailService.update(tpmAuditDetailReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmAuditDetailService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmAuditDetailService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmAuditDetailService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

