/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CostTypeFineServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(CostTypeFineServiceHelper.class);
    @Resource
    private TpmCostTypeFineMapper mapper;
    @Resource
    private TpmAuditCollectExampleMapper exampleMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("activity_release_need");
        dictCodes.add("activity_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmCostTypeFineRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActivityReleaseNeed())) {
                    o.setActivityReleaseNeedName((String)((Map)Optional.ofNullable(map.get("activity_release_need")).orElse(Maps.newHashMap())).get(o.getActivityReleaseNeed()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActivityType())) {
                    o.setActivityTypeName((String)((Map)Optional.ofNullable(map.get("activity_type")).orElse(Maps.newHashMap())).get(o.getActivityType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayTypeList())) {
                    o.setPayTypeName((String)((Map)Optional.ofNullable(map.get("pay_type_d")).orElse(Maps.newHashMap())).get(o.getPayTypeList()));
                }
                o.setIsAuditEsc(GlobalWhetherEnum.getDesByCode((String)o.getIsAudit()));
                o.setIsSendSfaEsc(GlobalWhetherEnum.getDesByCode((String)o.getIsSendSfa()));
                o.setIsReviewActivityDetailsEsc(GlobalWhetherEnum.getDesByCode((String)o.getIsReviewActivityDetails()));
                o.setIsSpanOrgBudgetEsc(GlobalWhetherEnum.getDesByCode((String)o.getIsSpanOrgBudget()));
            });
        }
    }

    public LambdaQueryWrapper<TpmCostTypeFineEntity> getQueryWrapper(TpmCostTypeFineReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getFineCode()), TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getFineName()), TpmCostTypeFineEntity::getFineName, (Object)reqVo.getFineName());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmCostTypeFineReqVo reqVo, TpmCostTypeFineEntity entity) {
        LambdaQueryWrapper<TpmCostTypeFineEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.mapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(reqVo.getTpmProjectName())) {
            this.saveCheckLiqueurTpm(reqVo);
        } else {
            this.saveCheckBaseTpm(reqVo);
        }
    }

    public void checkDataExist(TpmCostTypeFineReqVo reqVo) {
        Integer count;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        AssertUtils.isTrue(((count = this.mapper.selectCount((Wrapper)wrapper)) == 0 ? 1 : 0) != 0, (CrmExceptionType)CostTypeFineException.DATA_CODE_DUPLICATE, (String[])new String[0]);
    }

    public List<TpmAuditCollectExampleRespVo> getExamples(String listJson) {
        List codes = JSON.parseArray((String)listJson, String.class);
        if (CollectionUtils.isEmpty((Collection)codes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExampleEntity::getExampleCode, (Collection)codes);
        return this.exampleMapper.selectList((Wrapper)queryWrapper).stream().filter(Objects::nonNull).map(o -> {
            TpmAuditCollectExampleRespVo vo = new TpmAuditCollectExampleRespVo();
            vo.setExampleCode(o.getExampleCode());
            vo.setExampleName(o.getExampleName());
            return vo;
        }).collect(Collectors.toList());
    }

    public List<DictItemVo> getPayTypes(String payTypeList) {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        Map map = Optional.ofNullable(dictValueMapsByCodes.get("pay_type_d")).orElse(Maps.newHashMap());
        List codes = JSON.parseArray((String)payTypeList, String.class);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = (String)map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                list.add(dictItemVo);
            });
        }
        return list;
    }

    private void saveCheckBaseTpm(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getFineCode())) {
            reqVo.setFineCode(CodeUtil.createOneCode((String)"tpm_cost_type_fine"));
        }
        if (reqVo.getAuditValidity() != null) {
            AssertUtils.isTrue((reqVo.getAuditValidity() > 0 ? 1 : 0) != 0, (String)"\u6838\u9500\u6709\u6548\u671f(\u6708)\u5fc5\u987b\u5927\u4e8e0");
        }
        if (reqVo.getExtraAuditRatio() != null) {
            AssertUtils.isTrue((reqVo.getExtraAuditRatio().compareTo(BigDecimal.ZERO) != -1 ? 1 : 0) != 0, (String)"\u8d85\u989d\u6838\u9500\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        AssertUtils.isNotEmpty((String)reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFineName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0");
        super.isJsonArray(reqVo.getPayTypeList(), "\u652f\u4ed8\u65b9\u5f0f\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        super.isJsonArray(reqVo.getCollectRequireList(), "\u91c7\u96c6\u8981\u6c42\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        super.isJsonArray(reqVo.getAuditRequireList(), "\u6838\u9500\u8d44\u6599\u8981\u6c42\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAudit())) {
            reqVo.setIsAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)reqVo.getIsAudit()) && StringUtils.isEmpty((CharSequence)reqVo.getIsAutoAudit())) {
            reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAllowRepeatAudit())) {
            reqVo.setIsAllowRepeatAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsSendSfa())) {
            reqVo.setIsSendSfa(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsShareToProduct())) {
            reqVo.setIsShareToProduct(GlobalWhetherEnum.NO.getCode());
        }
        this.checkDataExist(reqVo);
    }

    private void saveCheckLiqueurTpm(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getFineCode())) {
            reqVo.setFineCode(CodeUtil.createOneCode((String)"tpm_cost_type_fine"));
        }
        if (reqVo.getAuditValidity() != null) {
            AssertUtils.isTrue((reqVo.getAuditValidity() > 0 ? 1 : 0) != 0, (String)"\u6838\u9500\u6709\u6548\u671f(\u6708)\u5fc5\u987b\u5927\u4e8e0");
        }
        if (reqVo.getExtraAuditRatio() != null) {
            AssertUtils.isTrue((reqVo.getExtraAuditRatio().compareTo(BigDecimal.ZERO) != -1 ? 1 : 0) != 0, (String)"\u8d85\u989d\u6838\u9500\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        AssertUtils.isNotEmpty((String)reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFineName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getCostFormCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b\u8868\u5355");
        AssertUtils.isNotEmpty((String)reqVo.getIsSpanOrgBudget(), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u8de8\u7ec4\u7ec7\u5360\u7528\u9884\u7b97");
        AssertUtils.isNotEmpty((String)reqVo.getCostFormCode(), (String)"\u8bf7\u786e\u8ba4\u6d3b\u52a8\u660e\u7ec6\u8868\u5355");
        AssertUtils.isNotEmpty((String)reqVo.getAuditFormCode(), (String)"\u8bf7\u786e\u8ba4\u6d3b\u52a8\u6838\u9500\u8868\u5355");
        AssertUtils.isNotEmpty((String)reqVo.getIsSendSfa(), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u63a8\u9001SFA");
        AssertUtils.isNotEmpty((String)reqVo.getIsNeedCollectData(), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u91c7\u96c6\u8d44\u6599");
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAudit())) {
            reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsNeedAuditData())) {
            reqVo.setIsNeedAuditData(GlobalWhetherEnum.YES.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAutoAudit())) {
            reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
        }
        AssertUtils.isTrue((boolean)CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getTpmCostTypeCategoriesFineReqVo()), (String)"\u8bf7\u9009\u62e9\u6295\u5165\u7c7b\u578b\u8fdb\u884c\u5173\u8054");
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAutoAudit())) {
            reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        ArrayList rangeVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getContainOrgRangeVos())) {
            rangeVos.addAll(reqVo.getContainOrgRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getNonContainOrgRangeVos())) {
            rangeVos.addAll(reqVo.getNonContainOrgRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getContainOrgTypeRangeVos())) {
            rangeVos.addAll(reqVo.getContainOrgTypeRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getNonContainOrgTypeRangeVos())) {
            rangeVos.addAll(reqVo.getNonContainOrgTypeRangeVos());
        }
        if (CollectionUtils.isNotEmpty((Collection)rangeVos)) {
            HashSet rangeSet = Sets.newHashSet();
            rangeVos.stream().forEach(o -> {
                AssertUtils.isNotNull((Object)o.getRangeType(), (String)"\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotNull((Object)o.getRangeCode(), (String)"\u8303\u56f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (Objects.equals(1, o.getRangeType())) {
                    AssertUtils.isNotEmpty((String)o.getIsOnlyCurrent(), (String)"\u7ec4\u7ec7\u8303\u56f4\u4fe1\u606f\u7684\u8303\u56f4\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                }
                rangeSet.add(o.getRangeType() + o.getRangeCode());
            });
            AssertUtils.isTrue((rangeVos.size() == rangeSet.size() ? 1 : 0) != 0, (String)"\u8303\u56f4\u4fe1\u606f\u91cd\u590d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        reqVo.setRangeVos((List)rangeVos);
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAllowRepeatAudit())) {
            reqVo.setIsAllowRepeatAudit(GlobalWhetherEnum.NO.getCode());
        }
        this.checkCategoriesAssociatedData(reqVo);
        this.checkDataExist(reqVo);
    }

    public void saveCategoriesAssociatedData(TpmCostTypeFineReqVo reqVo) {
        List<Object> ids;
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            ids = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getRangeVos())) {
                ids = reqVo.getRangeVos().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeCategoriesRangeEntity::getCategoriesCode, (Object)reqVo.getFineCode())).notIn(CollectionUtils.isNotEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids);
            this.rangeMapper.delete((Wrapper)queryWrapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getRangeVos())) {
            List rangeEntities = reqVo.getRangeVos().stream().map(o -> {
                TpmCostTypeCategoriesRangeEntity rangeEntity = new TpmCostTypeCategoriesRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)rangeEntity));
                rangeEntity.setCategoriesCode(reqVo.getFineCode());
                return rangeEntity;
            }).collect(Collectors.toList());
            this.rangeService.saveOrUpdateBatch(rangeEntities);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            ids = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getTpmCostTypeCategoriesFineReqVo())) {
                ids = reqVo.getTpmCostTypeCategoriesFineReqVo().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper fineWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getFineCode())).notIn(CollectionUtils.isNotEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids);
            this.fineMapper.delete((Wrapper)fineWrapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getTpmCostTypeCategoriesFineReqVo())) {
            List fineEntities = reqVo.getTpmCostTypeCategoriesFineReqVo().stream().map(o -> {
                TpmCostTypeCategoriesFineEntity fineEntity = new TpmCostTypeCategoriesFineEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fineEntity));
                fineEntity.setFineCode(reqVo.getFineCode());
                return fineEntity;
            }).collect(Collectors.toList());
            this.fineService.saveOrUpdateBatch(fineEntities);
        }
    }

    public void checkCategoriesAssociatedData(TpmCostTypeFineReqVo reqVo) {
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getTpmCostTypeCategoriesFineReqVo())) {
            HashSet set = Sets.newHashSet();
            reqVo.getTpmCostTypeCategoriesFineReqVo().forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getCategoriesCode(), (String)"\u6d3b\u52a8\u7c7b\u578b\u5173\u8054\u7684\u6295\u5165\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                set.add(o.getCategoriesCode());
            });
            AssertUtils.isTrue((set.size() == reqVo.getTpmCostTypeCategoriesFineReqVo().size() ? 1 : 0) != 0, (String)"\u5173\u8054\u7ec6\u7c7b\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
    }
}

