/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetBusinessTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetRemarkEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActFileMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActFileRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmLiqueurServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurServiceHelper.class);
    @Resource
    private MdmOrgFeign orgFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmLiqueurAuditMapper auditMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService detailsService;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterMapper liqueurActRegisterMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper registerDetailMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Autowired
    private TpmLiqueurActBudgetService liqueurActBudgetService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private TpmLiqueurActFileMapper liqueurActFileMapper;
    @Resource
    private TpmLiqueurActRegisterMapper actRegisterMapper;
    @Resource
    private TpmLiqueurActMapper liqueurActMapper;
    @Autowired
    private ITpmLiqueurActBudgetTransactionService transactionService;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper transactionMapper;
    @Resource
    private TpmLiqueurAuditMapper liqueurAuditMapper;
    @Resource
    private ActServiceHelper serviceHelper;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("act_approve_status");
        dictCodes.add("enable_status");
        dictCodes.add("yesOrNo");
        dictCodes.add("owned_sales_company");
        dictCodes.add("budget_year");
        dictCodes.add("budget_mouth");
        dictCodes.add("budget_quater");
        dictCodes.add("fee_budget_type");
        dictCodes.add("pay_type_d");
        dictCodes.add("control_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setRespVoData(List<TpmLiqueurActRespVo> respVoList) {
        Map<String, Map<String, String>> dataMaps = this.getDictMaps();
        respVoList.forEach(respVo -> {
            if (StringUtils.isNotEmpty((CharSequence)respVo.getApproveStatus())) {
                respVo.setApproveStatusName((String)((Map)Optional.ofNullable(dataMaps.get("act_approve_status")).orElse(Maps.newHashMap())).get(respVo.getApproveStatus()));
            }
            if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
                respVo.setEnableStatusName((String)((Map)Optional.ofNullable(dataMaps.get("enable_status")).orElse(Maps.newHashMap())).get(respVo.getEnableStatus()));
            }
            this.setIsAllowRegisterDetail((TpmLiqueurActRespVo)respVo);
        });
    }

    private void setIsAllowRegisterDetail(TpmLiqueurActRespVo respVo) {
        if (Optional.ofNullable(respVo.getCanUseAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) > 0 && StringUtils.equals((CharSequence)respVo.getApproveStatus(), (CharSequence)ActApproveStatusEnum.APPROVED.getCode())) {
            AssertUtils.isNotEmpty((String)respVo.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            String date = DateUtil.formatDate() + " " + DateUtil.formatShortTime();
            if (respVo.getEndDate().compareTo(date) > 0) {
                respVo.setIsAllowRegisterDetail(GlobalWhetherEnum.YES.getCode());
                return;
            }
        }
        respVo.setIsAllowRegisterDetail(GlobalWhetherEnum.NO.getCode());
    }

    public List<TpmBudgetSubjectsEntity> getTpmBudgetSubjectsEntities(Set<String> subjectBudgetCodes) {
        AssertUtils.isNotEmpty(subjectBudgetCodes, (String)"\u67e5\u8be2\u9884\u7b97\u79d1\u76ee\u7684code \u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List entities = this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectBudgetCodes));
        if (CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("\u9884\u7b97\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return entities;
    }

    public void saveOrUpdateAct(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)liqueurActEntity.getApproveStatus())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)liqueurActEntity.getId())) {
            this.liqueurActMapper.updateById((Object)liqueurActEntity);
        } else {
            this.liqueurActMapper.insert((Object)liqueurActEntity);
        }
    }

    public void saveActBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActReqVo reqVo) {
        List actBudgetEntityList = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)reqVo.getActCode()));
        if (CollectionUtils.isEmpty((Collection)actBudgetEntityList)) {
            this.liqueurActBudgetService.saveBatch(actBudgetEntities);
            return;
        }
        ArrayList needSaveEntities = Lists.newArrayList();
        ArrayList needUpdateEntities = Lists.newArrayList();
        actBudgetEntities.forEach(o -> actBudgetEntityList.forEach(x -> {
            if (o.getFeeBudgetCode().equals(x.getFeeBudgetCode())) {
                x.setApplyAmount(o.getApplyAmount());
                needUpdateEntities.add(x);
            } else {
                needSaveEntities.add(o);
            }
        }));
        this.liqueurActBudgetService.saveBatch(needSaveEntities);
        this.liqueurActBudgetService.updateBatchById(needUpdateEntities);
    }

    public void saveActFiles(List<TpmLiqueurActFileEntity> liqueurActFileEntities, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = liqueurActFileEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.liqueurActFileMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActFileEntity::getActCode, (Object)reqVo.getActCode()));
        }
        liqueurActFileEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.liqueurActFileMapper.insert(o);
            } else {
                this.liqueurActFileMapper.updateById(o);
            }
        });
    }

    public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
    }

    public void saveBudgetController(List<TpmFeeBudgetControlEntity> feeBudgetControlEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        for (TpmFeeBudgetControlEntity o : feeBudgetControlEntities) {
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
            this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        }
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActEntity entity, TpmLiqueurActReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurActCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void setBudgetData(TpmLiqueurActRespVo actRespVo) {
        List liqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)liqueurActBudgetEntities)) {
            List respVos = CrmBeanUtil.copyList((List)liqueurActBudgetEntities, TpmLiqueurActBudgetRespVo.class);
            actRespVo.setBudgetVos(respVos);
            Map<String, List<TpmLiqueurActBudgetRespVo>> actBudgetGroupMap = respVos.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetRespVo::getControlId));
            HashMap controllerAndAmount = Maps.newHashMap();
            HashSet idSet = Sets.newHashSet();
            HashSet budgetCodes = Sets.newHashSet();
            actBudgetGroupMap.keySet().forEach(x -> {
                BigDecimal applyAmount = ((List)actBudgetGroupMap.get(x)).stream().map(TpmLiqueurActBudgetRespVo::getApplyAmount).reduce(BigDecimal::add).get();
                idSet.add(x);
                controllerAndAmount.put(x, applyAmount);
                if (StringUtils.isNotBlank((CharSequence)((TpmLiqueurActBudgetRespVo)((List)actBudgetGroupMap.get(x)).get(0)).getBudgetSubjectsCode())) {
                    budgetCodes.add(((TpmLiqueurActBudgetRespVo)((List)actBudgetGroupMap.get(x)).get(0)).getBudgetSubjectsCode());
                }
            });
            Map<Object, Object> subjectsEntityMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)budgetCodes)) {
                List subjectsEntities = this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Collection)budgetCodes));
                subjectsEntityMap = subjectsEntities.stream().collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, Function.identity()));
            }
            if (CollectionUtils.isEmpty((Collection)idSet)) {
                return;
            }
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(idSet);
            List controlEntities = this.feeBudgetControlMapper.selectBatchIds(idSet);
            List feeBudgetRespVos = CrmBeanUtil.copyList(feeBudgetEntities, TpmFeeBudgetRespVo.class);
            Map<String, List<TpmFeeBudgetRespVo>> feeBudgetMaps = feeBudgetRespVos.stream().collect(Collectors.groupingBy(TpmFeeBudgetRespVo::getControlId));
            Map<String, Map<String, String>> map = this.getDictMaps();
            ArrayList controlRespVos = Lists.newArrayList();
            Map<Object, Object> finalSubjectsEntityMap = subjectsEntityMap;
            controlEntities.forEach(x -> {
                TpmFeeBudgetControlRespVo vo = (TpmFeeBudgetControlRespVo)CrmBeanUtil.copy((Object)x, TpmFeeBudgetControlRespVo.class);
                if (controllerAndAmount.containsKey(vo.getId())) {
                    vo.setApplyAmount((BigDecimal)controllerAndAmount.get(x.getId()));
                }
                if (finalSubjectsEntityMap.containsKey(x.getBudgetSubjectsCode())) {
                    vo.setBudgetSubjectsName(((TpmBudgetSubjectsEntity)((Object)((Object)finalSubjectsEntityMap.get(x.getBudgetSubjectsCode())))).getBudgetSubjectsName());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBudgetYear())) {
                    vo.setBudgetYearName((String)((Map)Optional.ofNullable(map.get("budget_year")).orElse(Maps.newHashMap())).get(vo.getBudgetYear()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBudgetMonth())) {
                    vo.setBudgetMonthName((String)((Map)Optional.ofNullable(map.get("budget_mouth")).orElse(Maps.newHashMap())).get(vo.getBudgetMonth()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBudgetQuater())) {
                    vo.setBudgetQuaterName((String)((Map)Optional.ofNullable(map.get("budget_quater")).orElse(Maps.newHashMap())).get(vo.getBudgetQuater()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getFeeBudgetType())) {
                    vo.setFeeBudgetTypeName((String)((Map)Optional.ofNullable(map.get("fee_budget_type")).orElse(Maps.newHashMap())).get(vo.getFeeBudgetType()));
                }
                if (feeBudgetMaps.containsKey(vo.getId())) {
                    ((List)feeBudgetMaps.get(vo.getId())).forEach(o -> {
                        o.setBudgetSubjectsName(vo.getBudgetSubjectsName());
                        if (finalSubjectsEntityMap.containsKey(vo.getBudgetSubjectsCode())) {
                            o.setControlType(((TpmBudgetSubjectsEntity)((Object)((Object)((Object)finalSubjectsEntityMap.get(vo.getBudgetSubjectsCode()))))).getControlType());
                            if (StringUtils.isNotBlank((CharSequence)o.getControlType())) {
                                o.setBudgetSubjectsControlType((String)((Map)Optional.ofNullable(map.get("control_type")).orElse(Maps.newHashMap())).get(o.getControlType()));
                            }
                            if (StringUtils.isNotBlank((CharSequence)o.getBudgetYear())) {
                                o.setBudgetYearName((String)((Map)Optional.ofNullable(map.get("budget_year")).orElse(Maps.newHashMap())).get(o.getBudgetYear()));
                            }
                            if (StringUtils.isNotBlank((CharSequence)o.getBudgetMonth())) {
                                o.setBudgetMonthName((String)((Map)Optional.ofNullable(map.get("budget_mouth")).orElse(Maps.newHashMap())).get(o.getBudgetMonth()));
                            }
                            if (StringUtils.isNotBlank((CharSequence)o.getBudgetQuater())) {
                                o.setBudgetQuaterName((String)((Map)Optional.ofNullable(map.get("budget_quater")).orElse(Maps.newHashMap())).get(o.getBudgetQuater()));
                            }
                        }
                    });
                    vo.setFeeBudgetVos((List)feeBudgetMaps.get(vo.getId()));
                }
                controlRespVos.add(vo);
            });
            actRespVo.setEditBudgetVos((List)controlRespVos);
        }
    }

    public void setActFileData(TpmLiqueurActRespVo actRespVo) {
        List fileEntities = this.liqueurActFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActFileEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)fileEntities)) {
            List fileRespVos = CrmBeanUtil.copyList((List)fileEntities, TpmLiqueurActFileRespVo.class);
            actRespVo.setFileVos(fileRespVos);
        }
    }

    public void checkUpdate(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public TpmLiqueurActEntity saveCheckActStatus(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActEntity::getActCode, (Object)reqVo.getActCode())));
        if (actEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u6d3b\u52a8\u7533\u8bf7\u4fe1\u606f");
        }
        if (!actEntity.getApproveStatus().equals(ActApproveStatusEnum.APPROVED.getCode())) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u6d3b\u52a8\u624d\u53ef\u4ee5\u65b0\u589e\u6d3b\u52a8\u660e\u7ec6");
        }
        return actEntity;
    }

    public void checkOrgAndCus(TpmLiqueurActReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty((CharSequence)userRedis.getOrgcode()) && CollectionUtils.isNotEmpty((Collection)reqVo.getOrgCodeList())) {
            MdmOrgRespVo orgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(userRedis.getOrgcode()), (boolean)true);
            MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
            if (StringUtils.equals((CharSequence)reqVo.getIsCrossOrg(), (CharSequence)GlobalWhetherEnum.YES.getCode()) && StringUtils.isNotEmpty((CharSequence)orgRespVo.getParentCode())) {
                mdmOrgReqVo.setParentCode(orgRespVo.getParentCode());
                List orgRespVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findOrgList(mdmOrgReqVo), (boolean)true);
                List orgCodes = orgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                MdmOrgReqVo mdmOrgReqVoByReq = new MdmOrgReqVo();
                mdmOrgReqVoByReq.setOrgCodeList(orgCodes);
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVoByReq), (boolean)true);
                Map orgCodeMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(), (k1, k2) -> k1));
                ArrayList orgCodeList = Lists.newArrayList(orgCodeMap.keySet());
                orgCodeList.retainAll(reqVo.getOrgCodeList());
                if (orgCodeList.size() != reqVo.getOrgCodeList().size()) {
                    reqVo.getOrgCodeList().removeAll(orgCodeList);
                    throw new BusinessException(reqVo.getOrgCodeList() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                }
                ArrayList orgNameList = Lists.newArrayList();
                orgCodeList.forEach(o -> orgNameList.add(((MdmOrgRespVo)orgCodeMap.get(o)).getOrgName()));
                reqVo.setOrgName(JsonPropertyUtil.toJsonString((Object)orgNameList));
            } else {
                mdmOrgReqVo.setOrgCodeList((Collection)reqVo.getOrgCodeList());
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVo), (boolean)true);
                Map orgRespVoMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(), (k1, k2) -> k1));
                ArrayList orgNameList = Lists.newArrayList();
                orgRespVoMap.keySet().forEach(o -> {
                    if (!StringUtils.startsWith((CharSequence)((MdmOrgRespVo)orgRespVoMap.get(o)).getRuleCode(), (CharSequence)orgRespVo.getRuleCode())) {
                        throw new BusinessException(((MdmOrgRespVo)orgRespVoMap.get(o)).getOrgCode() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                    }
                    orgNameList.add(((MdmOrgRespVo)orgRespVoMap.get(o)).getOrgName());
                });
                reqVo.setOrgName(JsonPropertyUtil.toJsonString((Object)orgNameList));
            }
            reqVo.setOrgCode(JsonPropertyUtil.toJsonString((Object)reqVo.getOrgCodeList()));
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getCustomerCodeList())) {
                MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
                mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
                List customerMsgRespVos = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo), (boolean)true);
                Map cusMap = customerMsgRespVos.stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity(), (k1, k2) -> k1));
                ArrayList codeList = Lists.newArrayList(cusMap.keySet());
                codeList.retainAll(reqVo.getCustomerCodeList());
                if (codeList.size() != reqVo.getCustomerCodeList().size()) {
                    reqVo.getCustomerCodeList().removeAll(codeList);
                    throw new BusinessException(reqVo.getCustomerCodeList() + "\u8be5\u5ba2\u6237\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185");
                }
                ArrayList cusNameList = Lists.newArrayList();
                codeList.forEach(o -> cusNameList.add(((MdmCustomerMsgRespVo)cusMap.get(o)).getCustomerName()));
                reqVo.setCustomerName(JsonPropertyUtil.toJsonString((Object)cusNameList));
                reqVo.setCustomerCode(JsonPropertyUtil.toJsonString((Object)reqVo.getCustomerCodeList()));
            }
        }
    }

    public void checkBudgetData(TpmLiqueurActReqVo reqVo) {
        Set<String> controllerIds = reqVo.getBudgetControlVos().stream().map(UuidVo::getId).collect(Collectors.toSet());
        List<TpmFeeBudgetControlEntity> controlEntities = this.findControlByIds(controllerIds);
        if (reqVo.getBudgetControlVos().size() != controlEntities.size()) {
            throw new BusinessException("\u9884\u7b97\u6570\u636e\u5f02\u5e38,\u9884\u7b97\u4e0d\u5b58\u5728");
        }
    }

    public void checkBudgets(TpmLiqueurActReqVo reqVo) {
        TpmCostTypeFineEntity fineEntity = this.findFineEntity(reqVo.getFineCode());
        reqVo.setFineName(fineEntity.getFineName());
        List categoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        if (CollectionUtils.isEmpty((Collection)categoriesFineEntities)) {
            throw new BusinessException(reqVo.getFineCode() + "\u6d3b\u52a8\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u6295\u5165\u7c7b\u578b\uff0c\u65e0\u6cd5\u9009\u62e9\u9884\u7b97");
        }
        Set<Object> categoriesSets = Sets.newHashSet();
        categoriesSets = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List categoriesEntities = this.tpmCostTypeCategoriesMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesSets));
        if (CollectionUtils.isEmpty((Collection)categoriesEntities)) {
            throw new BusinessException("\u5173\u8054\u6295\u5165\u7c7b\u578b\u4e0d\u5b58\u5728,\u65e0\u6cd5\u83b7\u53d6\u9884\u7b97");
        }
        Set budgetSubjectSetByCate = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetSubjectSetByCate)) {
            throw new BusinessException("\u6295\u5165\u7c7b\u578b\u6570\u636e\u5f02\u5e38\u6ca1\u6709\u9884\u7b97\u79d1\u76ee");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getBudgetControlVos(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        List feeBudgetControlRespVoList = this.feeBudgetControlService.findList(tpmFeeBudgetControlReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)feeBudgetControlRespVoList)) {
            throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u53ef\u7528\u9884\u7b97");
        }
        Set budgetSubjectSets = reqVo.getBudgetControlVos().stream().map(TpmFeeBudgetControlRespVo::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (!budgetSubjectSetByCate.containsAll(budgetSubjectSets)) {
            throw new BusinessException("\u9884\u7b97\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getOrgCodeList())) {
            List feeBudgetControlEntities;
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmFeeBudgetControlEntity::getOrgCode, (Collection)reqVo.getOrgCodeList());
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getCustomerCodeList())) {
                wrapper.in(TpmFeeBudgetControlEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList());
            }
            if (CollectionUtils.isEmpty((Collection)(feeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)wrapper)))) {
                throw new BusinessException("\u6839\u636e\u7ec4\u7ec7\u3001\u5ba2\u6237\u6240\u9009\u9884\u7b97\u4e0d\u5b58\u5728");
            }
            Set controlIds = feeBudgetControlEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
            Map<String, String> reqControlMap = reqVo.getBudgetControlVos().stream().collect(Collectors.toMap(UuidVo::getId, TpmFeeBudgetControlRespVo::getFeeBudgetCodes, (k1, k2) -> k1));
            controlIds.retainAll(reqControlMap.keySet());
            if (controlIds.size() != reqControlMap.keySet().size()) {
                reqControlMap.keySet().removeAll(controlIds);
                ArrayList feeBudgetCodesList = Lists.newArrayList();
                reqControlMap.keySet().forEach(o -> feeBudgetCodesList.add(reqControlMap.get(o)));
                throw new BusinessException(((Object)feeBudgetCodesList).toString() + "\u7684\u9884\u7b97\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            }
        }
    }

    public List<TpmFeeBudgetControlEntity> findControlByIds(Set<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, ids);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Set<String> ids) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getControlId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        return CollectionUtils.isEmpty((Collection)feeBudgetEntities) ? Lists.newArrayList() : feeBudgetEntities;
    }

    public void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null) {
            return;
        }
        TpmCostTypeFineEntity fineEntity = (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)entity.getFineCode())));
        if (fineEntity == null) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u5efa\u6d3b\u52a8");
        }
        String date = "";
        try {
            date = Objects.nonNull(fineEntity.getAuditValidity()) ? DateUtil.formatAddMonth((String)entity.getEndDate(), (String)"yyyy-MM-dd", (int)fineEntity.getAuditValidity()) : "9999-12-31";
        }
        catch (ParseException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        entity.setAllowAuditEndDate(date);
        entity.setAllowAuditEndDateSecond("23:59:59");
        entity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        entity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        entity.setApproveAmount(entity.getApplyTotalAmount());
        entity.setCanUseAmount(entity.getApproveAmount());
        entity.setIsAudit(GlobalWhetherEnum.YES.getCode());
        List liqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)entity.getActCode()));
        liqueurActBudgetEntities.forEach(o -> {
            o.setApproveAmount(o.getApplyAmount());
            o.setCanUseAmount(o.getApproveAmount());
        });
        ArrayList transactionEntities = Lists.newArrayList();
        liqueurActBudgetEntities.forEach(x -> {
            TpmLiqueurActBudgetTransactionEntity transactionEntity = (TpmLiqueurActBudgetTransactionEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmLiqueurActBudgetTransactionEntity.class)));
            super.setPublicParamsNull((CrmBaseEntity)transactionEntity);
            transactionEntity.setBusinessCode(entity.getActCode());
            transactionEntity.setBusinessName(entity.getActName());
            transactionEntity.setFeeAmount(x.getCanUseAmount());
            transactionEntity.setBusinessType(LiqueurActBudgetBusinessTypeEnum.ACT.getCode());
            transactionEntity.setTransactionType(FeeBudgetDetailTypeEnum.INIT.getCode());
            transactionEntity.setTransactionTypeName(FeeBudgetDetailTypeEnum.INIT.getDes());
            transactionEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            transactionEntity.setBusinessRemarks(LiqueurActBudgetRemarkEnum.ACT_APPROVED_INIT.getDes());
            transactionEntities.add(transactionEntity);
        });
        this.transactionService.saveBatch(transactionEntities);
        this.liqueurActBudgetService.updateBatchById(liqueurActBudgetEntities);
        this.liqueurActMapper.updateById((Object)entity);
    }

    private TpmLiqueurActEntity checkOperatingData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        if (Objects.isNull((Object)entity) || !StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        return entity;
    }

    public void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null) {
            return;
        }
        entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        this.rejectAndInterrupt(entity);
    }

    private void rejectAndInterrupt(TpmLiqueurActEntity entity) {
        List actBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)entity.getActCode()));
        HashSet controlIds = Sets.newHashSet();
        HashMap feeBudgetAmount = Maps.newHashMap();
        actBudgetEntities.forEach(o -> {
            feeBudgetAmount.put(o.getFeeBudgetCode(), o.getApplyAmount());
            controlIds.add(o.getControlId());
        });
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        List<TpmFeeBudgetControlEntity> feeBudgetControlEntities = this.findControlByIds(controlIds);
        feeBudgetEntities.forEach(x -> {
            if (feeBudgetAmount.containsKey(x.getFeeBudgetCode())) {
                x.setCanUseAmount(x.getCanUseAmount().add((BigDecimal)feeBudgetAmount.get(x.getFeeBudgetCode())));
                x.setUsedAmount(x.getUsedAmount().subtract((BigDecimal)feeBudgetAmount.get(x.getFeeBudgetCode())));
            }
        });
        Map<String, List<TpmFeeBudgetEntity>> feeBudgetGroupByControlId = feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        feeBudgetControlEntities.forEach(y -> {
            if (feeBudgetGroupByControlId.containsKey(y.getId())) {
                BigDecimal bigDecimal = ((List)feeBudgetGroupByControlId.get(y.getId())).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get();
                y.setCanUseAmount(bigDecimal);
            }
        });
        List detailsEntities = this.detailsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmFeeBudgetDetailsEntity::getBusinessCode, (Object)entity.getActCode()));
        ArrayList saveDetailsEntities = Lists.newArrayList();
        detailsEntities.forEach(x -> {
            if (Optional.ofNullable(x.getFeeAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) != 0) {
                TpmFeeBudgetDetailsEntity detailsEntity = (TpmFeeBudgetDetailsEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmFeeBudgetDetailsEntity.class)));
                super.setPublicParamsNull((CrmBaseEntity)detailsEntity);
                detailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(detailsEntity.getFeeAmount()));
                detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
                detailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                saveDetailsEntities.add(detailsEntity);
            }
        });
        this.detailsService.saveBatch(saveDetailsEntities);
        this.liqueurActMapper.updateById((Object)entity);
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.feeBudgetControlService.updateBatchById(feeBudgetControlEntities);
    }

    public void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!ActApproveStatusEnum.getCanApproveStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6279");
        }
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        tpmLiqueurActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
    }

    public TpmCostTypeFineEntity findFineEntity(String fineCode) {
        return (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)fineCode)));
    }

    public void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null) {
            return;
        }
        entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        this.rejectAndInterrupt(entity);
    }

    public List<TpmLiqueurActEntity> closed(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        List<TpmLiqueurActEntity> entities = this.checkCanClosedData(tpmLiqueurActReqVo);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        HashSet actCodes = Sets.newHashSet();
        HashMap actCanUseAmountMap = Maps.newHashMap();
        entities.forEach(o -> {
            actCodes.add(o.getActCode());
            actCanUseAmountMap.put(o.getActCode(), o.getCanUseAmount());
            o.setCanUseAmount(BigDecimal.ZERO);
            o.setApproveStatus(ActApproveStatusEnum.CLOSED.getCode());
        });
        AssertUtils.isNotEmpty((Collection)actCodes, (String)"\u65e0\u6cd5\u83b7\u53d6\u6d3b\u52a8\u76f8\u5173\u660e\u7ec6\u7b49\u4fe1\u606f");
        List actBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActBudgetEntity::getActCode, (Collection)actCodes));
        List liqueurActRegisterEntities = this.actRegisterMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmLiqueurActRegisterEntity::getActCode, (Collection)actCodes)).eq(TpmLiqueurActRegisterEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVED.getCode()));
        Map<String, List<TpmLiqueurActRegisterEntity>> liqueurActRegisterEntityMap = liqueurActRegisterEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActRegisterEntity::getActCode));
        List feeBudgetDetailsEntities = this.detailsMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmFeeBudgetDetailsEntity::getBusinessCode, (Collection)actCodes));
        HashMap noAllAuditAmount = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)liqueurActRegisterEntities)) {
            List actRegisterCodes = liqueurActRegisterEntities.stream().map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
            List detailEntities = this.registerDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, actRegisterCodes));
            List finalDetailEntities = detailEntities.stream().filter(o -> StringUtils.equals((CharSequence)o.getIsAllAudit(), (CharSequence)GlobalWhetherEnum.NO.getCode())).collect(Collectors.toList());
            Map finalDetailMap = finalDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
            HashSet actDetailCodes = Sets.newHashSet();
            finalDetailMap.keySet().forEach(x -> {
                TpmLiqueurActRegisterDetailEntity detailEntity = (TpmLiqueurActRegisterDetailEntity)((Object)((Object)finalDetailMap.get(x)));
                actDetailCodes.add(x);
                noAllAuditAmount.put(x, detailEntity.getApplyAmount().subtract(detailEntity.getAuditAmount()));
            });
            List transactionEntities = this.transactionMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, (Collection)actDetailCodes));
            List budgetTransactionEntities = CrmBeanUtil.copyList((List)transactionEntities, TpmLiqueurActBudgetTransactionEntity.class);
            budgetTransactionEntities.forEach(x -> {
                super.setPublicParamsNull((CrmBaseEntity)x);
                x.setBusinessType(LiqueurActBudgetBusinessTypeEnum.CLOSED.getCode());
                x.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                x.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                x.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
                x.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
            this.actClosedSaveData(actCanUseAmountMap, actBudgetEntities, noAllAuditAmount, budgetTransactionEntities, liqueurActRegisterEntityMap, feeBudgetDetailsEntities);
        }
        if (CollectionUtils.isEmpty((Collection)liqueurActRegisterEntities)) {
            this.actClosed(feeBudgetDetailsEntities, actBudgetEntities);
        }
        return entities;
    }

    private void actClosed(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities, List<TpmLiqueurActBudgetEntity> actBudgetEntities) {
        HashSet controlIds = Sets.newHashSet();
        actBudgetEntities.forEach(x -> {
            controlIds.add(x.getControlId());
            x.setCanUseAmount(BigDecimal.ZERO);
        });
        ArrayList detailsEntities = Lists.newArrayList();
        List<TpmFeeBudgetControlEntity> controlEntities = this.findControlByIds(controlIds);
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        Map feeBudgetMap = feeBudgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        feeBudgetDetailsEntities.forEach(x -> {
            TpmFeeBudgetDetailsEntity entity = (TpmFeeBudgetDetailsEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmFeeBudgetDetailsEntity.class)));
            super.setPublicParamsNull((CrmBaseEntity)entity);
            if (feeBudgetMap.containsKey(x.getFeeBudgetCode())) {
                TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)((Object)feeBudgetMap.get(x.getFeeBudgetCode())));
                entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                entity.setAfterAmount(entity.getBeforAmount().add(entity.getFeeAmount()));
                entity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
                entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                this.setBudgetData(feeBudgetMap, entity);
                detailsEntities.add(entity);
            }
        });
        Map<String, List<TpmFeeBudgetEntity>> feeMap = feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        controlEntities.forEach(y -> {
            if (feeMap.containsKey(y.getId())) {
                y.setCanUseAmount(((List)feeMap.get(y.getId())).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get());
            }
        });
        this.liqueurActBudgetService.updateBatchById(actBudgetEntities);
        this.detailsService.saveBatch(detailsEntities);
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.feeBudgetControlService.updateBatchById(controlEntities);
    }

    private void actClosedSaveData(Map<String, BigDecimal> actCanUseAmountMap, List<TpmLiqueurActBudgetEntity> actBudgetEntities, Map<String, BigDecimal> noAllAuditAmount, List<TpmLiqueurActBudgetTransactionEntity> budgetTransactionEntities, Map<String, List<TpmLiqueurActRegisterEntity>> liqueurActRegisterEntityMap, List<TpmFeeBudgetDetailsEntity> budgetDetails) {
        Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap = budgetTransactionEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode));
        HashSet controlIds = Sets.newHashSet();
        this.setBackTransaction(noAllAuditAmount, transactionMap, controlIds);
        Map<String, List<TpmLiqueurActBudgetTransactionEntity>> actBudgetTransactionMap = budgetTransactionEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetTransactionEntity::getBusinessCode));
        HashMap registerBigDecimalMap = Maps.newHashMap();
        actBudgetTransactionMap.keySet().forEach(x -> {
            BigDecimal bigDecimal = ((List)actBudgetTransactionMap.get(x)).stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeAmount).reduce(BigDecimal::add).get();
            registerBigDecimalMap.put(x, bigDecimal);
        });
        liqueurActRegisterEntityMap.keySet().forEach(x -> {
            AtomicReference<BigDecimal> bigDecimal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            ((List)liqueurActRegisterEntityMap.get(x)).forEach(o -> {
                if (registerBigDecimalMap.containsKey(o.getActRegisterCode())) {
                    bigDecimal.set(((BigDecimal)bigDecimal.get()).add((BigDecimal)registerBigDecimalMap.get(o.getActRegisterCode())));
                }
            });
            if (actCanUseAmountMap.containsKey(x)) {
                bigDecimal.set(bigDecimal.get().add((BigDecimal)actCanUseAmountMap.get(x)));
                actCanUseAmountMap.put((String)x, bigDecimal.get());
            }
        });
        List<TpmFeeBudgetControlEntity> controlEntities = this.findControlByIds(controlIds);
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        Map<String, TpmFeeBudgetEntity> tpmFeeBudgetEntityMap = feeBudgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        Map<String, List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap = budgetDetails.stream().collect(Collectors.groupingBy(TpmFeeBudgetDetailsEntity::getBusinessCode));
        List<TpmFeeBudgetDetailsEntity> updateDetailsEntities = this.backBudget(actCanUseAmountMap, tpmFeeBudgetEntityMap, budgetDetailsMap);
        HashMap actBudgetMap = Maps.newHashMap();
        actBudgetEntities.forEach(x -> {
            if (actBudgetMap.containsKey(x.getActCode())) {
                ((List)actBudgetMap.get(x.getActCode())).add(x);
            } else {
                actBudgetMap.put(x.getActCode(), Lists.newArrayList());
            }
            x.setCanUseAmount(BigDecimal.ZERO);
        });
        Map<String, List<TpmFeeBudgetEntity>> feeMap = feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        controlEntities.forEach(y -> {
            if (feeMap.containsKey(y.getId())) {
                y.setCanUseAmount(((List)feeMap.get(y.getId())).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get());
            }
        });
        this.feeBudgetControlService.updateBatchById(controlEntities);
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.liqueurActBudgetService.updateBatchById(actBudgetEntities);
        List transactionEntities = budgetTransactionEntities.stream().filter(o -> o.getFeeAmount() != null && o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        this.transactionService.saveBatch(transactionEntities);
        log.info(updateDetailsEntities.toString());
        this.detailsService.saveBatch(updateDetailsEntities);
    }

    private void setBackTransaction(Map<String, BigDecimal> noAllAuditAmount, Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap, Set<String> controlIds) {
        noAllAuditAmount.keySet().forEach(o -> {
            if (transactionMap.containsKey(o)) {
                List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = ((List)transactionMap.get(o)).stream().sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder).reversed()).collect(Collectors.toList());
                AtomicReference bigDecimal = new AtomicReference(noAllAuditAmount.get(o));
                transactionEntities.forEach(x -> {
                    if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO) > 0) {
                        if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO.subtract(x.getFeeAmount())) > 0) {
                            x.setFeeAmount(BigDecimal.ZERO.subtract(x.getFeeAmount()));
                            bigDecimal.set(((BigDecimal)bigDecimal.get()).add(x.getFeeAmount()));
                        } else {
                            x.setFeeAmount((BigDecimal)bigDecimal.get());
                            bigDecimal.set(BigDecimal.ZERO);
                        }
                    } else {
                        x.setFeeAmount(BigDecimal.ZERO);
                    }
                    controlIds.add(x.getControlId());
                });
            }
        });
    }

    private List<TpmFeeBudgetDetailsEntity> backBudget(Map<String, BigDecimal> actBigDecimalMap, Map<String, TpmFeeBudgetEntity> tpmFeeBudgetEntityMap, Map<String, List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap) {
        ArrayList updateDetailsEntities = Lists.newArrayList();
        budgetDetailsMap.keySet().forEach(x -> {
            if (actBigDecimalMap.containsKey(x)) {
                AtomicReference bigDecimal = new AtomicReference(actBigDecimalMap.get(x));
                List<TpmFeeBudgetDetailsEntity> detailsEntities = ((List)budgetDetailsMap.get(x)).stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
                detailsEntities.forEach(y -> {
                    TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)((Object)((Object)tpmFeeBudgetEntityMap.get(y.getFeeBudgetCode()))));
                    if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO) > 0) {
                        if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO.subtract(y.getFeeAmount())) > 0) {
                            TpmFeeBudgetDetailsEntity entity = (TpmFeeBudgetDetailsEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)y, TpmFeeBudgetDetailsEntity.class))));
                            super.setPublicParamsNull((CrmBaseEntity)entity);
                            entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                            entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                            entity.setAfterAmount(entity.getBeforAmount().add(entity.getFeeAmount()));
                            this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                            updateDetailsEntities.add(entity);
                        } else {
                            TpmFeeBudgetDetailsEntity entity = (TpmFeeBudgetDetailsEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)y, TpmFeeBudgetDetailsEntity.class))));
                            super.setPublicParamsNull((CrmBaseEntity)entity);
                            entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                            entity.setFeeAmount((BigDecimal)bigDecimal.get());
                            entity.setAfterAmount(entity.getFeeAmount().add(entity.getBeforAmount()));
                            this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                            updateDetailsEntities.add(entity);
                        }
                    } else {
                        TpmFeeBudgetDetailsEntity entity = (TpmFeeBudgetDetailsEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)y, TpmFeeBudgetDetailsEntity.class))));
                        super.setPublicParamsNull((CrmBaseEntity)entity);
                        entity.setFeeAmount(BigDecimal.ZERO);
                        entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                        entity.setAfterAmount(feeBudgetEntity.getCanUseAmount());
                        this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                        updateDetailsEntities.add(entity);
                    }
                });
            } else {
                ((List)budgetDetailsMap.get(x)).forEach(z -> {
                    TpmFeeBudgetDetailsEntity entity = (TpmFeeBudgetDetailsEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)z, TpmFeeBudgetDetailsEntity.class))));
                    TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)((Object)((Object)tpmFeeBudgetEntityMap.get(z.getFeeBudgetCode()))));
                    super.setPublicParamsNull((CrmBaseEntity)entity);
                    entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                    entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                    entity.setAfterAmount(entity.getFeeAmount().add(entity.getBeforAmount()));
                    this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                    updateDetailsEntities.add(entity);
                });
            }
        });
        return updateDetailsEntities;
    }

    private void setBudgetData(Map<String, TpmFeeBudgetEntity> tpmFeeBudgetEntityMap, TpmFeeBudgetDetailsEntity entity) {
        entity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
        entity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
        entity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
        entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
        tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).setUsedAmount(tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).getUsedAmount().subtract(entity.getFeeAmount()));
        tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).setCanUseAmount(tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).getCanUseAmount().add(entity.getFeeAmount()));
    }

    private List<TpmLiqueurActEntity> checkCanClosedData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmLiqueurActReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.liqueurActMapper.selectBatchIds(tpmLiqueurActReqVo.getIds());
        if (CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("\u9700\u8981\u5173\u95ed\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        HashSet cannotClosed = Sets.newHashSet();
        ArrayList needClosedActs = Lists.newArrayList();
        HashSet maybeCanClosedCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getApproveStatus(), (CharSequence)ActApproveStatusEnum.APPROVED.getCode())) {
                needClosedActs.add(o);
                maybeCanClosedCodes.add(o.getActCode());
            } else {
                cannotClosed.add(o.getActCode());
            }
        });
        AssertUtils.isTrue((needClosedActs.size() == entities.size() ? 1 : 0) != 0, (String)("\u7f16\u7801\u4e3a" + ((Object)cannotClosed).toString() + "\u7684\u6d3b\u52a8\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u53ef\u4ee5\u5173\u95ed"));
        List auditEntities = this.liqueurAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmLiqueurAuditEntity::getActCode, (Collection)maybeCanClosedCodes)).eq(TpmLiqueurAuditEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVING.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)auditEntities)) {
            Set actCodes = auditEntities.stream().map(TpmLiqueurAuditEntity::getActCode).collect(Collectors.toSet());
            throw new BusinessException("\u6d3b\u52a8\u7f16\u7801\u6709\u5728\u5ba1\u6279\u4e2d\u7684\u6838\u9500\u7533\u8bf7,\u6d3b\u52a8\u7f16\u7801\u4e3a" + actCodes.toString());
        }
        return needClosedActs;
    }

    public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.detailsService.saveOrUpdateBatch(feeBudgetDetailEntities);
    }

    public void saveTransaction(TpmLiqueurActBudgetTransactionEntity transactionEntity, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.transactionService.saveOrUpdate((Object)transactionEntity);
    }

    public void convertCusAndOrgData(TpmLiqueurActRespVo respVo) {
        if (StringUtils.isNotBlank((CharSequence)respVo.getOrgCode())) {
            List orgCodes = JSON.parseArray((String)respVo.getOrgCode(), String.class);
            List orgRespVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.detailBatchByOrgCodeList(orgCodes), (boolean)false);
            if (CollectionUtils.isEmpty((Collection)orgRespVos)) {
                orgRespVos = Lists.newArrayList();
            }
            respVo.setOrgList(orgRespVos);
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getCustomerCode())) {
            HashSet customerCodes = Sets.newHashSet((Iterable)JSON.parseArray((String)respVo.getCustomerCode(), String.class));
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
            mdmCustomerMsgReqVo.setCustomerCodeList((List)Lists.newArrayList((Iterable)customerCodes));
            List list = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCustomerSelectList(mdmCustomerMsgReqVo), (boolean)true);
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = Lists.newArrayList();
            }
            respVo.setCustomerList(list);
        }
    }

    public void convertLiqueurActRegisterRespVo(TpmLiqueurActRegisterRespVo respVo) {
        Map<String, Map<String, String>> map = this.getDictMaps();
        HashSet budgetSubjectsCode = Sets.newHashSet();
        respVo.getEditBudgetVos().forEach(o -> {
            budgetSubjectsCode.add(o.getBudgetSubjectsCode());
            if (StringUtils.isNotEmpty((CharSequence)o.getBudgetYear())) {
                o.setBudgetYearName((String)((Map)Optional.ofNullable(map.get("budget_year")).orElse(Maps.newHashMap())).get(o.getBudgetYear()));
            }
            if (StringUtils.isNotEmpty((CharSequence)o.getBudgetMonth())) {
                o.setBudgetMonthName((String)((Map)Optional.ofNullable(map.get("budget_mouth")).orElse(Maps.newHashMap())).get(o.getBudgetMonth()));
            }
            if (StringUtils.isNotEmpty((CharSequence)o.getBudgetQuater())) {
                o.setBudgetQuaterName((String)((Map)Optional.ofNullable(map.get("budget_quater")).orElse(Maps.newHashMap())).get(o.getBudgetQuater()));
            }
        });
        Map<String, List<TpmBudgetSubjectsEntity>> collect = this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Collection)budgetSubjectsCode)).stream().collect(Collectors.groupingBy(TpmBudgetSubjectsEntity::getBudgetSubjectsCode));
        respVo.getEditBudgetVos().forEach(o -> o.setBudgetSubjectsName(((TpmBudgetSubjectsEntity)((Object)((Object)((List)collect.get(o.getBudgetSubjectsCode())).get(0)))).getBudgetSubjectsName()));
    }

    public void setAttachPayTypes(List<TpmLiqueurActRegisterDetailAttachRespVo> attachEntityVos) {
        HashSet categoriesCodes = Sets.newHashSet();
        attachEntityVos.stream().forEach(o -> categoriesCodes.add(o.getCategoriesCode()));
        Map<Object, Object> categoriesMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)categoriesCodes)) {
            Map<String, String> payTypesDictMap = this.serviceHelper.getPayTypesDict();
            List tpmCostTypeCategoriesEntities = this.tpmCostTypeCategoriesMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmCostTypeCategoriesEntity.class).select(new SFunction[]{TpmCostTypeCategoriesEntity::getCategoriesCode, TpmCostTypeCategoriesEntity::getPayType}).in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesCodes));
            if (CollectionUtils.isNotEmpty((Collection)tpmCostTypeCategoriesEntities)) {
                categoriesMap = tpmCostTypeCategoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
            }
            for (TpmLiqueurActRegisterDetailAttachRespVo o2 : attachEntityVos) {
                TpmCostTypeCategoriesEntity categoriesEntity = (TpmCostTypeCategoriesEntity)((Object)categoriesMap.get(o2.getCategoriesCode()));
                if (Objects.isNull((Object)categoriesEntity)) continue;
                List<DictItemVo> dictItemVos = this.serviceHelper.convertDictList(payTypesDictMap, categoriesEntity.getPayType());
                o2.setPayTypes(dictItemVos);
            }
        }
    }
}

