/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sale.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.sale.mapper.TpmSalesPlansMapper;
import com.biz.crm.sale.model.TpmSalesPlansEntity;
import com.biz.crm.sale.service.ITpmSalesPlansService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmSalesPlansServiceExpandImpl"})
public class TpmSalesPlansServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmSalesPlansMapper, TpmSalesPlansEntity>
implements ITpmSalesPlansService {
    private static final Logger log = LoggerFactory.getLogger(TpmSalesPlansServiceImpl.class);
    @Resource
    private TpmSalesPlansMapper tpmSalesPlansMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<TpmSalesPlansRespVo> findList(TpmSalesPlansReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmSalesPlansRespVo> list = this.tpmSalesPlansMapper.findList((Page<TpmSalesPlansRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmSalesPlansRespVo query(String id) {
        TpmSalesPlansEntity entity = (TpmSalesPlansEntity)((Object)this.getById((Serializable)((Object)id)));
        return (TpmSalesPlansRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmSalesPlansRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmSalesPlansReqVo reqVo) {
        this.SaveCheck(reqVo);
        TpmSalesPlansEntity entity = (TpmSalesPlansEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmSalesPlansEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmSalesPlansRespVo newData = (TpmSalesPlansRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmSalesPlansRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getSalePlansId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmSalesPlansReqVo reqVo) {
        this.SaveCheck(reqVo);
        TpmSalesPlansEntity entity = (TpmSalesPlansEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        TpmSalesPlansRespVo oldData = (TpmSalesPlansRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmSalesPlansRespVo.class);
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)FeeBudgetException.DATA_NOT_EXIST, (String[])new String[0]);
        this.updateById(CrmBeanUtil.copy((Object)reqVo, TpmSalesPlansEntity.class));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmSalesPlansRespVo newData = (TpmSalesPlansRespVo)CrmBeanUtil.copy((Object)reqVo, TpmSalesPlansRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getSalePlansId(), (Object)oldData, (Object)newData);
    }

    private void SaveCheck(TpmSalesPlansReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSpYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSpMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSalePlanType(), (String)"\u9500\u552e\u8ba1\u5212\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getChannelCode(), (String)"\u9500\u552e\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getChannelName(), (String)"\u9500\u552e\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getAmount(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmSalesPlansEntities = this.tpmSalesPlansMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesPlansEntities)) {
            tpmSalesPlansEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmSalesPlansEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmSalesPlansReqVo reqVo) {
        List tpmSalesPlansEntities = this.tpmSalesPlansMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesPlansEntities)) {
            tpmSalesPlansEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmSalesPlansEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmSalesPlansReqVo reqVo) {
        List tpmSalesPlansEntities = this.tpmSalesPlansMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesPlansEntities)) {
            tpmSalesPlansEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmSalesPlansEntities);
    }
}

