/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feebudget.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.BudgetUseDateRuleEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFeeBudgetControlServiceExpandImpl"})
public class TpmFeeBudgetControlServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmFeeBudgetControlMapper, TpmFeeBudgetControlEntity>
implements ITpmFeeBudgetControlService {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeBudgetControlServiceImpl.class);
    @Resource
    private TpmFeeBudgetControlMapper tpmFeeBudgetControlMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private FeeBudgetServiceHelper feeBudgetServiceHelper;

    @Override
    public PageResult<TpmFeeBudgetControlRespVo> findList(TpmFeeBudgetControlReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Set<String> selectKeys = this.getSelectKeys(reqVo);
        reqVo.setSelectKeys(selectKeys);
        reqVo.setSelectedCodeList(this.feeBudgetServiceHelper.dealSelectedCodeList(reqVo.getSelectedCode(), reqVo.getSelectedCodeList()));
        List<TpmFeeBudgetControlRespVo> list = this.tpmFeeBudgetControlMapper.findList((Page<TpmFeeBudgetControlRespVo>)page, reqVo);
        this.convertListData(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<TpmFeeBudgetControlRespVo> list(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmFeeBudgetControlReqVo.getPageNum(), (Integer)-1);
        List<TpmFeeBudgetControlRespVo> list = this.tpmFeeBudgetControlMapper.findList((Page<TpmFeeBudgetControlRespVo>)page, tpmFeeBudgetControlReqVo);
        this.convertListData(list);
        return list;
    }

    public Set<String> getSelectKeys(TpmFeeBudgetControlReqVo reqVo) {
        String config = ParamUtil.getParameterValue((String)"budget_use_date_rule");
        AssertUtils.isNotEmpty((String)config, (String)"\u672a\u83b7\u53d6\u5230\u9884\u7b97\u9009\u62e9\u65f6\u95f4\u63a7\u5236\u5f00\u5173\u914d\u7f6e");
        HashSet set = Sets.newHashSet();
        if (StringUtils.equals((CharSequence)BudgetUseDateRuleEnum.NO_CONTROL.getCode(), (CharSequence)config)) {
            return set;
        }
        AssertUtils.isNotEmpty((String)reqVo.getActBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.equals((CharSequence)BudgetUseDateRuleEnum.CURRENT.getCode(), (CharSequence)config)) {
            Map dateMap = DateUtil.getDateBetweenMap((String)reqVo.getActBeginDate(), (String)reqVo.getActEndDate());
            for (Map.Entry entry : dateMap.entrySet()) {
                String key = ((Integer)entry.getKey()).toString();
                List months = (List)entry.getValue();
                set.add(key);
                for (Integer month : months) {
                    int quater = DateUtil.getQuaterByMonth((int)month);
                    String yearQuater = key + "-" + quater;
                    if (!set.contains(yearQuater)) {
                        set.add(yearQuater);
                    }
                    set.add(yearQuater + "-" + month);
                }
            }
        } else {
            throw new BusinessException("\u9884\u7b97\u9009\u62e9\u65f6\u95f4\u63a7\u5236\u5f00\u5173\u914d\u7f6e\u503c\u9519\u8bef");
        }
        return set;
    }

    @Override
    public void convertListData(List<TpmFeeBudgetControlRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> dicts = this.feeBudgetServiceHelper.getDicts();
            List ids = list.stream().map(UuidVo::getId).collect(Collectors.toList());
            TpmFeeBudgetReqVo tpmFeeBudgetReqVo = new TpmFeeBudgetReqVo();
            tpmFeeBudgetReqVo.setPageSize(Integer.valueOf(-1));
            tpmFeeBudgetReqVo.setControlIds(ids);
            ThreadLocalUtil.delObj();
            List feeBudgetServiceList = this.feeBudgetService.findList(tpmFeeBudgetReqVo).getData();
            if (CollectionUtils.isEmpty((Collection)feeBudgetServiceList)) {
                return;
            }
            Map<String, List<TpmFeeBudgetRespVo>> map = feeBudgetServiceList.stream().collect(Collectors.groupingBy(TpmFeeBudgetRespVo::getControlId));
            list.forEach(o -> {
                List tpmFeeBudgetRespVos = (List)map.get(o.getId());
                o.setFeeBudgetVos(tpmFeeBudgetRespVos);
                if (StringUtils.isNotEmpty((CharSequence)o.getBudgetYear())) {
                    o.setBudgetYearName((String)((Map)Optional.ofNullable(dicts.get("fiscal_year")).orElse(Maps.newHashMap())).get(o.getBudgetYear()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getBudgetMonth())) {
                    o.setBudgetMonthName((String)((Map)Optional.ofNullable(dicts.get("fiscal_month")).orElse(Maps.newHashMap())).get(o.getBudgetMonth()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getBudgetQuater())) {
                    o.setBudgetQuaterName((String)((Map)Optional.ofNullable(dicts.get("fiscal_quater")).orElse(Maps.newHashMap())).get(o.getBudgetQuater()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getChannel())) {
                    o.setChannelName((String)((Map)Optional.ofNullable(dicts.get("channel")).orElse(Maps.newHashMap())).get(o.getChannel()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getFeeBudgetType())) {
                    o.setFeeBudgetTypeName((String)((Map)Optional.ofNullable(dicts.get("fee_budget_type")).orElse(Maps.newHashMap())).get(o.getFeeBudgetType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getControlType())) {
                    o.setControlTypeName((String)((Map)Optional.ofNullable(dicts.get("control_type")).orElse(Maps.newHashMap())).get(o.getControlType()));
                }
            });
        }
    }

    @Override
    public TpmFeeBudgetControlRespVo query(TpmFeeBudgetControlReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmFeeBudgetControlReqVo reqVo) {
        TpmFeeBudgetControlEntity entity = (TpmFeeBudgetControlEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmFeeBudgetControlEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmFeeBudgetControlReqVo reqVo) {
        TpmFeeBudgetControlEntity entity = (TpmFeeBudgetControlEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmFeeBudgetControlEntities = this.tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmFeeBudgetControlEntities)) {
            tpmFeeBudgetControlEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmFeeBudgetControlEntities = this.tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmFeeBudgetControlEntities)) {
            tpmFeeBudgetControlEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmFeeBudgetControlEntities = this.tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmFeeBudgetControlEntities)) {
            tpmFeeBudgetControlEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }
}

