/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmLiqueurActRegisterController"})
@Api(tags={"\u9152\u7c7b\u6d3b\u52a8\u767b\u8bb0api\u63a5\u53e3"})
public class TpmLiqueurActRegisterController {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActRegisterController.class);
    @Autowired
    private ITpmLiqueurActRegisterService actRegisterService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterRespVo>> list(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        PageResult<TpmLiqueurActRegisterRespVo> result = this.actRegisterService.findList(tpmLiqueurActRegisterReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmLiqueurActRegisterRespVo> query(@RequestParam(value="id", required=true) String id) {
        TpmLiqueurActRegisterRespVo respVo = this.actRegisterService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActRegisterReqVo.setLockUserName(user.getUsername());
        this.actRegisterService.save(tpmLiqueurActRegisterReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActRegisterReqVo.setLockUserName(user.getUsername());
        this.actRegisterService.update(tpmLiqueurActRegisterReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.actRegisterService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.actRegisterService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.actRegisterService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/approve"})
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurActRegisterReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setLockUserName(user.getUsername());
        this.actRegisterService.approve(reqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.actRegisterService.activityCallBack(activitiCallBackVo);
        return Result.ok((String)"\u6d3b\u52a8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }

    @ApiOperation(value="\u6d3b\u52a8\u767b\u8bb0-\u6d3b\u52a8\u660e\u7ec6\u8d39\u7528\u9884\u7b97\u4e0b\u62c9\u9009\u62e9\u63a5\u53e3(\u4f20\u5165\u6d3b\u52a8\u7f16\u7801:actCode)")
    @PostMapping(value={"/findBudgetByActCode"})
    @CrmLog
    public Result<List<TpmFeeBudgetControlRespVo>> findBudgetByActCode(@RequestBody TpmLiqueurActBudgetReqVo reqVo) {
        List<TpmFeeBudgetControlRespVo> actBudgetRespVos = this.actRegisterService.findBudgetByActCode(reqVo);
        return Result.ok(actBudgetRespVos);
    }

    @ApiOperation(value="\u6d3b\u52a8\u767b\u8bb0-\u6295\u5165\u7c7b\u578b\u4e0b\u62c9\u9009\u62e9\u63a5\u53e3(\u6839\u636e\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u6295\u5165\u7c7b\u578b)")
    @PostMapping(value={"/findCategoriesBySubjectCodes"})
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesRespVo>> findCategoriesBySubjectCodes(@RequestBody TpmLiqueurActRegisterDetailReqVo reqVo) {
        PageResult<TpmCostTypeCategoriesRespVo> categoriesBySubjectCodes = this.actRegisterService.findCategoriesBySubjectCodes(reqVo);
        return Result.ok(categoriesBySubjectCodes);
    }
}

