/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.budgetsubjects.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.budgetsubjects.service.ITpmBudgetSubjectsService;
import com.biz.crm.budgetsubjects.service.impl.BudgetSubjectsServiceHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.BudgetSubjectsException;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmBudgetSubjectsServiceExpandImpl"})
public class TpmBudgetSubjectsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmBudgetSubjectsMapper, TpmBudgetSubjectsEntity>
implements ITpmBudgetSubjectsService {
    private static final Logger log = LoggerFactory.getLogger(TpmBudgetSubjectsServiceImpl.class);
    @Resource
    private TpmBudgetSubjectsMapper tpmBudgetSubjectsMapper;
    @Autowired
    private BudgetSubjectsServiceHelper serviceHelper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @CrmLog
    public PageResult<TpmBudgetSubjectsRespVo> findList(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmBudgetSubjectsReqVo.getPageNum(), (Integer)tpmBudgetSubjectsReqVo.getPageSize());
        tpmBudgetSubjectsReqVo.setSelectedCodeList(this.serviceHelper.dealSelectedCodeList(tpmBudgetSubjectsReqVo.getSelectedCode(), tpmBudgetSubjectsReqVo.getSelectedCodeList()));
        List<TpmBudgetSubjectsRespVo> list = this.tpmBudgetSubjectsMapper.findList((Page<TpmBudgetSubjectsRespVo>)page, tpmBudgetSubjectsReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmBudgetSubjectsRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo = new TpmBudgetSubjectsReqVo();
        tpmBudgetSubjectsReqVo.setId(id);
        List list = this.findList(tpmBudgetSubjectsReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmBudgetSubjectsRespVo();
        }
        return (TpmBudgetSubjectsRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        this.serviceHelper.saveCheck(tpmBudgetSubjectsReqVo);
        TpmBudgetSubjectsEntity entity = (TpmBudgetSubjectsEntity)((Object)CrmBeanUtil.copy((Object)tpmBudgetSubjectsReqVo, TpmBudgetSubjectsEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmBudgetSubjectsRespVo newData = (TpmBudgetSubjectsRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetSubjectsRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getBudgetSubjectsCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        if (StringUtils.isEmpty((CharSequence)tpmBudgetSubjectsReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmBudgetSubjectsEntity entity = (TpmBudgetSubjectsEntity)((Object)this.getById((Serializable)((Object)tpmBudgetSubjectsReqVo.getId())));
        TpmBudgetSubjectsRespVo oldData = (TpmBudgetSubjectsRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetSubjectsRespVo.class);
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)BudgetSubjectsException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(tpmBudgetSubjectsReqVo);
        CrmBeanUtil.copyProperties((Object)tpmBudgetSubjectsReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmBudgetSubjectsRespVo newData = (TpmBudgetSubjectsRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetSubjectsRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getBudgetSubjectsCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List<TpmBudgetSubjectsRespVo> list = this.tpmBudgetSubjectsMapper.countRelatedNum(ids);
        AssertUtils.isNotEmpty(list, (String)"\u60a8\u9009\u62e9\u7684\u9884\u7b97\u79d1\u76ee\u5df2\u88ab\u5220\u9664");
        HashSet budgetSubjectsCodes = Sets.newHashSet();
        list.forEach(o -> {
            AssertUtils.isTrue((o.getNum() == 0 ? 1 : 0) != 0, (String)("\u9884\u7b97\u79d1\u76ee:" + o.getBudgetSubjectsCode() + "\u5df2\u88ab\u8d39\u7528\u9884\u7b97\u5173\u8054,\u4e0d\u80fd\u5220\u9664"));
            budgetSubjectsCodes.add(o.getBudgetSubjectsCode());
        });
        List tpmBudgetSubjectsEntityList = this.tpmBudgetSubjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getParentSubjectsCode, (Collection)budgetSubjectsCodes));
        if (CollectionUtils.isNotEmpty((Collection)tpmBudgetSubjectsEntityList)) {
            String parentSubjectsCodes = "";
            for (int i = 0; i < tpmBudgetSubjectsEntityList.size(); ++i) {
                TpmBudgetSubjectsEntity budgetSubjectsEntity = (TpmBudgetSubjectsEntity)((Object)tpmBudgetSubjectsEntityList.get(i));
                if (parentSubjectsCodes.contains(budgetSubjectsEntity.getParentSubjectsCode())) continue;
                parentSubjectsCodes = StringUtils.isNotEmpty((CharSequence)parentSubjectsCodes) ? parentSubjectsCodes + "\u3001" + budgetSubjectsEntity.getParentSubjectsCode() : budgetSubjectsEntity.getParentSubjectsCode();
            }
            AssertUtils.isTrue((boolean)false, (String)("\u79d1\u76ee\u7f16\u7801\uff1a" + parentSubjectsCodes + "\u6709\u5173\u8054\u7684\u4e0b\u7ea7\u79d1\u76ee\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff08\u9700\u5148\u89e3\u9664\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff09"));
        }
        PageResult<TpmBudgetSubjectsRespVo> oldDateList = this.findList(new TpmBudgetSubjectsReqVo().setIds(ids));
        this.tpmBudgetSubjectsMapper.deleteBatchIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (TpmBudgetSubjectsRespVo oldData : oldDateList.getData()) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), oldData.getId(), oldData.getBudgetSubjectsCode(), (Object)oldData);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmBudgetSubjectsMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmBudgetSubjectsRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(entities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmBudgetSubjectsRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmBudgetSubjectsRespVo)newDataList.get(i)).getId(), ((TpmBudgetSubjectsRespVo)newDataList.get(i)).getBudgetSubjectsCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmBudgetSubjectsMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmBudgetSubjectsRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(entities);
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmBudgetSubjectsRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmBudgetSubjectsRespVo)newDataList.get(i)).getId(), ((TpmBudgetSubjectsRespVo)newDataList.get(i)).getBudgetSubjectsCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    public List<TpmBudgetSubjectsRespVo> findAllBudgets(TpmBudgetSubjectsReqVo reqVo) {
        return this.findList(reqVo).getData();
    }
}

