/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.financesubject.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinanceSubjectHelp {
    private static final Logger log = LoggerFactory.getLogger(FinanceSubjectHelp.class);
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("finance_subject_type");
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setRespVoData(TpmFinanceSubjectRespVo respVo) {
        Map<String, Map<String, String>> dataMaps = this.getDicts();
        if (StringUtils.isNotBlank((CharSequence)respVo.getFinanceSubjectType())) {
            respVo.setFinanceSubjectTypeDesc(Optional.ofNullable(dataMaps.get("finance_subject_type")).orElse(Maps.newHashMap()).get(respVo.getFinanceSubjectType()));
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getEnableStatus())) {
            respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get("enable_status")).orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
        }
    }

    public void checkData(TpmFinanceSubjectReqVo reqVo) {
        if (StringUtils.isBlank((CharSequence)reqVo.getFinanceSubjectCode())) {
            reqVo.setFinanceSubjectCode(CodeUtil.generateCode((String)"finance_subject"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getFinanceSubjectName(), (String)"\u8d22\u52a1\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFinanceSubjectType(), (String)"\u8d22\u52a1\u79d1\u76ee\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkExist(reqVo);
    }

    private void checkExist(TpmFinanceSubjectReqVo reqVo) {
        List entities;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmFinanceSubjectEntity::getFinanceSubjectCode, (Object)reqVo.getFinanceSubjectCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(entities = this.financeSubjectMapper.selectList((Wrapper)wrapper)))) {
            throw new BusinessException("\u8be5\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
    }

    public void updateCheck(TpmFinanceSubjectReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        List list = this.financeSubjectMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId()));
        if (CollectionUtils.size((Object)list) > 1) {
            throw new BusinessException("\u7ed3\u679c\u5927\u4e8e1\u6761\uff0c\u6570\u636e\u5f02\u5e38");
        }
        if (CollectionUtils.size((Object)list) < 1) {
            throw new BusinessException("\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }
}

