/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditAttachService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurAuditAttachServiceExpandImpl"})
public class TpmLiqueurAuditAttachServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurAuditAttachMapper, TpmLiqueurAuditAttachEntity>
implements ITpmLiqueurAuditAttachService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditAttachServiceImpl.class);
    @Resource
    private TpmLiqueurAuditAttachMapper tpmLiqueurAuditAttachMapper;

    @Override
    public PageResult<TpmLiqueurAuditAttachRespVo> findList(TpmLiqueurAuditAttachReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurAuditAttachRespVo> list = this.tpmLiqueurAuditAttachMapper.findList((Page<TpmLiqueurAuditAttachRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<TpmLiqueurAuditAttachRespVo> findAccountList(TpmLiqueurAuditAttachReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurAuditAttachRespVo> list = this.tpmLiqueurAuditAttachMapper.findAccountList((Page<TpmLiqueurAuditAttachRespVo>)page, reqVo);
        list.stream().forEach(o -> {
            o.setCurrentAllowAmount(o.getAuditAmount().subtract(o.getFeeUsed()));
            o.setCustomerCode(o.getAttributionCusCode());
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurAuditAttachRespVo query(TpmLiqueurAuditAttachReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmLiqueurAuditAttachReqVo reqVo) {
        TpmLiqueurAuditAttachEntity entity = (TpmLiqueurAuditAttachEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmLiqueurAuditAttachEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmLiqueurAuditAttachReqVo reqVo) {
        TpmLiqueurAuditAttachEntity entity = (TpmLiqueurAuditAttachEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmLiqueurAuditAttachReqVo reqVo) {
        List tpmLiqueurAuditAttachEntities = this.tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditAttachEntities)) {
            tpmLiqueurAuditAttachEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmLiqueurAuditAttachReqVo reqVo) {
        List tpmLiqueurAuditAttachEntities = this.tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditAttachEntities)) {
            tpmLiqueurAuditAttachEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmLiqueurAuditAttachReqVo reqVo) {
        List tpmLiqueurAuditAttachEntities = this.tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditAttachEntities)) {
            tpmLiqueurAuditAttachEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }
}

