/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl.actbuilder;

import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActDetailProductEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.act.service.impl.actbuilder.ActBaseBuilder;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActDetailProductTypeEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.BudgetUseDateRuleEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ParamUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebateActBuilder
extends BaseServiceHelper
implements ActBaseBuilder {
    private static final Logger log = LoggerFactory.getLogger(RebateActBuilder.class);
    private ActServiceHelper helper;
    private TpmActReqVo reqVo;
    private TpmActEntity actEntity = new TpmActEntity();
    private List<TpmActBudgetEntity> actBudgetEntities = Lists.newArrayList();
    private List<TpmActDetailEntity> actDetailEntities = Lists.newArrayList();
    private List<TmpActFeeShareEntity> shareEntities = Lists.newArrayList();
    private List<TpmActFileEntity> fileEntities = Lists.newArrayList();
    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = Lists.newArrayList();
    private List<TpmFeeBudgetEntity> feeBudgetEntities;
    private List<TpmCostTypeCategoriesEntity> categoriesEntities;
    private List<TpmCostTypeFineEntity> fineEntities;
    private List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities;
    private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;
    private Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap;
    private Map<String, TpmCostTypeFineEntity> fineEntitiesMap;
    private Map<String, TpmCostTypeCategoriesFineEntity> categoriesFineEntitiesMap;
    private Set<String> categoriesFineSet = Sets.newHashSet();
    private List<TpmFeeBudgetControlEntity> controlEntities;
    Map<String, MdmCustomerMsgSelectRespVo> customerMap;
    private Map<String, MdmOrgRespVo> orgMap;
    private Boolean isUseOrder = false;
    private Boolean isUserRatio = false;
    private Map<String, Integer> reduceOrderMap = Maps.newHashMap();
    private Map<String, BigDecimal> reduceRatioMap = Maps.newHashMap();
    private Map<String, TpmActDetailReqVo> actDetailMap = Maps.newHashMap();
    private Map<String, List<TpmFeeBudgetEntity>> actDetailBudgetMap = Maps.newHashMap();
    private Map<String, RebateVo> rebateMap = Maps.newHashMap();
    private Map<String, TpmBudgetSubjectsEntity> subjectsMap;
    private Map<String, MdmProductRespVo> productMap = Maps.newHashMap();
    private List<TpmActDetailProductEntity> detailProductEntities = Lists.newArrayList();

    public RebateActBuilder(ActServiceHelper helper, TpmActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static RebateActBuilder builder(ActServiceHelper helper, TpmActReqVo reqVo) {
        return new RebateActBuilder(helper, reqVo);
    }

    @Override
    public RebateActBuilder init() {
        HashSet orgCodes = Sets.newHashSet();
        HashSet customerCodes = Sets.newHashSet();
        HashSet controlIds = Sets.newHashSet();
        HashSet subjectsCodes = Sets.newHashSet();
        HashSet productCodes = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetControlVos())) {
            ArrayList budgetVos = Lists.newArrayList();
            for (TpmFeeBudgetControlRespVo o2 : this.reqVo.getBudgetControlVos()) {
                controlIds.add(o2.getId());
                List feeBudgetVos = o2.getFeeBudgetVos();
                if (!CollectionUtils.isNotEmpty((Collection)feeBudgetVos)) continue;
                List<Object> budgets = Lists.newArrayList();
                budgets = feeBudgetVos.stream().map(x -> {
                    TpmActBudgetReqVo tpmActBudgetReqVo = new TpmActBudgetReqVo();
                    tpmActBudgetReqVo.setActCode(x.getActCode());
                    tpmActBudgetReqVo.setControlId(x.getControlId());
                    tpmActBudgetReqVo.setReduceOrder(x.getReduceOrder());
                    tpmActBudgetReqVo.setReduceRatio(x.getReduceRatio());
                    tpmActBudgetReqVo.setId(x.getId());
                    tpmActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
                    tpmActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
                    tpmActBudgetReqVo.setOrgType(x.getOrgType());
                    return tpmActBudgetReqVo;
                }).collect(Collectors.toList());
                budgetVos.addAll(budgets);
            }
            this.reqVo.setBudgetVos((List)budgetVos);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetVos())) {
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.helper.findFeeBudgetByControlIds(controlIds);
            if (CollectionUtils.isNotEmpty(feeBudgetEntities)) {
                feeBudgetEntities.forEach(o -> {
                    if (StringUtils.isNotEmpty((CharSequence)o.getOrgCode())) {
                        orgCodes.add(o.getOrgCode());
                    }
                    AssertUtils.isNotEmpty((String)o.getControlId(), (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + "\u6570\u636e\u5f02\u5e38,\u63a7\u5236\u4e3a\u7ef4\u5ea6id\u4e3a\u7a7a"));
                    subjectsCodes.add(o.getBudgetSubjectsCode());
                });
                this.feeBudgetEntities = feeBudgetEntities;
            }
        } else {
            throw new BusinessException("\u8bf7\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        }
        Map payTypeTypeMap = this.helper.getPayTypeTypeMap("pay_type_d", "pay_type_type");
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getDetailVos())) {
            HashSet categoriesCodes = Sets.newHashSet();
            HashSet fineCodes = Sets.newHashSet();
            HashSet promotionCodes = Sets.newHashSet();
            HashSet terminalCodes = Sets.newHashSet();
            this.reqVo.getDetailVos().forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                categoriesCodes.add(o.getCategoriesCode());
                o.setOrgCode((String)Lists.newArrayList((Iterable)orgCodes).get(0));
                fineCodes.add(o.getFineCode());
                if (StringUtils.isNotEmpty((CharSequence)o.getOrgCode())) {
                    orgCodes.add(o.getOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())) {
                    customerCodes.add(o.getCustomerCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayType())) {
                    o.setPayTypeType((String)payTypeTypeMap.get(o.getPayType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPolicyCode())) {
                    promotionCodes.add(o.getPolicyCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getTerminalCode())) {
                    terminalCodes.add(o.getTerminalCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)o.getGiftProductList())) {
                    o.getGiftProductList().stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
                }
                if (CollectionUtils.isNotEmpty((Collection)o.getNormalProductList())) {
                    o.getNormalProductList().stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
                }
                if (CollectionUtils.isNotEmpty((Collection)o.getReplenishmentProductList())) {
                    o.getReplenishmentProductList().stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
                }
                if (CollectionUtils.isNotEmpty((Collection)o.getExecutionProductList())) {
                    o.getExecutionProductList().stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)categoriesCodes) && CollectionUtils.isNotEmpty((Collection)fineCodes)) {
                if (categoriesCodes.size() > 1) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38,\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u4e2d\u7684\u6d3b\u52a8\u5927\u7c7b\u4e0d\u4e00\u81f4");
                }
                this.categoriesFineSet = this.helper.findCategoriesFineEntities(categoriesCodes, fineCodes).stream().map(o -> o.getCategoriesCode() + o.getFineCode()).collect(Collectors.toSet());
            }
            this.categoriesEntities = this.helper.findCategoriesEntitiesByCodes(categoriesCodes);
            this.fineEntities = this.helper.findFineEntitiesByCodes(fineCodes);
            this.categoriesFineEntities = this.helper.findCategoriesFineEntities(categoriesCodes, fineCodes);
            this.controlEntities = this.helper.findFeeBudgetControls(controlIds);
            this.subjectsMap = this.helper.findBudgetSubjectsByCodes(subjectsCodes);
            this.productMap = this.helper.findProductMapByCodes(Lists.newArrayList((Iterable)productCodes));
            List<RebateVo> rebates = this.helper.findRebatesByCodes(promotionCodes);
            if (CollectionUtils.isNotEmpty(rebates)) {
                for (RebateVo rebate : rebates) {
                    this.rebateMap.put(rebate.getCode(), rebate);
                    rebate.getScopeList().stream().forEach(o -> {
                        if (StringUtils.isNotEmpty((CharSequence)o.getOrgCode())) {
                            orgCodes.add(o.getOrgCode());
                        }
                    });
                }
            }
            this.customerMap = this.helper.findCustomerByCodes(customerCodes);
            this.orgMap = this.helper.findOrgByCodes(orgCodes);
        }
        return this;
    }

    @Override
    public RebateActBuilder check() {
        this.checkActData();
        this.checkFeeBudgetData();
        this.checkDetailData();
        this.checkFeeBudgetIsEnough();
        this.checkShareData();
        return this;
    }

    private void checkFeeBudgetIsEnough() {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType())) {
            return;
        }
        Map controlEntityMap = this.controlEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        for (int i = 0; i < this.reqVo.getDetailVos().size(); ++i) {
            TpmActDetailReqVo o = (TpmActDetailReqVo)this.reqVo.getDetailVos().get(i);
            List<TpmFeeBudgetEntity> budgetEntities = this.actDetailBudgetMap.get(o.getActDetailCode());
            AssertUtils.isNotEmpty(budgetEntities, (String)("\u60a8\u9009\u62e9\u7684\u7b2c" + (i + 1) + "\u6761\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u6ca1\u6709\u53ef\u7528\u7684\u8d39\u7528\u9884\u7b97"));
            HashMap map = Maps.newHashMap();
            budgetEntities.forEach(p -> {
                String key = "";
                key = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)p.getFeeBudgetType()) ? p.getFeeBudgetType() + p.getOrgType() : p.getFeeBudgetType();
                List tpmFeeBudgetEntities = (List)map.get(key);
                if (CollectionUtils.isEmpty((Collection)tpmFeeBudgetEntities)) {
                    tpmFeeBudgetEntities = Lists.newArrayList();
                }
                tpmFeeBudgetEntities.add(p);
                map.put(key, tpmFeeBudgetEntities);
            });
            int orderCount = 1;
            if (!this.isUseOrder.booleanValue()) continue;
            Map invertMap = MapUtils.invertMap(this.reduceOrderMap);
            AtomicReference<BigDecimal> applyAmount = new AtomicReference<BigDecimal>(o.getApplyAmount());
            for (int y = 1; y <= invertMap.keySet().size(); ++y) {
                String k = (String)invertMap.get(y);
                List entityList = (List)map.get(k);
                if (CollectionUtils.isEmpty((Collection)entityList)) continue;
                List collect = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
                for (TpmFeeBudgetEntity t : collect) {
                    TpmBudgetSubjectsEntity subjectsEntity = this.subjectsMap.get(t.getBudgetSubjectsCode());
                    AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)("\u8d39\u7528\u9884\u7b97:" + t.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u9884\u7b97\u79d1\u76ee:" + t.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728"));
                    TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(t.getControlId()));
                    TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                    CrmBeanUtil.copyProperties((Object)((Object)t), (Object)((Object)feeBudgetDetailsEntity));
                    super.setPublicParamsNull((CrmBaseEntity)feeBudgetDetailsEntity);
                    feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
                    if (StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                        t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                        t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                        feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                        controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                        applyAmount.set(BigDecimal.ZERO);
                    } else {
                        BigDecimal subtract = applyAmount.get().subtract(t.getCanUseAmount());
                        if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                            t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                            controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                            feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                            t.setCanUseAmount(BigDecimal.ZERO);
                            applyAmount.set(subtract);
                        } else {
                            t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                            t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                            feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                            controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                            applyAmount.set(BigDecimal.ZERO);
                        }
                    }
                    feeBudgetDetailsEntity.setBusinessCode(this.reqVo.getActCode());
                    feeBudgetDetailsEntity.setYear(t.getBudgetYear());
                    feeBudgetDetailsEntity.setMonth(t.getBudgetMonth());
                    feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
                    feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                    feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                    feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
                    feeBudgetDetailsEntity.setBusinessName(this.reqVo.getActName());
                    feeBudgetDetailsEntity.setReduceOrder(orderCount);
                    feeBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
                    feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    ++orderCount;
                    this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
                }
            }
            AssertUtils.isTrue((applyAmount.get().compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u60a8\u9009\u62e9\u7684\u7b2c" + (i + 1) + "\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u8d39\u7528\u9884\u7b97\u4f59\u989d\u4e0d\u8db3"));
        }
    }

    private void checkActData() {
        String config = ParamUtil.getParameterValue((String)"budget_use_date_rule");
        AssertUtils.isNotEmpty((String)config, (String)"\u672a\u83b7\u53d6\u5230\u9884\u7b97\u9009\u62e9\u65f6\u95f4\u63a7\u5236\u5f00\u5173\u914d\u7f6e");
        if (StringUtils.equals((CharSequence)BudgetUseDateRuleEnum.CURRENT.getCode(), (CharSequence)config)) {
            AssertUtils.isNotEmpty((String)this.reqVo.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)this.reqVo.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getSaveType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)this.reqVo.getBeginDate()) && StringUtils.isEmpty((CharSequence)this.reqVo.getEndDateSecond())) {
            this.reqVo.setEndDateSecond("23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.reqVo.getEndDate()) && StringUtils.isEmpty((CharSequence)this.reqVo.getBeginDateSecond())) {
            this.reqVo.setBeginDateSecond("00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.reqVo.getBeginDate()) && StringUtils.isNotEmpty((CharSequence)this.reqVo.getEndDate())) {
            AssertUtils.isTrue((StringUtils.compare((String)(this.reqVo.getBeginDate() + this.reqVo.getBeginDateSecond()), (String)(this.reqVo.getEndDate() + this.reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getActCode())) {
            String actCode = CodeUtil.createOneCode((String)"tpm_act");
            this.reqVo.setActCode(actCode);
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getActType(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
    }

    public void checkFeeBudgetData() {
        AssertUtils.isNotNull((Object)this.reqVo.getBudgetVos(), (String)"\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((this.reqVo.getBudgetVos().size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u9009\u62e9\u76f8\u540c\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e");
        AssertUtils.isTrue((this.feeBudgetEntities.size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u53d1\u751f\u53d8\u52a8,\u8bf7\u91cd\u65b0\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        HashMap feeBudgetEntityMap = Maps.newHashMap();
        HashSet feeBudgetTypeSet = Sets.newHashSet();
        this.feeBudgetEntities.stream().forEach(o -> {
            feeBudgetEntityMap.put(o.getFeeBudgetCode(), o);
            if (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o.getFeeBudgetType())) {
                feeBudgetTypeSet.add(o.getFeeBudgetType() + o.getOrgType());
            } else {
                feeBudgetTypeSet.add(o.getFeeBudgetType());
            }
        });
        this.feeBudgetEntityMap = feeBudgetEntityMap;
        HashSet reduceOrderSet = Sets.newHashSet();
        HashSet reduceRatioSet = Sets.newHashSet();
        for (TpmActBudgetReqVo o2 : this.reqVo.getBudgetVos()) {
            o2.setReduceOrder(Integer.valueOf(1));
            if (Objects.nonNull(o2.getReduceOrder()) && Objects.nonNull(o2.getReduceRatio())) {
                throw new BusinessException("\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u6bd4\u4f8b\u548c\u987a\u5e8f");
            }
            if (Objects.isNull(o2.getReduceOrder()) && Objects.isNull(o2.getReduceRatio())) {
                throw new BusinessException("\u6bd4\u4f8b\u548c\u987a\u5e8f\u5fc5\u987b\u9009\u62e9\u4e00\u9879\u586b\u5199");
            }
            if (Objects.nonNull(o2.getReduceRatio())) {
                this.isUserRatio = true;
                reduceRatioSet.add(o2.getReduceRatio());
            }
            if (Objects.nonNull(o2.getReduceOrder())) {
                this.isUseOrder = true;
                reduceOrderSet.add(o2.getReduceOrder());
            }
            TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)feeBudgetEntityMap.get(o2.getFeeBudgetCode()));
            AssertUtils.isNotNull((Object)((Object)feeBudgetEntity), (String)("\u8d39\u7528\u9884\u7b97:" + o2.getFeeBudgetCode() + ",\u4e0d\u5b58\u5728"));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)feeBudgetEntity.getEnableStatus()), (String)("\u8d39\u7528\u9884\u7b97:" + o2.getFeeBudgetCode() + ",\u5df2\u7ecf\u88ab\u7981\u7528"));
            String mapKey = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o2.getFeeBudgetType()) ? feeBudgetEntity.getFeeBudgetType() + feeBudgetEntity.getOrgType() : feeBudgetEntity.getFeeBudgetType();
            if (CollectionUtils.isNotEmpty((Collection)reduceOrderSet)) {
                Integer integer = this.reduceOrderMap.get(mapKey);
                if (Objects.isNull(integer)) {
                    this.reduceOrderMap.put(mapKey, o2.getReduceOrder());
                } else {
                    AssertUtils.isTrue((boolean)Objects.equals(integer, o2.getReduceOrder()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u987a\u5e8f\u5fc5\u987b\u4e00\u81f4");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)reduceRatioSet)) {
                BigDecimal bigDecimal = this.reduceRatioMap.get(mapKey);
                if (Objects.isNull(bigDecimal)) {
                    this.reduceRatioMap.put(mapKey, o2.getReduceRatio());
                } else {
                    AssertUtils.isTrue((boolean)Objects.equals(bigDecimal, o2.getReduceRatio()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u6bd4\u4f8b\u5fc5\u987b\u4e00\u81f4");
                }
            }
            o2.setActCode(this.reqVo.getActCode());
            o2.setControlId(feeBudgetEntity.getControlId());
            o2.setOrgType(feeBudgetEntity.getOrgType());
        }
        if (this.isUseOrder.booleanValue() && this.isUserRatio.booleanValue()) {
            throw new BusinessException("\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u6bd4\u4f8b\u548c\u987a\u5e8f");
        }
        if (CollectionUtils.isNotEmpty((Collection)reduceOrderSet)) {
            Integer max = reduceOrderSet.stream().map(o -> o).reduce(Integer::max).get();
            Integer min = reduceOrderSet.stream().map(o -> o).reduce(Integer::min).get();
            AssertUtils.isTrue((boolean)Objects.equals(max, reduceOrderSet.size()), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5927\u503c\u9519\u8bef");
            AssertUtils.isTrue((boolean)Objects.equals(min, 1), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5c0f\u503c\u5fc5\u987b\u4e3a1");
        }
        if (CollectionUtils.isNotEmpty((Collection)reduceRatioSet)) {
            BigDecimal bigDecimal = reduceRatioSet.stream().map(o -> o).reduce(BigDecimal::add).get();
            AssertUtils.isTrue((bigDecimal.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u6bd4\u4f8b\u548c\u5fc5\u987b\u7b49\u4e8e100");
        }
    }

    public void checkDetailData() {
        AssertUtils.isNotEmpty((Collection)this.reqVo.getDetailVos(), (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map categoriesEntitiesMap = this.categoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
        this.categoriesEntitiesMap = categoriesEntitiesMap;
        this.fineEntitiesMap = this.fineEntities.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
        AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (int i = 0; i < this.reqVo.getDetailVos().size(); ++i) {
            TpmActDetailReqVo o = (TpmActDetailReqVo)this.reqVo.getDetailVos().get(i);
            String categoriesFine = o.getCategoriesCode() + o.getFineCode();
            if (!this.categoriesFineSet.contains(categoriesFine)) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff0c\u660e\u7ec6\u4fe1\u606f\uff1a" + o.getCategoriesCode() + "/" + o.getCategoriesName() + "\u4e0e" + o.getFineCode() + "/" + o.getFineName() + "\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728");
            }
            AssertUtils.isNotNull((Object)o.getForecastSalesAmount(), (String)"\u9884\u4f30\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getPolicyCode(), (String)"\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())) {
                MdmCustomerMsgSelectRespVo customerVo = this.customerMap.get(o.getCustomerCode());
                o.setCustomerName(customerVo.getCustomerName());
                o.setOrgCode(customerVo.getOrgCode());
                o.setOrgName(customerVo.getOrgName());
            } else {
                AssertUtils.isNotEmpty((String)o.getOrgCode(), (String)"\u5ba2\u6237\u548c\u7ec4\u7ec7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                MdmOrgRespVo orgRespVo = this.orgMap.get(o.getOrgCode());
                o.setOrgName(orgRespVo.getOrgName());
            }
            RebateVo rebateVo = this.rebateMap.get(o.getPolicyCode());
            o.setPolicyName(rebateVo.getName());
            o.setFeeRate(Optional.ofNullable(rebateVo.getRate()).orElse(BigDecimal.ZERO));
            o.setApplyAmount(o.getFeeRate().divide(BigDecimal.valueOf(100L)).multiply(o.getForecastSalesAmount()));
            if (StringUtils.isEmpty((CharSequence)o.getActDetailCode())) {
                o.setActDetailCode(CodeUtil.createOneCode((String)"tpm_act_detail"));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.reqVo.getBeginDate()) && StringUtils.isNotEmpty((CharSequence)this.reqVo.getEndDate()) && StringUtils.isEmpty((CharSequence)o.getExecuteBeginDate())) {
                o.setExecuteBeginDate(this.reqVo.getBeginDate());
                o.setExecuteBeginDateSecond(this.reqVo.getBeginDateSecond());
                o.setExecuteEndDate(this.reqVo.getEndDate());
                o.setExecuteEndDateSecond(this.reqVo.getEndDateSecond());
            }
            TpmCostTypeFineEntity fineEntity = this.fineEntitiesMap.get(o.getFineCode());
            o.setFineName(fineEntity.getFineName());
            o.setIsAudit(fineEntity.getIsAudit());
            o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            o.setActivityReleaseNeed(fineEntity.getActivityReleaseNeed());
            o.setIsAllowRepeatAudit(fineEntity.getIsAllowRepeatAudit());
            this.getActDetailCanUseBudget(fineEntity, o);
            totalAmount.set(totalAmount.get().add(o.getApplyAmount()));
            TpmCostTypeCategoriesEntity categoriesEntity = (TpmCostTypeCategoriesEntity)((Object)categoriesEntitiesMap.get(o.getCategoriesCode()));
            o.setBudgetSubjectsCode(categoriesEntity.getBudgetSubjectsCode());
            o.setCategoriesName(categoriesEntity.getCategoriesName());
            this.reqVo.setTotalAmount(Optional.ofNullable(this.reqVo.getTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAmount()));
            MdmOrgRespVo mdmOrgRespVo = this.orgMap.get(o.getOrgCode());
            if (Objects.nonNull(mdmOrgRespVo)) {
                o.setOrgName(mdmOrgRespVo.getOrgName());
            }
            this.actDetailMap.put(o.getActDetailCode(), o);
            this.checkDetailProducts(o);
        }
    }

    private void getActDetailCanUseBudget(TpmCostTypeFineEntity fineEntity, TpmActDetailReqVo o) {
        MdmOrgRespVo detailOrgVo = this.orgMap.get(o.getOrgCode());
        AssertUtils.isNotNull((Object)detailOrgVo, (String)("\u6d3b\u52a8\u660e\u7ec6\u9009\u62e9\u7684\u7ec4\u7ec7:" + o.getOrgCode() + "\u4e0d\u5b58\u5728"));
        AssertUtils.isNotEmpty(this.feeBudgetEntities, (String)"\u5f53\u524d\u6d3b\u52a8\u5bf9\u5e94\u7684\u8d39\u7528\u9884\u7b97\u4e0d\u5b58\u5728");
        for (TpmFeeBudgetEntity r : this.feeBudgetEntities) {
            MdmOrgRespVo engineOrgRespVo = this.orgMap.get(r.getOrgCode());
            AssertUtils.isNotNull((Object)engineOrgRespVo, (String)("\u8d39\u7528\u9884\u7b97:" + r.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u7ec4\u7ec7\u4e0d\u5b58\u5728"));
            ArrayList entities = this.actDetailBudgetMap.get(o.getActDetailCode());
            if (CollectionUtils.isEmpty(entities)) {
                entities = Lists.newArrayList();
            }
            entities.add(r);
            this.actDetailBudgetMap.put(o.getActDetailCode(), entities);
        }
    }

    public void checkShareData() {
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFeeShareVos())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u5206\u644a\u8d39\u7528\u5230\u4ea7\u54c1");
        }
    }

    @Override
    public RebateActBuilder convert() {
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)this.actEntity));
        this.actEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        this.actEntity.setAuditTotalAmount(BigDecimal.ZERO);
        this.actEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
        this.reqVo.getBudgetVos().stream().forEach(o -> {
            TpmActBudgetEntity actBudgetEntity = new TpmActBudgetEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actBudgetEntity));
            o.setActCode(this.actEntity.getActCode());
            this.actBudgetEntities.add(actBudgetEntity);
        });
        this.reqVo.getDetailVos().forEach(o -> {
            TpmActDetailEntity actDetailEntity = new TpmActDetailEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actDetailEntity));
            actDetailEntity.setActCode(this.actEntity.getActCode());
            this.actDetailEntities.add(actDetailEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFeeShareVos())) {
            this.reqVo.getFeeShareVos().forEach(o -> {
                TmpActFeeShareEntity actFeeShareEntity = new TmpActFeeShareEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actFeeShareEntity));
                actFeeShareEntity.setActCode(this.actEntity.getActCode());
                this.shareEntities.add(actFeeShareEntity);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFileList())) {
            this.reqVo.getFileList().forEach(o -> {
                TpmActFileEntity fileEntity = new TpmActFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setActCode(this.actEntity.getActCode());
                this.fileEntities.add(fileEntity);
            });
        }
        return this;
    }

    public void convertFeeBudgetDetailsEntities() {
        String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
        String currentYear = String.valueOf(DateUtil.getCurrentYear());
        this.actDetailEntities.stream().forEach(o -> {
            TpmFeeBudgetDetailsEntity entity = new TpmFeeBudgetDetailsEntity();
            entity.setMonth(currentMonth);
            entity.setYear(currentYear);
            entity.setBusinessCode(this.actEntity.getActCode());
            entity.setBusinessLineCode(o.getActDetailCode());
            this.feeBudgetDetailsEntities.add(entity);
        });
    }

    @Override
    public TpmActEntity save() {
        this.helper.saveOrUpdateAct(this.actEntity, this.reqVo);
        this.helper.saveActBudgets(this.actBudgetEntities, this.reqVo);
        this.helper.saveActDetails(this.actDetailEntities, this.reqVo);
        this.helper.saveActShares(this.shareEntities, this.reqVo);
        this.helper.saveActFiles(this.fileEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailsEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveFeeBudgetControls(this.controlEntities, this.reqVo);
        this.helper.saveActDetailProducts(this.detailProductEntities, this.reqVo);
        return this.actEntity;
    }

    @Override
    public TpmActEntity update() {
        this.helper.saveOrUpdateAct(this.actEntity, this.reqVo);
        this.helper.saveActBudgets(this.actBudgetEntities, this.reqVo);
        this.helper.saveActDetails(this.actDetailEntities, this.reqVo);
        this.helper.saveActShares(this.shareEntities, this.reqVo);
        this.helper.saveActFiles(this.fileEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailsEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveFeeBudgetControls(this.controlEntities, this.reqVo);
        this.helper.saveActDetailProducts(this.detailProductEntities, this.reqVo);
        return this.actEntity;
    }

    public void checkDetailProducts(TpmActDetailReqVo detailReqVo) {
        TpmActDetailProductEntity entity2;
        MdmProductRespVo mdmProductRespVo;
        TpmCostTypeFineEntity fineEntity = this.fineEntitiesMap.get(detailReqVo.getFineCode());
        if (CollectionUtils.isNotEmpty((Collection)detailReqVo.getGiftProductList())) {
            List giftProductList = detailReqVo.getGiftProductList();
            HashSet giftProductCodes = Sets.newHashSet();
            for (TpmActDetailProductVo o : giftProductList) {
                AssertUtils.isNotEmpty((String)o.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((!giftProductCodes.contains(o.getProductCode()) ? 1 : 0) != 0, (String)"\u8d60\u54c1\u4ea7\u54c1\u91cd\u590d");
                giftProductCodes.add(o.getProductCode());
                mdmProductRespVo = this.productMap.get(o.getProductCode());
                AssertUtils.isNotNull((Object)mdmProductRespVo, (String)("\u5546\u54c1\u7f16\u7801:" + o.getProductCode() + "\u4e0d\u5b58\u5728"));
                o.setActCode(this.reqVo.getActCode());
                o.setProductType(ActDetailProductTypeEnum.GIFT.getCode());
                o.setPaymentMethod(fineEntity.getPaymentMethod());
                o.setProductName(mdmProductRespVo.getProductName());
                o.setPrice(mdmProductRespVo.getExt21());
                o.setActDetailCode(detailReqVo.getActDetailCode());
                TpmActDetailProductEntity entity1 = (TpmActDetailProductEntity)((Object)CrmBeanUtil.copy((Object)o, TpmActDetailProductEntity.class));
                this.detailProductEntities.add(entity1);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)detailReqVo.getNormalProductList())) {
            List normalProductList = detailReqVo.getNormalProductList();
            HashSet normalProductCodes = Sets.newHashSet();
            for (TpmActDetailProductVo o : normalProductList) {
                AssertUtils.isNotEmpty((String)o.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((!normalProductCodes.contains(o.getProductCode()) ? 1 : 0) != 0, (String)"\u672c\u54c1\u4ea7\u54c1\u91cd\u590d");
                normalProductCodes.add(o.getProductCode());
                mdmProductRespVo = this.productMap.get(o.getProductCode());
                AssertUtils.isNotNull((Object)mdmProductRespVo, (String)("\u5546\u54c1\u7f16\u7801:" + o.getProductCode() + "\u4e0d\u5b58\u5728"));
                o.setActCode(this.reqVo.getActCode());
                o.setProductType(ActDetailProductTypeEnum.NORMAL.getCode());
                o.setPaymentMethod(fineEntity.getPaymentMethod());
                o.setProductName(mdmProductRespVo.getProductName());
                o.setPrice(mdmProductRespVo.getExt21());
                o.setActDetailCode(detailReqVo.getActDetailCode());
                entity2 = (TpmActDetailProductEntity)((Object)CrmBeanUtil.copy((Object)o, TpmActDetailProductEntity.class));
                this.detailProductEntities.add(entity2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)detailReqVo.getReplenishmentProductList())) {
            List replenishmentProductList = detailReqVo.getReplenishmentProductList();
            HashSet replenishmentProductCodes = Sets.newHashSet();
            for (TpmActDetailProductVo o : replenishmentProductList) {
                AssertUtils.isNotEmpty((String)o.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((!replenishmentProductCodes.contains(o.getProductCode()) ? 1 : 0) != 0, (String)"\u8d27\u8865\u4ea7\u54c1\u91cd\u590d");
                replenishmentProductCodes.add(o.getProductCode());
                mdmProductRespVo = this.productMap.get(o.getProductCode());
                AssertUtils.isNotNull((Object)mdmProductRespVo, (String)("\u5546\u54c1\u7f16\u7801:" + o.getProductCode() + "\u4e0d\u5b58\u5728"));
                o.setActCode(this.reqVo.getActCode());
                o.setProductType(ActDetailProductTypeEnum.REPLENISHMENT.getCode());
                o.setProductName(mdmProductRespVo.getProductName());
                o.setActDetailCode(detailReqVo.getActDetailCode());
                entity2 = (TpmActDetailProductEntity)((Object)CrmBeanUtil.copy((Object)o, TpmActDetailProductEntity.class));
                this.detailProductEntities.add(entity2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)detailReqVo.getExecutionProductList())) {
            List executionProductList = detailReqVo.getExecutionProductList();
            HashSet executionProductCodes = Sets.newHashSet();
            for (TpmActDetailProductVo o : executionProductList) {
                AssertUtils.isNotEmpty((String)o.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((!executionProductCodes.contains(o.getProductCode()) ? 1 : 0) != 0, (String)"\u6267\u884c\u4ea7\u54c1\u91cd\u590d");
                executionProductCodes.add(o.getProductCode());
                mdmProductRespVo = this.productMap.get(o.getProductCode());
                AssertUtils.isNotNull((Object)mdmProductRespVo, (String)("\u5546\u54c1\u7f16\u7801:" + o.getProductCode() + "\u4e0d\u5b58\u5728"));
                o.setActCode(this.reqVo.getActCode());
                o.setProductType(ActDetailProductTypeEnum.EXECUTION.getCode());
                o.setProductName(mdmProductRespVo.getProductName());
                o.setActDetailCode(detailReqVo.getActDetailCode());
                entity2 = (TpmActDetailProductEntity)((Object)CrmBeanUtil.copy((Object)o, TpmActDetailProductEntity.class));
                this.detailProductEntities.add(entity2);
            }
        }
    }
}

