/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.financesubject.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.financesubject.service.TpmFinanceSubjectService;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmFinanceSubjectController"})
@Api(tags={"\u8d22\u52a1\u79d1\u76ee\u8868 "})
public class TpmFinanceSubjectController {
    private static final Logger log = LoggerFactory.getLogger(TpmFinanceSubjectController.class);
    @Autowired
    private TpmFinanceSubjectService financeSubjectService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmFinanceSubjectRespVo>> list(@RequestBody TpmFinanceSubjectReqVo reqVo) {
        PageResult<TpmFinanceSubjectRespVo> result = this.financeSubjectService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="/\u67e5\u770b")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmFinanceSubjectRespVo> query(@RequestParam(value="id", required=false) String id) {
        TpmFinanceSubjectRespVo tpmFinanceSubjectRespVo = this.financeSubjectService.queryView(id);
        return Result.ok((Object)tpmFinanceSubjectRespVo);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="/\u65b0\u589e")
    @CrmLog
    public Result save(@RequestBody TpmFinanceSubjectReqVo reqVo) {
        this.financeSubjectService.save(reqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="/\u4fee\u6539")
    @CrmLog
    public Result update(@RequestBody TpmFinanceSubjectReqVo reqVo) {
        this.financeSubjectService.update(reqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="/\u6279\u91cf\u5220\u9664")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.financeSubjectService.batchDelete(ids);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/disable"})
    @ApiOperation(value="/\u6279\u91cf\u7981\u7528")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.financeSubjectService.batchDisable(ids);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/enable"})
    @ApiOperation(value="/\u6279\u91cf\u542f\u7528")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.financeSubjectService.batchEnable(ids);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

