/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sale.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.sale.service.ITpmSalesDataService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmsalesdata"})
@Api(tags={"\u5b9e\u9645\u9500\u552e\u6570\u636e "})
public class TpmSalesDataController {
    private static final Logger log = LoggerFactory.getLogger(TpmSalesDataController.class);
    @Autowired
    private ITpmSalesDataService tpmSalesDataService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmSalesDataRespVo>> list(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        PageResult<TpmSalesDataRespVo> result = this.tpmSalesDataService.findList(tpmSalesDataReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmSalesDataRespVo> query(@RequestParam(value="id") String id) {
        TpmSalesDataRespVo respVo = this.tpmSalesDataService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        this.tpmSalesDataService.save(tpmSalesDataReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        this.tpmSalesDataService.update(tpmSalesDataReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmSalesDataService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        this.tpmSalesDataService.enableBatch(tpmSalesDataReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        this.tpmSalesDataService.disableBatch(tpmSalesDataReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

