/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sale.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.sale.mapper.TpmSalesDataMapper;
import com.biz.crm.sale.model.TpmSalesDataEntity;
import com.biz.crm.sale.service.ITpmSalesDataService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmSalesDataServiceExpandImpl"})
public class TpmSalesDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmSalesDataMapper, TpmSalesDataEntity>
implements ITpmSalesDataService {
    private static final Logger log = LoggerFactory.getLogger(TpmSalesDataServiceImpl.class);
    @Resource
    private TpmSalesDataMapper tpmSalesDataMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<TpmSalesDataRespVo> findList(TpmSalesDataReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmSalesDataRespVo> list = this.tpmSalesDataMapper.findList((Page<TpmSalesDataRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmSalesDataRespVo query(String id) {
        TpmSalesDataEntity tpmSalesDataEntity = (TpmSalesDataEntity)((Object)this.getById((Serializable)((Object)id)));
        return (TpmSalesDataRespVo)CrmBeanUtil.copy((Object)((Object)tpmSalesDataEntity), TpmSalesDataRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmSalesDataReqVo reqVo) {
        TpmSalesDataEntity entity = (TpmSalesDataEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmSalesDataEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmSalesDataRespVo newData = (TpmSalesDataRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmSalesDataRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmSalesDataReqVo reqVo) {
        TpmSalesDataEntity entity = (TpmSalesDataEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        TpmSalesDataRespVo oldData = (TpmSalesDataRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmSalesDataRespVo.class);
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)FeeBudgetException.DATA_NOT_EXIST, (String[])new String[0]);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmSalesDataRespVo newData = (TpmSalesDataRespVo)CrmBeanUtil.copy((Object)reqVo, TpmSalesDataRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmSalesDataEntities = this.tpmSalesDataMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesDataEntities)) {
            tpmSalesDataEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmSalesDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmSalesDataReqVo reqVo) {
        List tpmSalesDataEntities = this.tpmSalesDataMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesDataEntities)) {
            tpmSalesDataEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmSalesDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmSalesDataReqVo reqVo) {
        List tpmSalesDataEntities = this.tpmSalesDataMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmSalesDataEntities)) {
            tpmSalesDataEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmSalesDataEntities);
    }
}

