/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.advancepay.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.advancepay.service.ITpmActAdvancePayService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmActAdvancePayController"})
@Api(tags={"\u6d3b\u52a8\u9884\u4ed8\u4e3b\u8868 "})
public class TpmActAdvancePayController {
    private static final Logger log = LoggerFactory.getLogger(TpmActAdvancePayController.class);
    @Autowired
    private ITpmActAdvancePayService tpmActAdvancePayService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmActAdvancePayRespVo>> list(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        PageResult<TpmActAdvancePayRespVo> result = this.tpmActAdvancePayService.findList(tpmActAdvancePayReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmActAdvancePayRespVo> query(@RequestParam(value="id", required=false) String id) {
        TpmActAdvancePayRespVo respVo = this.tpmActAdvancePayService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        this.tpmActAdvancePayService.save(tpmActAdvancePayReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        this.tpmActAdvancePayService.update(tpmActAdvancePayReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmActAdvancePayService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmActAdvancePayService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmActAdvancePayService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/approve"})
    @CrmLog
    public Result approve(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        this.tpmActAdvancePayService.approve(tpmActAdvancePayReqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        log.info("\u9884\u4ed8\u6536\u5230\u5de5\u4f5c\u6d41\u56de\u8c03\u8bf7\u6c42,\u8bf7\u6c42\u53c2\u6570={}", (Object)JSON.toJSONString((Object)activitiCallBackVo));
        this.tpmActAdvancePayService.activityCallBack(activitiCallBackVo);
        return Result.ok((String)"\u6d3b\u52a8\u9884\u4ed8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }
}

