/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl.actbuilder;

import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.act.service.impl.actbuilder.ActBaseBuilder;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActivityReleaseNeedEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PracticalityChargeActBuilder
extends BaseServiceHelper
implements ActBaseBuilder {
    private static final Logger log = LoggerFactory.getLogger(PracticalityChargeActBuilder.class);
    private ActServiceHelper helper;
    private TpmActReqVo reqVo;
    private TpmActEntity actEntity = new TpmActEntity();
    private List<TpmActBudgetEntity> actBudgetEntities = Lists.newArrayList();
    private List<TpmActDetailEntity> actDetailEntities = Lists.newArrayList();
    private List<TmpActFeeShareEntity> shareEntities = Lists.newArrayList();
    private List<TpmActFileEntity> fileEntities = Lists.newArrayList();
    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = Lists.newArrayList();
    private List<TpmFeeBudgetEntity> feeBudgetEntities;
    private List<TpmCostTypeCategoriesEntity> categoriesEntities;
    private List<TpmCostTypeFineEntity> fineEntities;
    private List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities;
    private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;
    private Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap;
    private Map<String, TpmCostTypeFineEntity> fineEntitiesMap;
    private Map<String, TpmCostTypeCategoriesFineEntity> categoriesFineEntitiesMap;
    private Set<String> categoriesFineSet = Sets.newHashSet();
    private List<TpmFeeBudgetControlEntity> controlEntities;
    Map<String, MdmCustomerMsgSelectRespVo> customerMap;
    private Map<String, MdmOrgRespVo> orgMap;
    private Boolean isUseOrder = false;
    private Boolean isUserRatio = false;
    private Map<String, Integer> reduceOrderMap = Maps.newHashMap();
    private Map<String, BigDecimal> reduceRatioMap = Maps.newHashMap();
    private Map<String, TpmActDetailReqVo> actDetailMap = Maps.newHashMap();
    private Map<String, List<TpmFeeBudgetEntity>> actDetailBudgetMap = Maps.newHashMap();
    private Map<String, TpmBudgetSubjectsEntity> subjectsMap;

    public PracticalityChargeActBuilder(ActServiceHelper helper, TpmActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static PracticalityChargeActBuilder builder(ActServiceHelper helper, TpmActReqVo reqVo) {
        return new PracticalityChargeActBuilder(helper, reqVo);
    }

    @Override
    public PracticalityChargeActBuilder init() {
        HashSet orgCodes = Sets.newHashSet();
        HashSet customerCodes = Sets.newHashSet();
        HashSet controlIds = Sets.newHashSet();
        HashSet subjectsCodes = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetControlVos())) {
            ArrayList budgetVos = Lists.newArrayList();
            for (TpmFeeBudgetControlRespVo o2 : this.reqVo.getBudgetControlVos()) {
                controlIds.add(o2.getId());
                List feeBudgetVos = o2.getFeeBudgetVos();
                if (!CollectionUtils.isNotEmpty((Collection)feeBudgetVos)) continue;
                List<Object> budgets = Lists.newArrayList();
                budgets = feeBudgetVos.stream().map(x -> {
                    TpmActBudgetReqVo tpmActBudgetReqVo = new TpmActBudgetReqVo();
                    tpmActBudgetReqVo.setActCode(x.getActCode());
                    tpmActBudgetReqVo.setControlId(x.getControlId());
                    tpmActBudgetReqVo.setReduceOrder(x.getReduceOrder());
                    tpmActBudgetReqVo.setReduceRatio(x.getReduceRatio());
                    tpmActBudgetReqVo.setId(x.getId());
                    tpmActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
                    tpmActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
                    tpmActBudgetReqVo.setOrgType(x.getOrgType());
                    return tpmActBudgetReqVo;
                }).collect(Collectors.toList());
                budgetVos.addAll(budgets);
            }
            this.reqVo.setBudgetVos((List)budgetVos);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetVos())) {
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.helper.findFeeBudgetByControlIds(controlIds);
            if (CollectionUtils.isNotEmpty(feeBudgetEntities)) {
                feeBudgetEntities.forEach(o -> {
                    if (StringUtils.isNotEmpty((CharSequence)o.getOrgCode())) {
                        orgCodes.add(o.getOrgCode());
                    }
                    AssertUtils.isNotEmpty((String)o.getControlId(), (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + "\u6570\u636e\u5f02\u5e38,\u63a7\u5236\u4e3a\u7ef4\u5ea6id\u4e3a\u7a7a"));
                    subjectsCodes.add(o.getBudgetSubjectsCode());
                });
                this.feeBudgetEntities = feeBudgetEntities;
            }
        } else {
            throw new BusinessException("\u8bf7\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        }
        Map payTypeTypeMap = this.helper.getPayTypeTypeMap("pay_type_d", "pay_type_type");
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getDetailVos())) {
            HashSet categoriesCodes = Sets.newHashSet();
            HashSet fineCodes = Sets.newHashSet();
            this.reqVo.getDetailVos().forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                categoriesCodes.add(o.getCategoriesCode());
                o.setOrgCode((String)Lists.newArrayList((Iterable)orgCodes).get(0));
                fineCodes.add(o.getFineCode());
                if (StringUtils.isNotEmpty((CharSequence)o.getOrgCode())) {
                    orgCodes.add(o.getOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())) {
                    customerCodes.add(o.getCustomerCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayType())) {
                    o.setPayTypeType((String)payTypeTypeMap.get(o.getPayType()));
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)categoriesCodes) && CollectionUtils.isNotEmpty((Collection)fineCodes)) {
                if (categoriesCodes.size() > 1) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38,\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u4e2d\u7684\u6d3b\u52a8\u5927\u7c7b\u4e0d\u4e00\u81f4");
                }
                this.categoriesFineSet = this.helper.findCategoriesFineEntities(categoriesCodes, fineCodes).stream().map(o -> o.getCategoriesCode() + o.getFineCode()).collect(Collectors.toSet());
            }
            this.categoriesEntities = this.helper.findCategoriesEntitiesByCodes(categoriesCodes);
            this.fineEntities = this.helper.findFineEntitiesByCodes(fineCodes);
            this.categoriesFineEntities = this.helper.findCategoriesFineEntities(categoriesCodes, fineCodes);
            this.orgMap = this.helper.findOrgByCodes(orgCodes);
            this.customerMap = this.helper.findCustomerByCodes(customerCodes);
            this.controlEntities = this.helper.findFeeBudgetControls(controlIds);
            this.subjectsMap = this.helper.findBudgetSubjectsByCodes(subjectsCodes);
        }
        return this;
    }

    @Override
    public PracticalityChargeActBuilder check() {
        this.checkActData();
        this.checkFeeBudgetData();
        this.checkDetailData();
        this.checkFeeBudgetIsEnough();
        this.checkShareData();
        return this;
    }

    private void checkFeeBudgetIsEnough() {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType())) {
            return;
        }
        Map controlEntityMap = this.controlEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        for (int i = 0; i < this.reqVo.getDetailVos().size(); ++i) {
            BigDecimal subtract;
            TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity;
            TpmFeeBudgetControlEntity controlEntity;
            TpmBudgetSubjectsEntity subjectsEntity;
            TpmActDetailReqVo o = (TpmActDetailReqVo)this.reqVo.getDetailVos().get(i);
            List<TpmFeeBudgetEntity> budgetEntities = this.actDetailBudgetMap.get(o.getActDetailCode());
            AssertUtils.isNotEmpty(budgetEntities, (String)("\u60a8\u9009\u62e9\u7684\u7b2c" + (i + 1) + "\u6761\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u6ca1\u6709\u53ef\u7528\u7684\u8d39\u7528\u9884\u7b97"));
            HashMap map = Maps.newHashMap();
            budgetEntities.forEach(p -> {
                String key = "";
                key = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)p.getFeeBudgetType()) ? p.getFeeBudgetType() + p.getOrgType() : p.getFeeBudgetType();
                List tpmFeeBudgetEntities = (List)map.get(key);
                if (CollectionUtils.isEmpty((Collection)tpmFeeBudgetEntities)) {
                    tpmFeeBudgetEntities = Lists.newArrayList();
                }
                tpmFeeBudgetEntities.add(p);
                map.put(key, tpmFeeBudgetEntities);
            });
            int orderCount = 1;
            if (this.isUseOrder.booleanValue()) {
                Map invertMap = MapUtils.invertMap(this.reduceOrderMap);
                AtomicReference<BigDecimal> applyAmount = new AtomicReference<BigDecimal>(o.getApplyAmount());
                for (int y = 1; y <= invertMap.keySet().size(); ++y) {
                    String k = (String)invertMap.get(y);
                    List entityList = (List)map.get(k);
                    if (CollectionUtils.isEmpty((Collection)entityList)) continue;
                    List collect = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
                    for (TpmFeeBudgetEntity t : collect) {
                        subjectsEntity = this.subjectsMap.get(t.getBudgetSubjectsCode());
                        AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)("\u8d39\u7528\u9884\u7b97:" + t.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u9884\u7b97\u79d1\u76ee:" + t.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728"));
                        controlEntity = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(t.getControlId()));
                        feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                        CrmBeanUtil.copyProperties((Object)((Object)t), (Object)((Object)feeBudgetDetailsEntity));
                        super.setPublicParamsNull((CrmBaseEntity)feeBudgetDetailsEntity);
                        feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
                        if (StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                            t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                            t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                            feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                            controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                            applyAmount.set(BigDecimal.ZERO);
                        } else {
                            subtract = applyAmount.get().subtract(t.getCanUseAmount());
                            if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                                t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                                t.setCanUseAmount(BigDecimal.ZERO);
                                applyAmount.set(subtract);
                            } else {
                                t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                                t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                                applyAmount.set(BigDecimal.ZERO);
                            }
                        }
                        feeBudgetDetailsEntity.setBusinessCode(this.reqVo.getActCode());
                        feeBudgetDetailsEntity.setYear(t.getBudgetYear());
                        feeBudgetDetailsEntity.setMonth(t.getBudgetMonth());
                        feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
                        feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                        feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                        feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
                        feeBudgetDetailsEntity.setBusinessName(this.reqVo.getActName());
                        feeBudgetDetailsEntity.setReduceOrder(orderCount);
                        feeBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
                        feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                        ++orderCount;
                        this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
                    }
                }
                AssertUtils.isTrue((applyAmount.get().compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u60a8\u9009\u62e9\u7684\u7b2c" + (i + 1) + "\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u8d39\u7528\u9884\u7b97\u4f59\u989d\u4e0d\u8db3"));
            }
            if (!this.isUserRatio.booleanValue()) continue;
            for (String k : this.reduceRatioMap.keySet()) {
                List entityList = (List)map.get(k);
                BigDecimal ratio = this.reduceRatioMap.get(k);
                AssertUtils.isNotEmpty((Collection)entityList, (String)("\u4f7f\u7528\u6bd4\u4f8b\u6263\u51cf\u65f6,\u7ef4\u5ea6:" + k + "\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e\u4e3a\u7a7a"));
                List list = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
                AtomicReference<BigDecimal> applyAmount = new AtomicReference<BigDecimal>(o.getApplyAmount().multiply(ratio).divide(BigDecimal.valueOf(100L)));
                for (TpmFeeBudgetEntity t : list) {
                    subjectsEntity = this.subjectsMap.get(t.getBudgetSubjectsCode());
                    controlEntity = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(t.getControlId()));
                    feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                    CrmBeanUtil.copyProperties((Object)((Object)t), (Object)((Object)feeBudgetDetailsEntity));
                    super.setPublicParamsNull((CrmBaseEntity)feeBudgetDetailsEntity);
                    feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
                    subtract = applyAmount.get().subtract(t.getCanUseAmount());
                    if (StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                        t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                        t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                        feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                        controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                        applyAmount.set(BigDecimal.ZERO);
                    } else if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                        t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                        controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                        feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                        t.setCanUseAmount(BigDecimal.ZERO);
                        applyAmount.set(subtract);
                    } else {
                        t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                        t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                        feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                        controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                        applyAmount.set(BigDecimal.ZERO);
                    }
                    feeBudgetDetailsEntity.setBusinessCode(this.reqVo.getActCode());
                    feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
                    feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                    feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                    feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
                    feeBudgetDetailsEntity.setBusinessName(this.reqVo.getActName());
                    feeBudgetDetailsEntity.setReduceOrder(orderCount);
                    feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    ++orderCount;
                    feeBudgetDetailsEntity.setReduceRatio(ratio);
                    this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
                }
                AssertUtils.isTrue((applyAmount.get().compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u60a8\u9009\u62e9\u7684\u7b2c" + (i + 1) + "\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u8d39\u7528\u9884\u7b97\u4f59\u989d\u4e0d\u8db3"));
            }
        }
    }

    private void checkActData() {
        AssertUtils.isNotEmpty((String)this.reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getSaveType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getEndDateSecond())) {
            this.reqVo.setEndDateSecond("23:59:59");
        }
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getBeginDateSecond())) {
            this.reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(this.reqVo.getBeginDate() + this.reqVo.getBeginDateSecond()), (String)(this.reqVo.getEndDate() + this.reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getActCode())) {
            String actCode = CodeUtil.createOneCode((String)"tpm_act");
            this.reqVo.setActCode(actCode);
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getActType(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
    }

    public void checkFeeBudgetData() {
        AssertUtils.isNotNull((Object)this.reqVo.getBudgetVos(), (String)"\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((this.reqVo.getBudgetVos().size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u9009\u62e9\u76f8\u540c\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e");
        AssertUtils.isTrue((this.feeBudgetEntities.size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u53d1\u751f\u53d8\u52a8,\u8bf7\u91cd\u65b0\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        HashMap feeBudgetEntityMap = Maps.newHashMap();
        HashSet feeBudgetTypeSet = Sets.newHashSet();
        this.feeBudgetEntities.stream().forEach(o -> {
            feeBudgetEntityMap.put(o.getFeeBudgetCode(), o);
            if (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o.getFeeBudgetType())) {
                feeBudgetTypeSet.add(o.getFeeBudgetType() + o.getOrgType());
            } else {
                feeBudgetTypeSet.add(o.getFeeBudgetType());
            }
        });
        this.feeBudgetEntityMap = feeBudgetEntityMap;
        HashSet reduceOrderSet = Sets.newHashSet();
        HashSet reduceRatioSet = Sets.newHashSet();
        for (TpmActBudgetReqVo o2 : this.reqVo.getBudgetVos()) {
            if (Objects.nonNull(o2.getReduceOrder()) && Objects.nonNull(o2.getReduceRatio())) {
                throw new BusinessException("\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u6bd4\u4f8b\u548c\u987a\u5e8f");
            }
            if (Objects.isNull(o2.getReduceOrder()) && Objects.isNull(o2.getReduceRatio())) {
                throw new BusinessException("\u6bd4\u4f8b\u548c\u987a\u5e8f\u5fc5\u987b\u9009\u62e9\u4e00\u9879\u586b\u5199");
            }
            if (Objects.nonNull(o2.getReduceRatio())) {
                this.isUserRatio = true;
                reduceRatioSet.add(o2.getReduceRatio());
            }
            if (Objects.nonNull(o2.getReduceOrder())) {
                this.isUseOrder = true;
                reduceOrderSet.add(o2.getReduceOrder());
            }
            TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)feeBudgetEntityMap.get(o2.getFeeBudgetCode()));
            AssertUtils.isNotNull((Object)((Object)feeBudgetEntity), (String)("\u8d39\u7528\u9884\u7b97:" + o2.getFeeBudgetCode() + ",\u4e0d\u5b58\u5728"));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)feeBudgetEntity.getEnableStatus()), (String)("\u8d39\u7528\u9884\u7b97:" + o2.getFeeBudgetCode() + ",\u5df2\u7ecf\u88ab\u7981\u7528"));
            String mapKey = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o2.getFeeBudgetType()) ? feeBudgetEntity.getFeeBudgetType() + feeBudgetEntity.getOrgType() : feeBudgetEntity.getFeeBudgetType();
            if (CollectionUtils.isNotEmpty((Collection)reduceOrderSet)) {
                Integer integer = this.reduceOrderMap.get(mapKey);
                if (Objects.isNull(integer)) {
                    this.reduceOrderMap.put(mapKey, o2.getReduceOrder());
                } else {
                    AssertUtils.isTrue((boolean)Objects.equals(integer, o2.getReduceOrder()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u987a\u5e8f\u5fc5\u987b\u4e00\u81f4");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)reduceRatioSet)) {
                BigDecimal bigDecimal = this.reduceRatioMap.get(mapKey);
                if (Objects.isNull(bigDecimal)) {
                    this.reduceRatioMap.put(mapKey, o2.getReduceRatio());
                } else {
                    AssertUtils.isTrue((boolean)Objects.equals(bigDecimal, o2.getReduceRatio()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u6bd4\u4f8b\u5fc5\u987b\u4e00\u81f4");
                }
            }
            o2.setActCode(this.reqVo.getActCode());
            o2.setControlId(feeBudgetEntity.getControlId());
            o2.setOrgType(feeBudgetEntity.getOrgType());
        }
        if (this.isUseOrder.booleanValue() && this.isUserRatio.booleanValue()) {
            throw new BusinessException("\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u6bd4\u4f8b\u548c\u987a\u5e8f");
        }
        if (CollectionUtils.isNotEmpty((Collection)reduceOrderSet)) {
            Integer max = reduceOrderSet.stream().map(o -> o).reduce(Integer::max).get();
            Integer min = reduceOrderSet.stream().map(o -> o).reduce(Integer::min).get();
            AssertUtils.isTrue((boolean)Objects.equals(max, reduceOrderSet.size()), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5927\u503c\u9519\u8bef");
            AssertUtils.isTrue((boolean)Objects.equals(min, 1), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5c0f\u503c\u5fc5\u987b\u4e3a1");
        }
        if (CollectionUtils.isNotEmpty((Collection)reduceRatioSet)) {
            BigDecimal bigDecimal = reduceRatioSet.stream().map(o -> o).reduce(BigDecimal::add).get();
            AssertUtils.isTrue((bigDecimal.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u6bd4\u4f8b\u548c\u5fc5\u987b\u7b49\u4e8e100");
        }
    }

    public void checkDetailData() {
        AssertUtils.isNotEmpty((Collection)this.reqVo.getDetailVos(), (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map categoriesEntitiesMap = this.categoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
        this.categoriesEntitiesMap = categoriesEntitiesMap;
        this.fineEntitiesMap = this.fineEntities.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
        AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        this.reqVo.getDetailVos().forEach(o -> {
            String categoriesFine = o.getCategoriesCode() + o.getFineCode();
            if (!this.categoriesFineSet.contains(categoriesFine)) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff0c\u660e\u7ec6\u4fe1\u606f\uff1a" + o.getCategoriesCode() + "/" + o.getCategoriesName() + "\u4e0e" + o.getFineCode() + "/" + o.getFineName() + "\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728");
            }
            this.actDetailMap.put(o.getActDetailCode(), (TpmActDetailReqVo)o);
            AssertUtils.isNotNull((Object)o.getApplyAmount(), (String)"\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getMaterialCode(), (String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isEmpty((CharSequence)o.getActDetailCode())) {
                o.setActDetailCode(CodeUtil.createOneCode((String)"tpm_act_detail"));
            }
            if (StringUtils.isEmpty((CharSequence)o.getExecuteBeginDate())) {
                o.setExecuteBeginDate(this.reqVo.getBeginDate());
                o.setExecuteBeginDateSecond(this.reqVo.getBeginDateSecond());
                o.setExecuteEndDate(this.reqVo.getEndDate());
                o.setExecuteEndDateSecond(this.reqVo.getEndDateSecond());
            }
            AssertUtils.isNotEmpty((String)o.getFeeDateStr(), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)DateUtil.judgeDateStrBetween((String)o.getFeeDateStr(), (String)o.getExecuteBeginDate(), (String)o.getExecuteEndDate()), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u5fc5\u987b\u5728\u6d3b\u52a8\u660e\u7ec6\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u8303\u56f4\u5185");
            TpmCostTypeFineEntity fineEntity = this.fineEntitiesMap.get(o.getFineCode());
            o.setFineName(fineEntity.getFineName());
            o.setIsAudit(fineEntity.getIsAudit());
            o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            o.setActivityReleaseNeed(fineEntity.getActivityReleaseNeed());
            o.setIsAllowRepeatAudit(fineEntity.getIsAllowRepeatAudit());
            this.getActDetailCanUseBudget(fineEntity, (TpmActDetailReqVo)o);
            totalAmount.set(((BigDecimal)totalAmount.get()).add(o.getApplyAmount()));
            TpmCostTypeCategoriesEntity categoriesEntity = (TpmCostTypeCategoriesEntity)((Object)((Object)categoriesEntitiesMap.get(o.getCategoriesCode())));
            o.setBudgetSubjectsCode(categoriesEntity.getBudgetSubjectsCode());
            o.setCategoriesName(categoriesEntity.getCategoriesName());
            this.reqVo.setTotalAmount(Optional.ofNullable(this.reqVo.getTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAmount()));
            MdmOrgRespVo mdmOrgRespVo = this.orgMap.get(o.getOrgCode());
            if (Objects.nonNull(mdmOrgRespVo)) {
                o.setOrgName(mdmOrgRespVo.getOrgName());
            }
        });
        this.reqVo.setTotalAmount(totalAmount.get());
    }

    private void checkFeeDateStr(String feeDateStr, String beginDate, String endDate) {
        List<String> feeDateStrList = Arrays.asList(StringUtils.split((String)feeDateStr, (String)"-"));
        List<String> beginDateList = Arrays.asList(StringUtils.split((String)beginDate, (String)"-"));
        List<String> endDateList = Arrays.asList(StringUtils.split((String)endDate, (String)"-"));
        AssertUtils.isTrue((feeDateStrList.get(0).compareTo(beginDateList.get(0)) >= 0 && feeDateStrList.get(0).compareTo(endDateList.get(0)) <= 0 ? 1 : 0) != 0, (String)"");
        AssertUtils.isTrue((feeDateStrList.get(1).compareTo(beginDateList.get(1)) >= 0 && feeDateStrList.get(1).compareTo(endDateList.get(1)) <= 0 ? 1 : 0) != 0, (String)"");
    }

    private void getActDetailCanUseBudget(TpmCostTypeFineEntity fineEntity, TpmActDetailReqVo o) {
        MdmOrgRespVo detailOrgVo = this.orgMap.get(o.getOrgCode());
        AssertUtils.isNotNull((Object)detailOrgVo, (String)("\u6d3b\u52a8\u660e\u7ec6\u9009\u62e9\u7684\u7ec4\u7ec7:" + o.getOrgCode() + "\u4e0d\u5b58\u5728"));
        AssertUtils.isNotEmpty(this.feeBudgetEntities, (String)"\u5f53\u524d\u6d3b\u52a8\u5bf9\u5e94\u7684\u8d39\u7528\u9884\u7b97\u4e0d\u5b58\u5728");
        for (TpmFeeBudgetEntity r : this.feeBudgetEntities) {
            MdmCustomerMsgSelectRespVo customerMsgRespVo;
            MdmOrgRespVo engineOrgRespVo = this.orgMap.get(r.getOrgCode());
            AssertUtils.isNotNull((Object)engineOrgRespVo, (String)("\u8d39\u7528\u9884\u7b97:" + r.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u7ec4\u7ec7\u4e0d\u5b58\u5728"));
            ArrayList entities = this.actDetailBudgetMap.get(o.getActDetailCode());
            if (CollectionUtils.isEmpty(entities)) {
                entities = Lists.newArrayList();
            }
            if (StringUtils.equals((CharSequence)fineEntity.getActivityReleaseNeed(), (CharSequence)ActivityReleaseNeedEnum.DEPARTMENT.getCode())) {
                AssertUtils.isNotEmpty((String)o.getOrgCode(), (String)("\u6d3b\u52a8\u7ec6\u7c7b:" + fineEntity.getFineCode() + "\u5fc5\u987b\u9009\u62e9\u7ec4\u7ec7"));
                if (!StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)r.getFeeBudgetType()) || StringUtils.equals((CharSequence)r.getOrgCode(), (CharSequence)o.getOrgCode()) || StringUtils.startsWith((CharSequence)detailOrgVo.getRuleCode(), (CharSequence)engineOrgRespVo.getRuleCode())) {
                    // empty if block
                }
            }
            if (StringUtils.equals((CharSequence)fineEntity.getActivityReleaseNeed(), (CharSequence)ActivityReleaseNeedEnum.CUSTOMER.getCode())) {
                AssertUtils.isTrue((StringUtils.isNotEmpty((CharSequence)o.getOrgCode()) && StringUtils.isNotEmpty((CharSequence)o.getCustomerCode()) ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u7ec6\u7c7b:" + fineEntity.getFineCode() + "\u5fc5\u987b\u9009\u62e9\u7ec4\u7ec7\u548c\u5ba2\u6237\u4fe1\u606f"));
                customerMsgRespVo = this.customerMap.get(o.getCustomerCode());
                o.setChannel(customerMsgRespVo.getChannel());
                if (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)r.getFeeBudgetType()) ? !StringUtils.equals((CharSequence)r.getOrgCode(), (CharSequence)o.getOrgCode()) && StringUtils.startsWith((CharSequence)detailOrgVo.getRuleCode(), (CharSequence)engineOrgRespVo.getRuleCode()) : (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CHANNEL.getCode(), (CharSequence)r.getFeeBudgetType()) ? StringUtils.equals((CharSequence)r.getChannel(), (CharSequence)o.getChannel()) && !StringUtils.equals((CharSequence)r.getOrgCode(), (CharSequence)o.getOrgCode()) && StringUtils.startsWith((CharSequence)detailOrgVo.getRuleCode(), (CharSequence)engineOrgRespVo.getRuleCode()) : !StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CUSTOMER.getCode(), (CharSequence)r.getFeeBudgetType()) || StringUtils.equals((CharSequence)o.getCustomerCode(), (CharSequence)r.getCustomerCode()))) {
                    // empty if block
                }
            }
            if (StringUtils.equals((CharSequence)fineEntity.getActivityReleaseNeed(), (CharSequence)ActivityReleaseNeedEnum.TERMINAL.getCode())) {
                AssertUtils.isTrue((StringUtils.isNotEmpty((CharSequence)o.getOrgCode()) && StringUtils.isNotEmpty((CharSequence)o.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)o.getTerminalCode()) ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u7ec6\u7c7b:" + fineEntity.getFineCode() + "\u5fc5\u987b\u9009\u62e9\u7ec4\u7ec7,\u5ba2\u6237,\u7ec8\u7aef\u4fe1\u606f"));
                customerMsgRespVo = this.customerMap.get(o.getCustomerCode());
                o.setChannel(customerMsgRespVo.getChannel());
                if (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)r.getFeeBudgetType()) ? !StringUtils.equals((CharSequence)r.getOrgCode(), (CharSequence)o.getOrgCode()) && StringUtils.startsWith((CharSequence)detailOrgVo.getRuleCode(), (CharSequence)engineOrgRespVo.getRuleCode()) : (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CHANNEL.getCode(), (CharSequence)r.getFeeBudgetType()) ? StringUtils.equals((CharSequence)r.getChannel(), (CharSequence)o.getChannel()) && !StringUtils.equals((CharSequence)r.getOrgCode(), (CharSequence)o.getOrgCode()) && StringUtils.startsWith((CharSequence)detailOrgVo.getRuleCode(), (CharSequence)engineOrgRespVo.getRuleCode()) : (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CUSTOMER.getCode(), (CharSequence)r.getFeeBudgetType()) ? StringUtils.equals((CharSequence)o.getCustomerCode(), (CharSequence)r.getCustomerCode()) : !StringUtils.equals((CharSequence)FeeBudgetTypeEnum.TERMINAL.getCode(), (CharSequence)r.getFeeBudgetType()) || !StringUtils.equals((CharSequence)o.getCustomerCode(), (CharSequence)r.getCustomerCode()) || StringUtils.equals((CharSequence)o.getTerminalCode(), (CharSequence)r.getTerminalCode())))) {
                    // empty if block
                }
            }
            entities.add(r);
            this.actDetailBudgetMap.put(o.getActDetailCode(), entities);
        }
    }

    public void checkShareData() {
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFeeShareVos())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u5206\u644a\u8d39\u7528\u5230\u4ea7\u54c1");
        }
    }

    public void checkFeeShareRatioAndAmount(Map<String, Map<String, TmpActFeeShareReqVo>> categoriesFeeShareMap) {
        categoriesFeeShareMap.entrySet().forEach(o -> {
            Map value = (Map)o.getValue();
            BigDecimal totalRatio = value.values().stream().map(TmpActFeeShareReqVo::getShareRatio).reduce(BigDecimal::add).get();
            AssertUtils.isTrue((totalRatio.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u5927\u7c7b:" + (String)o.getKey() + "\u7684\u4ea7\u54c1\u5206\u644a\u6bd4\u4f8b\u603b\u548c\u5fc5\u987b\u7b49\u4e8e100"));
        });
    }

    @Override
    public PracticalityChargeActBuilder convert() {
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)this.actEntity));
        this.actEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        this.actEntity.setAuditTotalAmount(BigDecimal.ZERO);
        this.actEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
        this.reqVo.getBudgetVos().stream().forEach(o -> {
            TpmActBudgetEntity actBudgetEntity = new TpmActBudgetEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actBudgetEntity));
            o.setActCode(this.actEntity.getActCode());
            this.actBudgetEntities.add(actBudgetEntity);
        });
        this.reqVo.getDetailVos().forEach(o -> {
            TpmActDetailEntity actDetailEntity = new TpmActDetailEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actDetailEntity));
            actDetailEntity.setActCode(this.actEntity.getActCode());
            this.actDetailEntities.add(actDetailEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFeeShareVos())) {
            this.reqVo.getFeeShareVos().forEach(o -> {
                TmpActFeeShareEntity actFeeShareEntity = new TmpActFeeShareEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actFeeShareEntity));
                actFeeShareEntity.setActCode(this.actEntity.getActCode());
                this.shareEntities.add(actFeeShareEntity);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFileList())) {
            this.reqVo.getFileList().forEach(o -> {
                TpmActFileEntity fileEntity = new TpmActFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setActCode(this.actEntity.getActCode());
                this.fileEntities.add(fileEntity);
            });
        }
        return this;
    }

    public void convertFeeBudgetDetailsEntities() {
        String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
        String currentYear = String.valueOf(DateUtil.getCurrentYear());
        this.actDetailEntities.stream().forEach(o -> {
            TpmFeeBudgetDetailsEntity entity = new TpmFeeBudgetDetailsEntity();
            entity.setMonth(currentMonth);
            entity.setYear(currentYear);
            entity.setBusinessCode(this.actEntity.getActCode());
            entity.setBusinessLineCode(o.getActDetailCode());
            this.feeBudgetDetailsEntities.add(entity);
        });
    }

    @Override
    public TpmActEntity save() {
        this.helper.saveOrUpdateAct(this.actEntity, this.reqVo);
        this.helper.saveActBudgets(this.actBudgetEntities, this.reqVo);
        this.helper.saveActDetails(this.actDetailEntities, this.reqVo);
        this.helper.saveActShares(this.shareEntities, this.reqVo);
        this.helper.saveActFiles(this.fileEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailsEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveFeeBudgetControls(this.controlEntities, this.reqVo);
        return this.actEntity;
    }

    @Override
    public TpmActEntity update() {
        this.helper.saveOrUpdateAct(this.actEntity, this.reqVo);
        this.helper.saveActBudgets(this.actBudgetEntities, this.reqVo);
        this.helper.saveActDetails(this.actDetailEntities, this.reqVo);
        this.helper.saveActShares(this.shareEntities, this.reqVo);
        this.helper.saveActFiles(this.fileEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailsEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveFeeBudgetControls(this.controlEntities, this.reqVo);
        return this.actEntity;
    }
}

