/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.fiscalyear.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FiscalYearSettingException;
import com.biz.crm.fiscalyear.mapper.TpmFiscalYearSettingMapper;
import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.biz.crm.fiscalyear.service.ITpmFiscalYearSettingService;
import com.biz.crm.fiscalyear.service.impl.FiscalYearSettingServiceHelper;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFiscalYearSettingServiceExpandImpl"})
public class TpmFiscalYearSettingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmFiscalYearSettingMapper, TpmFiscalYearSettingEntity>
implements ITpmFiscalYearSettingService {
    private static final Logger log = LoggerFactory.getLogger(TpmFiscalYearSettingServiceImpl.class);
    @Resource
    private TpmFiscalYearSettingMapper tpmFiscalYearSettingMapper;
    @Autowired
    private FiscalYearSettingServiceHelper serviceHelper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @CrmLog
    public PageResult<TpmFiscalYearSettingRespVo> findList(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmFiscalYearSettingReqVo.getPageNum(), (Integer)tpmFiscalYearSettingReqVo.getPageSize());
        List<TpmFiscalYearSettingRespVo> list = this.tpmFiscalYearSettingMapper.findList((Page<TpmFiscalYearSettingRespVo>)page, tpmFiscalYearSettingReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmFiscalYearSettingRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo = new TpmFiscalYearSettingReqVo();
        tpmFiscalYearSettingReqVo.setId(id);
        List list = this.findList(tpmFiscalYearSettingReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmFiscalYearSettingRespVo();
        }
        return (TpmFiscalYearSettingRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        this.serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        TpmFiscalYearSettingEntity entity = (TpmFiscalYearSettingEntity)((Object)CrmBeanUtil.copy((Object)tpmFiscalYearSettingReqVo, TpmFiscalYearSettingEntity.class));
        this.save((Object)entity);
        TpmFiscalYearSettingRespVo newData = (TpmFiscalYearSettingRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getBeginDateSecond(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        if (StringUtils.isEmpty((CharSequence)tpmFiscalYearSettingReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmFiscalYearSettingEntity entity = (TpmFiscalYearSettingEntity)((Object)this.getById((Serializable)((Object)tpmFiscalYearSettingReqVo.getId())));
        TpmFiscalYearSettingRespVo oldData = (TpmFiscalYearSettingRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFiscalYearSettingRespVo.class);
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)FiscalYearSettingException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        CrmBeanUtil.copyProperties((Object)tpmFiscalYearSettingReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmFiscalYearSettingRespVo newData = (TpmFiscalYearSettingRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFiscalYearSettingRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getBeginDateSecond(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        PageResult<TpmFiscalYearSettingRespVo> oldDataList = this.findList(new TpmFiscalYearSettingReqVo().setIds(ids));
        this.tpmFiscalYearSettingMapper.deleteBatchIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (TpmFiscalYearSettingRespVo oldData : oldDataList.getData()) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), oldData.getId(), oldData.getBeginDateSecond(), (Object)oldData);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List mdmProductEntities = this.tpmFiscalYearSettingMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
        List newDataList = CrmBeanUtil.copyList((List)mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmFiscalYearSettingRespVo)newDataList.get(i)).getId(), ((TpmFiscalYearSettingRespVo)newDataList.get(i)).getBeginDateSecond(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List mdmProductEntities = this.tpmFiscalYearSettingMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
        List newDataList = CrmBeanUtil.copyList((List)mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmFiscalYearSettingRespVo)newDataList.get(i)).getId(), ((TpmFiscalYearSettingRespVo)newDataList.get(i)).getBeginDateSecond(), oldDataList.get(i), newDataList.get(i));
        }
    }
}

