/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditServiceHelper.class);
    @Resource
    private TpmAuditMapper auditMapper;
    @Resource
    private TpmActMapper tpmActMapper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private ActServiceHelper helper;

    public void convertListDate(List<TpmAuditRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName((String)o.getApproveStatus()));
                }
            });
        }
    }

    public void deleteCheck(List<TpmAuditEntity> tpmAuditEntities, List<String> ids) {
        tpmAuditEntities.forEach(tpmAuditEntity -> AssertUtils.isTrue((ActApproveStatusEnum.CREATE.getCode().equals(tpmAuditEntity.getApproveStatus()) || ActApproveStatusEnum.REJECTED.getCode().equals(tpmAuditEntity.getApproveStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(tpmAuditEntity.getApproveStatus()) ? 1 : 0) != 0, (String)"\u5df2\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u5220\u9664"));
    }

    public void saveCheck(TpmAuditReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.auditMapper.selectById((Serializable)((Object)reqVo.getId())));
            AssertUtils.isNotNull((Object)((Object)tpmAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            if (!ActApproveStatusEnum.getCanUpdateStatus().contains(tpmAuditEntity.getApproveStatus())) {
                throw new BusinessException("\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
            }
            reqVo.setAuditCode(tpmAuditEntity.getAuditCode());
        } else {
            reqVo.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getAuditName(), (String)"\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSaveType(), (String)"\u4fdd\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (ActSaveTypeEnum.getSendApproveTypes().contains(reqVo.getSaveType())) {
            this.approvingCheck(reqVo);
            reqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)reqVo.getApproveStatus())) {
            reqVo.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        this.saveActCheckDetails(reqVo);
        this.saveCheckDetails(reqVo);
        this.saveCheckAuditFiles(reqVo);
        this.checkDataExist(reqVo);
        this.checkProductInfo(reqVo);
    }

    private void saveCheckAuditFiles(TpmAuditReqVo reqVo) {
        List auditFileRespVos = reqVo.getAuditFileRespVos();
        Set fineCodes = reqVo.getDetailVos().stream().map(TpmAuditDetailReqVo::getFineCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty((Collection)auditFileRespVos)) {
            auditFileRespVos.forEach(o -> {
                AssertUtils.isNotNull((Object)o.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                o.setAuditCode(reqVo.getAuditCode());
                if (Objects.equals(1, o.getAuditFileType())) {
                    AssertUtils.isNotEmpty((String)o.getExampleCode(), (String)"\u6838\u9500\u8d44\u6599\u7684\u6838\u9500\u91c7\u96c6\u793a\u4f8b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6838\u9500\u8d44\u6599\u7684\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    AssertUtils.isTrue((boolean)fineCodes.contains(o.getFineCode()), (String)("\u6838\u9500\u8d44\u6599\u5bf9\u5e94\u7684\u7ec6\u7c7b\u7f16\u7801" + o.getFineCode() + ",\u4e0d\u5728\u6838\u9500\u660e\u7ec6\u4e2d"));
                }
                AssertUtils.isNotEmpty((String)o.getAddressUrl(), (String)"\u6838\u9500\u8d44\u6599\u7684\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
    }

    private void saveActCheckDetails(TpmAuditReqVo reqVo) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        AssertUtils.isNotEmpty((Collection)tpmAuditActReqVos, (String)"\u6838\u9500\u7533\u8bf7\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Set actCodes = tpmAuditActReqVos.stream().map(TpmAuditActReqVo::getActCode).collect(Collectors.toSet());
        AssertUtils.isTrue((tpmAuditActReqVos.size() == CollectionUtils.size(actCodes) ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u91cd\u590d\u7684\u6d3b\u52a8");
        List tpmActEntities = this.tpmActMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmActEntity::getActCode, actCodes));
        Map map = tpmActEntities.stream().collect(Collectors.toMap(TpmActEntity::getActCode, Function.identity()));
        AssertUtils.isTrue((CollectionUtils.size((Object)tpmActEntities) == tpmAuditActReqVos.size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6570\u636e\u5f02\u5e38");
        tpmAuditActReqVos.forEach(tpmAuditActReqVo -> {
            TpmActEntity entity = (TpmActEntity)((Object)((Object)map.get(tpmAuditActReqVo.getActCode())));
            AssertUtils.isNotNull((Object)((Object)entity), (String)("\u6d3b\u52a8\u7f16\u7801:" + tpmAuditActReqVo.getActCode() + "\u6570\u636e\u4e0d\u5b58\u5728"));
            AssertUtils.isNotEmpty((String)tpmAuditActReqVo.getActName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)entity.getApproveStatus()), (String)("\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6d3b\u52a8:" + entity.getActCode() + "\u4e0d\u80fd\u6838\u9500"));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)entity.getIsAllAudit()), (String)"\u5b8c\u6210\u6838\u9500\u7684\u6d3b\u52a8\u4e0d\u80fd\u518d\u6b21\u6838\u9500");
            tpmAuditActReqVo.setAuditCode(reqVo.getAuditCode());
        });
    }

    private void saveCheckDetails(TpmAuditReqVo reqVo) {
        List detailVos = reqVo.getDetailVos();
        Set actCodes = reqVo.getTpmAuditActReqVos().stream().map(TpmAuditActReqVo::getActCode).collect(Collectors.toSet());
        AssertUtils.isNotEmpty((Collection)detailVos, (String)"\u6838\u9500\u7533\u8bf7\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet actDetailCodes = Sets.newHashSet();
        HashSet fineCodes = Sets.newHashSet();
        Map payTypeTypeMap = this.helper.getPayTypeTypeMap("pay_type_d", "pay_type_type");
        detailVos.stream().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)actCodes.contains(o.getActCode()), (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + o.getActDetailCode() + "\u4e0d\u5728\u9009\u5b9a\u7684\u6838\u9500\u6d3b\u52a8\u8303\u56f4\u5185"));
            actDetailCodes.add(o.getActDetailCode());
            fineCodes.add(o.getFineCode());
            if (StringUtils.isNotEmpty((CharSequence)o.getPayType())) {
                o.setPayTypeType((String)payTypeTypeMap.get(o.getPayType()));
            }
        });
        AssertUtils.isTrue((detailVos.size() == CollectionUtils.size((Object)actDetailCodes) ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u91cd\u590d\u7684\u6d3b\u52a8\u660e\u7ec6");
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, (Collection)fineCodes));
        AssertUtils.isNotEmpty((Collection)fineEntities, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u6570\u636e\u5f02\u5e38");
        Map fineEntityMap = fineEntities.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
        TpmActDetailReqVo tpmActDetailReqVo = new TpmActDetailReqVo();
        tpmActDetailReqVo.setActCodes((List)Lists.newArrayList(actCodes));
        List<TpmActDetailRespVo> actDetailList = this.tpmActDetailMapper.findActDetailList((Page<TpmActDetailRespVo>)PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)-1), tpmActDetailReqVo);
        AssertUtils.isNotEmpty(actDetailList, (String)"\u60a8\u9009\u62e9\u7684\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e");
        Map actDetailMap = actDetailList.stream().collect(Collectors.toMap(TpmActDetailRespVo::getActDetailCode, Function.identity()));
        ArrayList occupyFeeBudgetDetails = Lists.newArrayList();
        Map payTypesMap = super.getPayTypesMap();
        for (int i = 0; i < detailVos.size(); ++i) {
            TpmAuditDetailReqVo detailReqVo = (TpmAuditDetailReqVo)detailVos.get(i);
            AssertUtils.isNotEmpty((String)detailReqVo.getPayType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)detailReqVo.getPayTypeName(), (String)"\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)detailReqVo.getAuditApplyAmount(), (String)"\u672c\u6b21\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            TpmActDetailRespVo tpmActDetail = (TpmActDetailRespVo)actDetailMap.get(detailReqVo.getActDetailCode());
            AssertUtils.isNotNull((Object)tpmActDetail, (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + detailReqVo.getActDetailCode() + "\u4e0d\u5b58\u5728,\u6216\u8005\u4e0d\u80fd\u8fdb\u884c\u6838\u9500\u64cd\u4f5c"));
            detailReqVo.setAuditCode(reqVo.getAuditCode());
            if (Objects.isNull(detailReqVo.getFeeUsed())) {
                detailReqVo.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)detailReqVo.getIsAllFeeUsed())) {
                detailReqVo.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)detailReqVo.getAuditDetailCode())) {
                detailReqVo.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            }
            detailReqVo.setPayTypeName((String)payTypesMap.get(detailReqVo.getPayType()));
            detailReqVo.setAlreadyAuditAmount(Optional.ofNullable(tpmActDetail.getAuditAmount()).orElse(BigDecimal.ZERO));
            detailReqVo.setActDetailApplyAmount(tpmActDetail.getApplyAmount());
            TpmCostTypeFineEntity typeFineEntity = (TpmCostTypeFineEntity)((Object)fineEntityMap.get(detailReqVo.getFineCode()));
            AssertUtils.isNotNull((Object)((Object)typeFineEntity), (String)("\u6d3b\u52a8\u7ec6\u7c7b:" + detailReqVo.getFineCode() + "\u4e0d\u5b58\u5728"));
            BigDecimal extraAuditRatio = typeFineEntity.getExtraAuditRatio();
            BigDecimal addAmount = detailReqVo.getAuditApplyAmount().add(detailReqVo.getAlreadyAuditAmount());
            BigDecimal maxAuditAmount = Optional.ofNullable(extraAuditRatio).orElse(BigDecimal.ZERO).multiply(tpmActDetail.getApplyAmount()).divide(BigDecimal.valueOf(100L)).add(tpmActDetail.getApplyAmount());
            AssertUtils.isTrue((addAmount.compareTo(maxAuditAmount) < 1 ? 1 : 0) != 0, (String)("\u7b2c" + (i + 1) + "\u884c\u8d85\u8fc7\u5141\u8bb8\u6700\u5927\u6838\u9500\u91d1\u989d:" + maxAuditAmount.subtract(detailReqVo.getAlreadyAuditAmount())));
            if (StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)typeFineEntity.getIsAllowRepeatAudit())) {
                detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            }
            if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)typeFineEntity.getIsAllowRepeatAudit())) {
                if (Objects.isNull(typeFineEntity.getExtraAuditRatio()) && addAmount.compareTo(tpmActDetail.getApplyAmount()) == 0) {
                    detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
                }
                if (Objects.nonNull(typeFineEntity.getExtraAuditRatio()) && addAmount.compareTo(maxAuditAmount) == 0) {
                    detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
                }
            }
            if (addAmount.compareTo(tpmActDetail.getApplyAmount()) == 1) {
                reqVo.setOccupyFeeBudgetFlag(Boolean.valueOf(true));
                occupyFeeBudgetDetails.add(detailReqVo);
            }
            if (!CollectionUtils.isNotEmpty((Collection)detailReqVo.getAuditFileRespVos())) continue;
            detailReqVo.getAuditFileRespVos().forEach(o -> {
                o.setAuditDetailCode(detailReqVo.getAuditDetailCode());
                Optional.ofNullable(reqVo.getAuditFileRespVos()).orElse(Lists.newArrayList()).add(o);
            });
        }
        reqVo.setOccupyFeeBudgetDetails((List)occupyFeeBudgetDetails);
    }

    private void checkDataExist(TpmAuditReqVo reqVo) {
        Integer count;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditEntity::getAuditCode, (Object)reqVo.getAuditCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        AssertUtils.isTrue(((count = this.auditMapper.selectCount((Wrapper)wrapper)) == 0 ? 1 : 0) != 0, (CrmExceptionType)AuditException.DATA_CODE_DUPLICATE, (String[])new String[0]);
    }

    public void sendToActivity(TpmAuditReqVo reqVo) {
    }

    public TpmAuditEntity rejectAndInterruptCheck(TpmAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditEntity entity = (TpmAuditEntity)((Object)this.auditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.REJECTED.getCode(), (CharSequence)reqVo.getApproveStatus())) {
            entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        }
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.INTERRUPT.getCode(), (CharSequence)reqVo.getApproveStatus())) {
            entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        }
        return entity;
    }

    public StartProcessReqVo buildStartProcessData(TpmAuditEntity entity, TpmAuditReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmAuditCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getAuditCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileReqVos()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getAddressUrl());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void approveCheck(TpmAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditEntity entity = (TpmAuditEntity)((Object)this.auditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)tpmAuditReqVo.getId())));
        Set canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(entity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        tpmAuditReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
    }

    public void approvingCheck(TpmAuditReqVo reqVo) {
        List detailVos = reqVo.getDetailVos();
        List<String> actDetailCodes = detailVos.stream().map(TpmAuditDetailReqVo::getActDetailCode).collect(Collectors.toList());
        List<String> actDetailCodeList = this.auditMapper.findApprovingByActDetailCode(actDetailCodes);
        if (CollectionUtils.isNotEmpty(actDetailCodeList)) {
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\uff1a" + actDetailCodeList.toString() + ",\u5bf9\u5e94\u7684\u6838\u9500\u6b63\u5728\u5ba1\u6838\u4e2d,\u5f53\u524d\u6838\u9500\u7533\u8bf7\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
    }

    private void checkProductInfo(TpmAuditReqVo reqVo) {
        ArrayList needSaveProductList = Lists.newArrayList();
        reqVo.getDetailVos().forEach(detail -> {
            List productInfoReqVos = detail.getReplenishmentProductList();
            if (CollectionUtils.isNotEmpty((Collection)productInfoReqVos)) {
                HashSet collect = Sets.newHashSet();
                productInfoReqVos.forEach(o -> {
                    AssertUtils.isNotEmpty((String)o.getProductCode(), (String)("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + detail.getAuditDetailCode() + "\u8d27\u8865\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    AssertUtils.isNotEmpty((String)o.getProductName(), (String)("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + detail.getAuditDetailCode() + "\u8d27\u8865\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                    o.setAuditCode(reqVo.getAuditCode());
                    o.setAuditDetailCode(detail.getAuditDetailCode());
                    AssertUtils.isTrue((!collect.contains(o.getProductCode()) ? 1 : 0) != 0, (String)("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + detail.getAuditDetailCode() + "\u8d27\u8865\u4ea7\u54c1\u91cd\u590d"));
                    collect.add(o.getProductCode());
                });
                needSaveProductList.addAll(productInfoReqVos);
            }
        });
        reqVo.setAuditDetailReplenishmentProductVos((List)needSaveProductList);
    }
}

