/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.auditcollectexample.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExamplePictureService;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExampleService;
import com.biz.crm.auditcollectexample.service.impl.AuditCollectExampleServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AuditCollectExampleException;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAuditCollectExampleServiceExpandImpl"})
public class TpmAuditCollectExampleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmAuditCollectExampleMapper, TpmAuditCollectExampleEntity>
implements ITpmAuditCollectExampleService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditCollectExampleServiceImpl.class);
    @Resource
    private TpmAuditCollectExampleMapper tpmAuditCollectExampleMapper;
    @Autowired
    private AuditCollectExampleServiceHelper serviceHelper;
    @Resource
    private TpmAuditCollectExamplePictureMapper pictureMapper;
    @Autowired
    private ITpmAuditCollectExamplePictureService pictureService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private ActServiceHelper actServiceHelper;

    @Override
    @CrmLog
    public PageResult<TpmAuditCollectExampleRespVo> findList(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmAuditCollectExampleReqVo.getPageNum(), (Integer)tpmAuditCollectExampleReqVo.getPageSize());
        tpmAuditCollectExampleReqVo.setSelectedCodeList(this.actServiceHelper.dealSelectedCodeList(tpmAuditCollectExampleReqVo.getSelectedCode(), tpmAuditCollectExampleReqVo.getSelectedCodeList()));
        List<TpmAuditCollectExampleRespVo> list = this.tpmAuditCollectExampleMapper.findList((Page<TpmAuditCollectExampleRespVo>)page, tpmAuditCollectExampleReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmAuditCollectExampleRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo = new TpmAuditCollectExampleReqVo();
        tpmAuditCollectExampleReqVo.setId(id);
        List list = this.findList(tpmAuditCollectExampleReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmAuditCollectExampleRespVo();
        }
        TpmAuditCollectExampleRespVo respVo = (TpmAuditCollectExampleRespVo)list.get(0);
        TpmAuditCollectExamplePictureReqVo pictureReqVo = new TpmAuditCollectExamplePictureReqVo();
        pictureReqVo.setExampleCode(respVo.getExampleCode());
        pictureReqVo.setPageSize(Integer.valueOf(-1));
        List pictureRespVos = this.pictureService.findList(pictureReqVo).getData();
        respVo.setPictureRespVos(pictureRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        this.serviceHelper.saveCheck(tpmAuditCollectExampleReqVo);
        TpmAuditCollectExampleEntity entity = (TpmAuditCollectExampleEntity)((Object)CrmBeanUtil.copy((Object)tpmAuditCollectExampleReqVo, TpmAuditCollectExampleEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmAuditCollectExampleRespVo newData = (TpmAuditCollectExampleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmAuditCollectExampleRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getExampleCode(), (Object)newData);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditCollectExampleReqVo.getPictureRespVos())) {
            List pictureEntities = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().map(o -> {
                TpmAuditCollectExamplePictureEntity pictureEntity = new TpmAuditCollectExamplePictureEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)pictureEntity));
                pictureEntity.setExampleCode(entity.getExampleCode());
                return pictureEntity;
            }).collect(Collectors.toList());
            this.pictureService.saveBatch(pictureEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        if (StringUtils.isEmpty((CharSequence)tpmAuditCollectExampleReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmAuditCollectExampleEntity entity = (TpmAuditCollectExampleEntity)((Object)this.getById((Serializable)((Object)tpmAuditCollectExampleReqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)AuditCollectExampleException.DATA_NOT_EXIST);
        }
        TpmAuditCollectExampleRespVo oldData = (TpmAuditCollectExampleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmAuditCollectExampleRespVo.class);
        this.serviceHelper.saveCheck(tpmAuditCollectExampleReqVo);
        CrmBeanUtil.copyProperties((Object)tpmAuditCollectExampleReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmAuditCollectExampleRespVo newData = (TpmAuditCollectExampleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmAuditCollectExampleRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getExampleCode(), (Object)oldData, (Object)newData);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditCollectExampleReqVo.getPictureRespVos())) {
            List pictureIds = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            LambdaQueryWrapper pictureWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditCollectExamplePictureEntity::getExampleCode, (Object)entity.getExampleCode())).notIn(CollectionUtils.isNotEmpty(pictureIds), BaseIdEntity::getId, pictureIds);
            this.pictureMapper.delete((Wrapper)pictureWrapper);
            List pictureEntities = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().map(o -> {
                TpmAuditCollectExamplePictureEntity pictureEntity = new TpmAuditCollectExamplePictureEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)pictureEntity));
                pictureEntity.setExampleCode(entity.getExampleCode());
                return pictureEntity;
            }).collect(Collectors.toList());
            this.pictureService.saveOrUpdateBatch(pictureEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        PageResult<TpmAuditCollectExampleRespVo> oldDataList = this.findList(new TpmAuditCollectExampleReqVo().setIds(ids));
        List list = oldDataList.getData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.tpmAuditCollectExampleMapper.deleteBatchIds(ids);
            List codes = list.stream().map(TpmAuditCollectExampleRespVo::getExampleCode).collect(Collectors.toList());
            this.pictureMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAuditCollectExamplePictureEntity.class).in(TpmAuditCollectExamplePictureEntity::getExampleCode, codes));
            Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
            oldDataList.getData().stream().forEach(o -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), o.getId(), o.getExampleCode(), o));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmAuditCollectExampleMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmAuditCollectExampleRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(entities);
        Object menCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmAuditCollectExampleRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menCodeObj.toString(), ((TpmAuditCollectExampleRespVo)newDataList.get(i)).getId(), ((TpmAuditCollectExampleRespVo)newDataList.get(i)).getExampleCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmAuditCollectExampleMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmAuditCollectExampleRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(entities);
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmAuditCollectExampleRespVo.class);
        Object menCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menCodeObj.toString(), ((TpmAuditCollectExampleRespVo)newDataList.get(i)).getId(), ((TpmAuditCollectExampleRespVo)newDataList.get(i)).getExampleCode(), oldDataList.get(i), newDataList.get(i));
        }
    }
}

