package com.biz.crm.account.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.account.service.ITpmAccountProductService;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 费用上账货补产品表 
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@RestController
@RequestMapping("/tpmAccountProductController")
@Api(tags = "费用上账货补产品表 ")
public class TpmAccountProductController {
    @Autowired
    private ITpmAccountProductService tpmAccountProductService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAccountProductRespVo>> list(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo) {
        PageResult<TpmAccountProductRespVo> result=tpmAccountProductService.findList(tpmAccountProductReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmAccountProductRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmAccountProductRespVo respVo=tpmAccountProductService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo) {
        tpmAccountProductService.save(tpmAccountProductReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo) {
        tpmAccountProductService.update(tpmAccountProductReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAccountProductService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAccountProductService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAccountProductService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
