package com.biz.crm.account.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用上账表;实体类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_account_detail")
@CrmTable(name = "tpm_account_detail",tableNote = "TPM-费用上账表")
public class TpmAccountDetailEntity extends CrmExtEntity<TpmAccountDetailEntity> {

    /**
     * 分组id(标识同一次提交的数据)
     */
    @CrmColumn(name = "group_id", length = 60,note = "分组id(标识同一次提交的数据)")
    private String groupId;

    /**
     * 状态
     */
    @CrmColumn(name = "approve_status", length = 32,note = "状态")
    private String approveStatus;

    /**
     * 费用上账类型(字典:货补,现金)
     */
    @CrmColumn(name = "account_type", length = 32,note = "费用上账类型(字典:货补,现金)")
    private String accountType;

    /**
     * 上账编码
     */
    @CrmColumn(name = "account_code", length = 32,note = "上账编码")
    private String accountCode;

    /**
     * 核销编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销编码")
    private String auditCode;

    /**
     * 核销明细编码
     */
    @CrmColumn(name = "audit_detail_code", length = 32,note = "核销明细编码")
    private String auditDetailCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 100,note = "活动名称")
    private String actName;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 核销明细附加信息编码
     */
    @CrmColumn(name = "audit_detail_attach_code", length = 32,note = "核销明细附加信息编码")
    private String auditDetailAttachCode;

    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 核销金额
     */
    @CrmColumn(name = "audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "核销金额")
    private BigDecimal auditAmount;

    /**
     * 货补产品名称(冗余字段,查列表的时候用)
     */
    @CrmColumn(name = "product_names",note = "货补产品名称(冗余字段,查列表的时候用)")
    private String productNames;

    /**
     * 支付方式编码
     */
    @CrmColumn(name = "pay_type", length = 32,note = "支付方式编码")
    private String payType;

    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 32,note = "支付方式名称")
    private String payTypeName;

    /**
     * 支付方式类型编码(字典)
     */
    @CrmColumn(name = "pay_type_type", length = 32,note = "支付方式类型编码(字典)")
    private String payTypeType;

    /**
     * 上账金额
     */
    @CrmColumn(name = "account_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "上账金额")
    private BigDecimal accountAmount;

    /**
     * 本次可上账金额
     */
    @CrmColumn(name = "current_allow_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "本次可上账金额")
    private BigDecimal currentAllowAmount;

    /**
     * 财务凭证编码
     */
    @CrmColumn(name = "credentials_code", length = 32,note = "财务凭证编码")
    private String credentialsCode;

    /**
     * 核销科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 60,note = "预算科目编码")
    private String budgetSubjectsCode;

    /**
     * 核销科目名称
     */
    @CrmColumn(name = "budget_subjects_name", length = 60,note = "预算科目名称")
    private String budgetSubjectsName;

    /**
     * ERP会计科目编码
     */
    @CrmColumn(name = "finance_subjects_erp_code", length = 60,note = "ERP会计科目编码")
    private String financeSubjectsErpCode;

    /**
     * ERP会计科目名称
     */
    @CrmColumn(name = "finance_subjects_erp_name", length = 60,note = "ERP会计科目名称")
    private String financeSubjectsErpName;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "企业组织名称")
    private String orgName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 活动大类名称
     */
    @CrmColumn(name = "categories_name", length = 60,note = "活动大类名称")
    private String categoriesName;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "产品层级编码")
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 60,note = "产品层级名称")
    private String productLevelName;

    /**
     * 附加信息行编号
     */
    @CrmColumn(name = "attach_code", length = 32,note = "附加信息行编号")
    private String attachCode;

    /**
     * 所属销售公司(字典编码)
     */
    @CrmColumn(name = "owned_sales_company", length = 32,note = "所属销售公司(字典编码)")
    private String ownedSalesCompany;

    /**
     * 所属销售公司(字典名称)
     */
    @CrmColumn(name = "owned_sales_company_name", length = 60,note = "所属销售公司(字典名称)")
    private String ownedSalesCompanyName;

    /**
     * 申请金额
     */
    @CrmColumn(name = "apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal applyAmount;

    /**
     * 提交时间
     */
    @CrmColumn(name = "submit_time", length = 20, note = "提交时间")
    private String submitTime;
}
