package com.biz.crm.account.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 费用上账附件表 实体类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Getter
@Setter
@TableName("tpm_account_file")
@CrmTable(name = "tpm_account_file",tableNote = "费用上账附件表")
public class TpmAccountFileEntity extends CrmExtEntity<TpmAccountFileEntity> {

    /**
     * 上账编码
     */
    @CrmColumn(name = "account_code", length = 60,note = "上账编码")
    private String accountCode;

    /**
     * 分组id(标识同一次提交的数据)
     */
    @CrmColumn(name = "group_id", length = 60,note = "分组id(标识同一次提交的数据)")
    private String groupId;

    /**
     * 文件地址
     */
    @CrmColumn(name = "address_url", length = 200,note = "文件地址")
    private String addressUrl;

    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 100,note = "对象名称")
    private String objectName;
}
