package com.biz.crm.account.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用上账发票关联表;实体类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_account_invoice")
@CrmTable(name = "tpm_account_invoice",tableNote = "TPM-费用上账发票关联表")
public class TpmAccountInvoiceEntity extends CrmExtEntity<TpmAccountInvoiceEntity> {

    /**
     * 分组id(标识同一次提交的数据)
     */
    @CrmColumn(name = "group_id", length = 60,note = "分组id(标识同一次提交的数据)")
    private String groupId;

    /**
     * 上账编码集合(数组的json)
     */
    @CrmColumn(name = "account_codes", length = 200,note = "上账编码集合(数组的json)")
    private String accountCodes;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 发票编码
     */
    @CrmColumn(name = "invoice_code", length = 32,note = "发票编码")
    private String invoiceCode;

    /**
     * 申请科目编码
     */
    @CrmColumn(name = "apply_budget_subjects_code", length = 32,note = "申请科目编码")
    private String applyBudgetSubjectsCode;

    /**
     * 申请科目名称
     */
    @CrmColumn(name = "apply_budget_subjects_name", length = 60,note = "申请科目名称")
    private String applyBudgetSubjectsName;

    /**
     * 上账科目编码
     */
    @CrmColumn(name = "account_budget_subjects_code", length = 32,note = "上账科目编码")
    private String accountBudgetSubjectsCode;

    /**
     * 上账科目名称
     */
    @CrmColumn(name = "account_budget_subjects_name", length = 60,note = "上账科目名称")
    private String accountBudgetSubjectsName;

    /**
     * 税码
     */
    @CrmColumn(name = "tax_code", length = 32,note = "税码")
    private String taxCode;

    /**
     * 税金
     */
    @CrmColumn(name = "tax_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "税金")
    private BigDecimal taxAmount;

    /**
     * 发票金额(不含税)
     */
    @CrmColumn(name = "invoice_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "发票金额(不含税)")
    private BigDecimal invoiceAmount;

    /**
     * 进项税转出金额
     */
    @CrmColumn(name = "tax_out_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "进项税转出金额")
    private BigDecimal taxOutAmount;

    /**
     * ERP成本中心(文本框输入)
     */
    @CrmColumn(name = "cost_center", length = 60,note = "ERP成本中心(文本框输入)")
    private String costCenter;

    /**
     * 发票金额(含税)
     */
    @CrmColumn(name = "total_invoice_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "发票金额(含税)")
    private BigDecimal totalInvoiceAmount;

    /**
     * 税率
     */
    @CrmColumn(name = "tax_rate", length = 32,note = "税率")
    private String taxRate;

}
