package com.biz.crm.account.service;

import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;

import java.util.List;
import java.util.Map;

/**
 * 费用上账货补产品表 接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
public interface ITpmAccountProductService extends IService<TpmAccountProductEntity> {

    /**
     * 列表
     * @param tpmAccountProductReqVo
     * @return PageResult<TpmAccountProductRespVo>
     */
    PageResult<TpmAccountProductRespVo> findList(TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 查询
     * @param id
     * @return TpmAccountProductRespVo
     */
    TpmAccountProductRespVo query(String id);

    /**
     * 新增
     * @param tpmAccountProductReqVo
     * @return
     */
    void save(TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 更新
     * @param tpmAccountProductReqVo
     * @return
     */
    void update(TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

