package com.biz.crm.account.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountProductMapper;
import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.account.service.ITpmAccountProductService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 费用上账货补产品表 接口实现
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAccountProductServiceExpandImpl")
public class TpmAccountProductServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAccountProductMapper, TpmAccountProductEntity> implements ITpmAccountProductService {

    @Resource
    private TpmAccountProductMapper tpmAccountProductMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAccountProductRespVo> findList(TpmAccountProductReqVo reqVo){
        Page<TpmAccountProductRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAccountProductRespVo> list = tpmAccountProductMapper.findList(page, reqVo);
        return PageResult.<TpmAccountProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmAccountProductRespVo
     */
    @Override
    public TpmAccountProductRespVo query(String id){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAccountProductReqVo reqVo){
        TpmAccountProductEntity entity = CrmBeanUtil.copy(reqVo,TpmAccountProductEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAccountProductReqVo reqVo){
        TpmAccountProductEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmAccountProductEntity> tpmAccountProductEntities = tpmAccountProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountProductEntities)){
            tpmAccountProductEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAccountProductEntities);
    }

    /**
     * 启用
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAccountProductEntity> tpmAccountProductEntities = tpmAccountProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountProductEntities)){
            tpmAccountProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAccountProductEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAccountProductEntity> tpmAccountProductEntities = tpmAccountProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountProductEntities)){
                tpmAccountProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAccountProductEntities);
    }
}
