package com.biz.crm.act.controller;

import com.biz.crm.act.service.ITmpActFeeShareService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动费用分摊表;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@RestController
@RequestMapping("/tmpActFeeShareController")
@Api(tags = "活动费用分摊表;")
public class TmpActFeeShareController {
    @Autowired
    private ITmpActFeeShareService tmpActFeeShareService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TmpActFeeShareRespVo>> list(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo) {
        PageResult<TmpActFeeShareRespVo> result = tmpActFeeShareService.findList(tmpActFeeShareReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TmpActFeeShareRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TmpActFeeShareRespVo respVo = tmpActFeeShareService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo) {
        tmpActFeeShareService.save(tmpActFeeShareReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo) {
        tmpActFeeShareService.update(tmpActFeeShareReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tmpActFeeShareService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tmpActFeeShareService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tmpActFeeShareService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
