package com.biz.crm.act.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.act.service.ITpmActBudgetService;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动预算信息表;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmActBudgetController")
@Api(tags = "活动预算信息表;")
public class TpmActBudgetController {
    @Autowired
    private ITpmActBudgetService tpmActBudgetService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActBudgetRespVo>> list(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo) {
        PageResult<TpmActBudgetRespVo> result=tpmActBudgetService.findList(tpmActBudgetReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmActBudgetRespVo> query(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo) {
        TpmActBudgetRespVo respVo=tpmActBudgetService.query(tpmActBudgetReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo) {
        tpmActBudgetService.save(tpmActBudgetReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo) {
        tpmActBudgetService.update(tpmActBudgetReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActBudgetService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActBudgetService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActBudgetService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
