package com.biz.crm.act.controller;

import com.biz.crm.nebular.tpm.act.req.TpmActDetailReportReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailReportRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动明细信息表;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmActDetailController")
@Api(tags = "活动明细信息表;")
public class TpmActDetailController {
    @Autowired
    private ITpmActDetailService tpmActDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActDetailRespVo>> list(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        PageResult<TpmActDetailRespVo> result=tpmActDetailService.findList(tpmActDetailReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "活动预付查询活动明细")
    @PostMapping("/pageForAdvancePay")
    @CrmLog
    public Result<PageResult<TpmActDetailRespVo>> pageForAdvancePay(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        PageResult<TpmActDetailRespVo> result=tpmActDetailService.pageForAdvancePay(tpmActDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmActDetailRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmActDetailRespVo respVo=tpmActDetailService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        tpmActDetailService.save(tpmActDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        tpmActDetailService.update(tpmActDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActDetailService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActDetailService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActDetailService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation("活动明细报表")
    @PostMapping("/actDetailReport")
    @CrmLog
    public Result<PageResult<TpmActDetailReportRespVo>> actDetailReport(@RequestBody TpmActDetailReportReqVo tpmActDetailReportReqVo){
        return Result.ok(tpmActDetailService.actDetailReport(tpmActDetailReportReqVo));
    }
}
