package com.biz.crm.act.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动预算信息表;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_budget")
@CrmTable(name = "tpm_act_budget",tableNote = "TPM-活动预算信息表")
public class TpmActBudgetEntity extends CrmExtEntity<TpmActBudgetEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 费用预算控制维度id
     */
    @CrmColumn(name = "control_id", length = 32,note = "费用预算控制维度id")
    private String controlId;

    /**
     * 费用预算类型(字典)
     */
    @CrmColumn(name = "fee_budget_type", length = 32,note = "费用预算类型(字典)")
    private String feeBudgetType;

    /**
     * 组织类型
     */
    @CrmColumn(name = "org_type", length = 32,note = "组织类型")
    private String orgType;

    /**
     * 预算扣减顺序
     */
    @CrmColumn(name = "reduce_order",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "预算扣减顺序")
    private Integer reduceOrder;

    /**
     * 预算扣减比例
     */
    @CrmColumn(name = "reduce_ratio",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "预算扣减比例")
    private BigDecimal reduceRatio;

}
