package com.biz.crm.act.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动明细产品关联表
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("tmp_act_detail_product")
@CrmTable(name = "tmp_act_detail_product",tableNote = "活动明细产品关联表")
public class TpmActDetailProductEntity extends CrmExtTenEntity<TpmActDetailProductEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    @CrmColumn(name = "product_type", length = 32,note = "产品类型:ActDetailProductTypeEnum,gift赠品,normal本品,execution执行产品,replenishment货补产品")
    private String productType;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 60,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100,note = "产品名称")
    private String productName;

    /**
     * 兑付方式(数据字典:payment_method,现金兑付,货品兑付)
     */
    @CrmColumn(name = "payment_method", length = 64,note = "兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    /**
     * 全国统一价
     */
    @CrmColumn(name = "price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "全国统一价")
    private BigDecimal price;


    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 60,note = "临时字段唯一值")
    private String tempUuid;

}
