package com.biz.crm.act.service;

import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReportReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailReportRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 活动明细信息表;接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface ITpmActDetailService extends IService<TpmActDetailEntity> {

    /**
     * 列表
     * @param tpmActDetailReqVo
     * @return PageResult<TpmActDetailRespVo>
     */
    PageResult<TpmActDetailRespVo> findList(TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 查询
     * @param id
     * @return TpmActDetailRespVo
     */
    TpmActDetailRespVo query(String id);

    /**
     * 新增
     * @param tpmActDetailReqVo
     * @return
     */
    void save(TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 更新
     * @param tpmActDetailReqVo
     * @return
     */
    void update(TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 活动预付查询活动明细
     * @param tpmActDetailReqVo
     * @return
     */
    PageResult<TpmActDetailRespVo> pageForAdvancePay(TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 活动明细报表查询
     * @param tpmActDetailReportReqVo
     * @return
     */
    PageResult<TpmActDetailReportRespVo> actDetailReport(TpmActDetailReportReqVo tpmActDetailReportReqVo);
}

