package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.util.PageUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.mapper.TpmActFeeShareMapper;
import com.biz.crm.act.service.ITmpActFeeShareService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动费用分摊表;接口实现
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TmpActFeeShareServiceExpandImpl")
public class TmpActFeeShareServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActFeeShareMapper, TmpActFeeShareEntity> implements ITmpActFeeShareService {

    @Resource
    private TpmActFeeShareMapper tpmActFeeShareMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TmpActFeeShareRespVo> findList(TmpActFeeShareReqVo reqVo){
        Page<TmpActFeeShareRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TmpActFeeShareRespVo> list = tpmActFeeShareMapper.findList(page, reqVo);
        return PageResult.<TmpActFeeShareRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tmpActFeeShareRespVo
     */
    @Override
    public TmpActFeeShareRespVo query(String id){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TmpActFeeShareReqVo reqVo){
        TmpActFeeShareEntity entity = CrmBeanUtil.copy(reqVo,TmpActFeeShareEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TmpActFeeShareReqVo reqVo){
        TmpActFeeShareEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TmpActFeeShareEntity> tmpActFeeShareEntities = tpmActFeeShareMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpActFeeShareEntities)){
            tmpActFeeShareEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tmpActFeeShareEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TmpActFeeShareEntity> tmpActFeeShareEntities = tpmActFeeShareMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpActFeeShareEntities)){
            tmpActFeeShareEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tmpActFeeShareEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TmpActFeeShareEntity> tmpActFeeShareEntities = tpmActFeeShareMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpActFeeShareEntities)){
                tmpActFeeShareEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tmpActFeeShareEntities);
    }
}
