package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.service.ITpmActFileService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动附件信息;接口实现
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmActFileServiceExpandImpl")
public class TpmActFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActFileMapper, TpmActFileEntity> implements ITpmActFileService {

    @Resource
    private TpmActFileMapper tpmActFileMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActFileRespVo> findList(TpmActFileReqVo reqVo){
        Page<TpmActFileRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmActFileRespVo> list = tpmActFileMapper.findList(page, reqVo);
        return PageResult.<TpmActFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmActFileRespVo
     */
    @Override
    public TpmActFileRespVo query(TpmActFileReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmActFileReqVo reqVo){
        TpmActFileEntity entity = CrmBeanUtil.copy(reqVo,TpmActFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmActFileReqVo reqVo){
        TpmActFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmActFileEntity> tpmActFileEntities = tpmActFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActFileEntities)){
            tpmActFileEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmActFileEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmActFileEntity> tpmActFileEntities = tpmActFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActFileEntities)){
            tpmActFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActFileEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmActFileEntity> tpmActFileEntities = tpmActFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActFileEntities)){
                tpmActFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActFileEntities);
    }
}
