package com.biz.crm.act.service.impl.actbuilder;

import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.act.model.*;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @ClassName PracticalityChargeActBuilder
 * @Author HuangLong
 * @Date 2020/9/2 10:03
 * @Description 促销活动builder
 */
@Slf4j
public class PromotionActBuilder extends BaseServiceHelper implements ActBaseBuilder {

  private ActServiceHelper helper;

  private TpmActReqVo reqVo;

  private TpmActEntity actEntity = new TpmActEntity();

  private List<TpmActBudgetEntity> actBudgetEntities = Lists.newArrayList();

  private List<TpmActDetailEntity> actDetailEntities = Lists.newArrayList();

  private List<TmpActFeeShareEntity> shareEntities = Lists.newArrayList();

  private List<TpmActFileEntity> fileEntities = Lists.newArrayList();

  private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = Lists.newArrayList();

  private List<TpmFeeBudgetEntity> feeBudgetEntities;

  private List<TpmCostTypeCategoriesEntity> categoriesEntities;

  private List<TpmCostTypeFineEntity> fineEntities;

  private List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities;

  private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;

  private Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap;

  private Map<String, TpmCostTypeFineEntity> fineEntitiesMap;

  private Map<String, TpmCostTypeCategoriesFineEntity> categoriesFineEntitiesMap;

  private Set<String> categoriesFineSet = Sets.newHashSet();
  /**
   * 费用预算控制维度的集合
   */
  private List<TpmFeeBudgetControlEntity> controlEntities;

  /**
   * 客户map,key customerCode
   */
  Map<String, MdmCustomerMsgSelectRespVo> customerMap;

  /**
   * 企业组织对应的map
   */
  private Map<String, MdmOrgRespVo> orgMap;

  //是否填了顺序
  private Boolean isUseOrder = false;
  //是否填了比例
  private Boolean isUserRatio = false;
  //扣减顺序集合,key:费用预算类型,value:扣减顺序值
  private Map<String, Integer> reduceOrderMap = Maps.newHashMap();
  //预算扣减比例集合,key:费用预算类型,value:扣减比例
  private Map<String, BigDecimal> reduceRatioMap = Maps.newHashMap();
  //活动明细编码-活动明细map
  private Map<String, TpmActDetailReqVo> actDetailMap = Maps.newHashMap();
  /**
   * 活动明细对应的可以使用的费用预算map,key活动明细编码
   */
  private Map<String, List<TpmFeeBudgetEntity>> actDetailBudgetMap = Maps.newHashMap();
  /**
   * 促销政策map,key政策编码,value促销政策对象
   */
  private Map<String, PromotionInfoRespVo> promotionMap = Maps.newHashMap();
  /**
   * 终端map,key终端编码,value终端对象
   */
  private Map<String, MdmTerminalVo> terminalMap = Maps.newHashMap();
  /**
   * 预算科目map
   */
  private Map<String, TpmBudgetSubjectsEntity> subjectsMap;

  private Map<String, MdmProductRespVo> productMap = Maps.newHashMap();

  private List<TpmActDetailProductEntity> detailProductEntities = Lists.newArrayList();

  public PromotionActBuilder(ActServiceHelper helper, TpmActReqVo reqVo) {
    this.helper = helper;
    this.reqVo = reqVo;
  }

  public static PromotionActBuilder builder(ActServiceHelper helper, TpmActReqVo reqVo) {
    return new PromotionActBuilder(helper, reqVo);
  }

  /**
   * 组装必要参数
   *
   * @return
   */
  @Override
  public PromotionActBuilder init() {
    //组织编码的集合
    Set<String> orgCodes = Sets.newHashSet();
    //客户编码的集合
    Set<String> customerCodes = Sets.newHashSet();
    //费用预算控制维度的id集合
    Set<String> controlIds = Sets.newHashSet();
    //预算科目编码集合
    Set<String> subjectsCodes = Sets.newHashSet();
    //商品编码集合
    Set<String> productCodes = Sets.newHashSet();
    //查询费用预算集合
    if (CollectionUtils.isNotEmpty(reqVo.getBudgetControlVos())) {
      List<TpmActBudgetReqVo> budgetVos = Lists.newArrayList();
      for (TpmFeeBudgetControlRespVo o : reqVo.getBudgetControlVos()) {
        controlIds.add(o.getId());
        List<TpmFeeBudgetRespVo> feeBudgetVos = o.getFeeBudgetVos();
        if (CollectionUtils.isNotEmpty(feeBudgetVos)) {
          List<TpmActBudgetReqVo> budgets = Lists.newArrayList();
          budgets = feeBudgetVos.stream().map(x -> {
            TpmActBudgetReqVo tpmActBudgetReqVo = new TpmActBudgetReqVo();
            tpmActBudgetReqVo.setActCode(x.getActCode());
            tpmActBudgetReqVo.setControlId(x.getControlId());
            tpmActBudgetReqVo.setReduceOrder(x.getReduceOrder());
            tpmActBudgetReqVo.setReduceRatio(x.getReduceRatio());
            tpmActBudgetReqVo.setId(x.getId());
            tpmActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
            tpmActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
            tpmActBudgetReqVo.setOrgType(x.getOrgType());
            return tpmActBudgetReqVo;
          }).collect(Collectors.toList());
          budgetVos.addAll(budgets);
        }
      }
      reqVo.setBudgetVos(budgetVos);
    }
    if (CollectionUtils.isNotEmpty(reqVo.getBudgetVos())) {
      List<TpmFeeBudgetEntity> feeBudgetEntities = helper.findFeeBudgetByControlIds(controlIds);
      if (CollectionUtils.isNotEmpty(feeBudgetEntities)) {
        feeBudgetEntities.forEach(o -> {
          if (StringUtils.isNotEmpty(o.getOrgCode())) {
            orgCodes.add(o.getOrgCode());
          }
          AssertUtils.isNotEmpty(o.getControlId(), "费用预算:" + o.getFeeBudgetCode() + "数据异常,控制为维度id为空");
          subjectsCodes.add(o.getBudgetSubjectsCode());
        });
        this.feeBudgetEntities = feeBudgetEntities;
      }
    } else {
      throw new BusinessException("请选择费用预算");
    }
    //获取支付方式类型map
    Map<String, String> payTypeTypeMap = helper.getPayTypeTypeMap(TpmGlobalDictConstants.PAY_TYPE, TpmGlobalDictConstants.PAY_TYPE_TYPE);
    //查询活动大类细类相关数据数据
    if (CollectionUtils.isNotEmpty(reqVo.getDetailVos())) {
      Set<String> categoriesCodes = Sets.newHashSet();
      Set<String> fineCodes = Sets.newHashSet();
      //促销政策编码集合
      Set<String> promotionCodes = Sets.newHashSet();
      //终端编码集合
      Set<String> terminalCodes = Sets.newHashSet();
      reqVo.getDetailVos().forEach(o -> {
        AssertUtils.isNotEmpty(o.getCategoriesCode(), "活动大类编码不能为空");
        AssertUtils.isNotEmpty(o.getFineCode(), "活动细类编码不能为空");
        categoriesCodes.add(o.getCategoriesCode());
        o.setOrgCode(Lists.newArrayList(orgCodes).get(0));
        fineCodes.add(o.getFineCode());
        if (StringUtils.isNotEmpty(o.getOrgCode())) {
          orgCodes.add(o.getOrgCode());
        }
        if (StringUtils.isNotEmpty(o.getCustomerCode())) {
          customerCodes.add(o.getCustomerCode());
        }
        if (StringUtils.isNotEmpty(o.getPayType())) {
          o.setPayTypeType(payTypeTypeMap.get(o.getPayType()));
        }
        if (StringUtils.isNotEmpty(o.getPolicyCode())) {
          promotionCodes.add(o.getPolicyCode());
        }
        if (StringUtils.isNotEmpty(o.getTerminalCode())) {
          terminalCodes.add(o.getTerminalCode());
        }
        if (CollectionUtils.isNotEmpty(o.getGiftProductList())) {
          o.getGiftProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getNormalProductList())) {
          o.getNormalProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getReplenishmentProductList())) {
          o.getReplenishmentProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getExecutionProductList())) {
          o.getExecutionProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
      });
      if (CollectionUtils.isNotEmpty(categoriesCodes) && CollectionUtils.isNotEmpty(fineCodes)) {
        if (categoriesCodes.size() > 1) {
          throw new BusinessException("数据异常,活动明细数据中的活动大类不一致");
        }
        this.categoriesFineSet = helper.findCategoriesFineEntities(categoriesCodes, fineCodes).stream().map(o -> o.getCategoriesCode() + o.getFineCode()).collect(Collectors.toSet());
      }
      this.categoriesEntities = helper.findCategoriesEntitiesByCodes(categoriesCodes);
      this.fineEntities = helper.findFineEntitiesByCodes(fineCodes);
      this.categoriesFineEntities = helper.findCategoriesFineEntities(categoriesCodes, fineCodes);
      this.customerMap = helper.findCustomerByCodes(customerCodes);
      this.controlEntities = helper.findFeeBudgetControls(controlIds);
      this.subjectsMap = helper.findBudgetSubjectsByCodes(subjectsCodes);
      this.productMap = helper.findProductMapByCodes(Lists.newArrayList(productCodes));

      List<PromotionInfoRespVo> promotions = helper.findPromotionsByCodes(promotionCodes);
      if (CollectionUtils.isNotEmpty(promotions)) {
        for (PromotionInfoRespVo promotion : promotions) {
          this.promotionMap.put(promotion.getPromotionPolicyCode(), promotion);
          //CommonConstant.DMS.PromotionPolicyScopeType.
          //todo 这里先用魔法值,等DMS有了枚举再改
          promotion.getScopeList().stream().forEach(o -> {
            if (StringUtils.equals("cusOrg", o.getScopeType()) || StringUtils.equals("terminalOrg", o.getScopeType())) {
              orgCodes.add(o.getScopeCode());
            }
          });
        }
      }
      List<MdmTerminalVo> terminals = helper.findTerminalByCodes(terminalCodes);
      this.terminalMap = terminals.stream().collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, Function.identity()));
      this.orgMap = helper.findOrgByCodes(orgCodes);
    }
    return this;
  }

  /**
   * 参数校验
   *
   * @return
   */
  @Override
  public PromotionActBuilder check() {
    //校验活动信息
    this.checkActData();
    //校验预算信息
    this.checkFeeBudgetData();
    //校验明细信息
    this.checkDetailData();
    //校验预算扣减
    this.checkFeeBudgetIsEnough();
    //校验分摊信息
    this.checkShareData();
    return this;
  }

  /**
   * 校验预算扣减是否满足
   */
  private void checkFeeBudgetIsEnough() {
    //暂存不需要过费用预算的校验
    if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      return;
    }
    Map<String, TpmFeeBudgetControlEntity> controlEntityMap = controlEntities.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
    for (int i = 0; i < reqVo.getDetailVos().size(); i++) {
      TpmActDetailReqVo o = reqVo.getDetailVos().get(i);
      //如果是按比例扣减,需要校验每个比例对应的费用预算必须要有,否则报错,费用预算需要按照时间排升序
      //如果是按顺序扣减,需要先按照扣减顺序的类型分组,每一组内数据需要按照时间排升序,组与组之间还需要按照填写的顺序排序
      List<TpmFeeBudgetEntity> budgetEntities = actDetailBudgetMap.get(o.getActDetailCode());
      AssertUtils.isNotEmpty(budgetEntities, "您选择的第" + (i + 1) + "条活动明细数据没有可用的费用预算");
      Map<String, List<TpmFeeBudgetEntity>> map = Maps.newHashMap();
      //先把费用预算按照预算类型和组织类型分组
      budgetEntities.forEach(p -> {
        String key = "";
        if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), p.getFeeBudgetType())) {
          key = p.getFeeBudgetType() + p.getOrgType();
        } else {
          key = p.getFeeBudgetType();
        }
        List<TpmFeeBudgetEntity> tpmFeeBudgetEntities = map.get(key);
        if (CollectionUtils.isEmpty(tpmFeeBudgetEntities)) {
          tpmFeeBudgetEntities = Lists.newArrayList();
        }
        tpmFeeBudgetEntities.add(p);
        map.put(key, tpmFeeBudgetEntities);
      });
      //记录费用预算的扣减顺序
      int orderCount = 1;
      if (this.isUseOrder) {
        //按顺序
        //把费用预算类型对应的顺序map反转成一个新的map,key是顺序
        Map<Integer, String> invertMap = MapUtils.invertMap(this.reduceOrderMap);
        AtomicReference<BigDecimal> applyAmount = new AtomicReference<>(o.getApplyAmount());
        for (int y = 1; y <= invertMap.keySet().size(); y++) {
          String k = invertMap.get(y);
          //按顺序取出来应该先扣的预算组
          List<TpmFeeBudgetEntity> entityList = map.get(k);
          if (CollectionUtils.isEmpty(entityList)) {
            continue;
          }
//                    AssertUtils.isNotEmpty(entityList,"费用预算数据异常,联系管理检查控制维度表数据");
          //再按照月份将预算进行升序排序
          List<TpmFeeBudgetEntity> collect = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
          //按顺序扣减费用预算
          for (TpmFeeBudgetEntity t : collect) {
            //第一条不够扣就继续往下扣
            //生成费用预算明细
            //费用预算控制维度的可用金额递减
            //费用预算主表的的可用余额递减
            TpmBudgetSubjectsEntity subjectsEntity = subjectsMap.get(t.getBudgetSubjectsCode());
            AssertUtils.isNotNull(subjectsEntity, "费用预算:" + t.getFeeBudgetCode() + "对应的预算科目:" + t.getBudgetSubjectsCode() + "不存在");
            TpmFeeBudgetControlEntity controlEntity = controlEntityMap.get(t.getControlId());
            TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
            CrmBeanUtil.copyProperties(t, feeBudgetDetailsEntity);
            super.setPublicParamsNull(feeBudgetDetailsEntity);
            feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
            //如果预算科目的控制类型为不控制,则该预算可以扣为负数
            if (StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
              t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
              t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
              feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
              controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
              applyAmount.set(BigDecimal.ZERO);
            } else {
              BigDecimal subtract = applyAmount.get().subtract(t.getCanUseAmount());
              if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                //当前预算不够扣
                t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                t.setCanUseAmount(BigDecimal.ZERO);
                applyAmount.set(subtract);
              } else {
                //当前预算够扣
                t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                applyAmount.set(BigDecimal.ZERO);
              }
            }
            feeBudgetDetailsEntity.setBusinessCode(reqVo.getActCode());
            feeBudgetDetailsEntity.setYear(t.getBudgetYear());
            feeBudgetDetailsEntity.setMonth(t.getBudgetMonth());
            feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
            feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
            feeBudgetDetailsEntity.setBusinessName(reqVo.getActName());
            feeBudgetDetailsEntity.setReduceOrder(orderCount);
            feeBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
            feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            orderCount++;
            this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
          }
        }
        //如果循环完了申请金额还是大于0,那就报错费用预算金额不足
        AssertUtils.isTrue(applyAmount.get().compareTo(BigDecimal.ZERO) == 0, "您选择的第" + (i + 1) + "活动明细数据费用预算余额不足");
      }
    }
  }

  /**
   * 校验活动信息
   */
  private void checkActData() {
    //获取区间的配置字典
    String config = ParamUtil.getParameterValue(TpmGlobalDictConstants.BUDGET_USE_DATE_RULE);
    AssertUtils.isNotEmpty(config, "未获取到预算选择时间控制开关配置");
    //如果获取到的值为当前区间(current),开始时间和结束时间必须填写
    if (StringUtils.equals(BudgetUseDateRuleEnum.CURRENT.getCode(), config)) {
      AssertUtils.isNotEmpty(reqVo.getBeginDate(), "活动开始时间不能为空");
      AssertUtils.isNotEmpty(reqVo.getEndDate(), "活动结束时间不能为空");
    }
    AssertUtils.isNotEmpty(reqVo.getSaveType(), "操作类型不能为空");
    if (StringUtils.isNotEmpty(reqVo.getBeginDate()) && StringUtils.isEmpty(reqVo.getEndDateSecond())) {
      reqVo.setEndDateSecond(DateUtil.DAY_LATEST_TIME);
    }
    if (StringUtils.isNotEmpty(reqVo.getEndDate()) && StringUtils.isEmpty(reqVo.getBeginDateSecond())) {
      reqVo.setBeginDateSecond(DateUtil.DAY_EARLIEST_TIME);
    }
    //开始时间不能大于结束时间
    if (StringUtils.isNotEmpty(reqVo.getBeginDate()) && StringUtils.isNotEmpty(reqVo.getEndDate())) {
      AssertUtils.isTrue(StringUtils.compare(reqVo.getBeginDate() + reqVo.getBeginDateSecond(), reqVo.getEndDate() + reqVo.getEndDateSecond()) < 0, "开始时间不能大于结束时间");
    }
    if (StringUtils.isEmpty(reqVo.getActCode())) {
      String actCode = CodeUtil.createOneCode(CrmCodeRuleConstants.ACT);
      reqVo.setActCode(actCode);
    }
    AssertUtils.isNotEmpty(reqVo.getActName(), "请输入活动名称");
    AssertUtils.isNotEmpty(reqVo.getActType(), "请选择活动类型");
  }

  /**
   * 校验预算信息
   */
  public void checkFeeBudgetData() {
    AssertUtils.isNotNull(reqVo.getBudgetVos(), "预算信息不能为空");
    AssertUtils.isTrue(reqVo.getBudgetVos().size() == reqVo.getBudgetVos().size(), "不能选择相同的费用预算数据");
    AssertUtils.isTrue(feeBudgetEntities.size() == reqVo.getBudgetVos().size(), "费用预算数据发生变动,请重新选择费用预算");
    Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap = Maps.newHashMap();
    //费用预算类型集合
    Set<String> feeBudgetTypeSet = Sets.newHashSet();
    feeBudgetEntities.stream().forEach(o -> {
      feeBudgetEntityMap.put(o.getFeeBudgetCode(), o);
      //部门预算特殊,必须带上组织类型
      if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), o.getFeeBudgetType())) {
        feeBudgetTypeSet.add(o.getFeeBudgetType() + o.getOrgType());
      } else {
        feeBudgetTypeSet.add(o.getFeeBudgetType());
      }
    });
    this.feeBudgetEntityMap = feeBudgetEntityMap;
    //扣减顺序必须是从1开始+1,最大值为费用预算类型去重后的size,预算扣减比例必须相加等于1

    Set<Integer> reduceOrderSet = Sets.newHashSet();

    Set<BigDecimal> reduceRatioSet = Sets.newHashSet();
    for (TpmActBudgetReqVo o : reqVo.getBudgetVos()) {

      //设置扣减顺序的默认值,因为当前活动只会选择一条预算控制维度
      o.setReduceOrder(1);
      if (Objects.nonNull(o.getReduceOrder()) && Objects.nonNull(o.getReduceRatio())) {
        throw new BusinessException("不能同时填写比例和顺序");
      }
      if (Objects.isNull(o.getReduceOrder()) && Objects.isNull(o.getReduceRatio())) {
        throw new BusinessException("比例和顺序必须选择一项填写");
      }
      if (Objects.nonNull(o.getReduceRatio())) {
        this.isUserRatio = true;
        reduceRatioSet.add(o.getReduceRatio());
      }
      if (Objects.nonNull(o.getReduceOrder())) {
        this.isUseOrder = true;
        reduceOrderSet.add(o.getReduceOrder());
      }
      TpmFeeBudgetEntity feeBudgetEntity = feeBudgetEntityMap.get(o.getFeeBudgetCode());
      AssertUtils.isNotNull(feeBudgetEntity, "费用预算:" + o.getFeeBudgetCode() + ",不存在");
      AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), feeBudgetEntity.getEnableStatus()), "费用预算:" + o.getFeeBudgetCode() + ",已经被禁用");
      String mapKey;
      if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), o.getFeeBudgetType())) {
        mapKey = feeBudgetEntity.getFeeBudgetType() + feeBudgetEntity.getOrgType();
      } else {
        mapKey = feeBudgetEntity.getFeeBudgetType();
      }
      if (CollectionUtils.isNotEmpty(reduceOrderSet)) {
        //扣减顺序
        Integer integer = this.reduceOrderMap.get(mapKey);
        if (Objects.isNull(integer)) {
          this.reduceOrderMap.put(mapKey, o.getReduceOrder());
        } else {
          AssertUtils.isTrue(Objects.equals(integer, o.getReduceOrder()), "相同费用预算类型的数据扣减顺序必须一致");
        }
      }
      if (CollectionUtils.isNotEmpty(reduceRatioSet)) {
        //扣减比例
        BigDecimal bigDecimal = this.reduceRatioMap.get(mapKey);
        if (Objects.isNull(bigDecimal)) {
          this.reduceRatioMap.put(mapKey, o.getReduceRatio());
        } else {
          AssertUtils.isTrue(Objects.equals(bigDecimal, o.getReduceRatio()), "相同费用预算类型的数据扣减比例必须一致");
        }
      }
      o.setActCode(reqVo.getActCode());
      o.setControlId(feeBudgetEntity.getControlId());
      o.setOrgType(feeBudgetEntity.getOrgType());
    }
    if (this.isUseOrder && this.isUserRatio) {
      throw new BusinessException("不能同时填写比例和顺序");
    }
    //校验扣减顺序的值是否符合规范
    if (CollectionUtils.isNotEmpty(reduceOrderSet)) {
      Integer max = reduceOrderSet.stream().map(o -> o).reduce(Integer::max).get();
      Integer min = reduceOrderSet.stream().map(o -> o).reduce(Integer::min).get();
      //最大值必须等于扣减顺序集合的size
      AssertUtils.isTrue(Objects.equals(max, reduceOrderSet.size()), "扣减顺序最大值错误");
      //最小值必须等于1
      AssertUtils.isTrue(Objects.equals(min, 1), "扣减顺序最小值必须为1");
    }
    if (CollectionUtils.isNotEmpty(reduceRatioSet)) {
      //校验扣减比例的值相加是否等于100
      BigDecimal bigDecimal = reduceRatioSet.stream().map(o -> o).reduce(BigDecimal::add).get();
      AssertUtils.isTrue(bigDecimal.compareTo(BigDecimal.valueOf(100)) == 0, "扣减比例和必须等于100");
    }
    //2021-11-09 新增费用预算产品和产品层级校验
    helper.checkFeeBudgetMaterial(feeBudgetEntities, reqVo.getDetailVos());
  }

  /**
   * 校验明细信息
   */
  public void checkDetailData() {
    AssertUtils.isNotEmpty(reqVo.getDetailVos(), "明细信息不能为空");
    Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap = categoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
    this.categoriesEntitiesMap = categoriesEntitiesMap;
    fineEntitiesMap = fineEntities.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
    AtomicReference<BigDecimal> totalAmount = new AtomicReference<>(BigDecimal.ZERO);
    for (int i = 0; i < reqVo.getDetailVos().size(); i++) {
      TpmActDetailReqVo o = reqVo.getDetailVos().get(i);
      String categoriesFine = o.getCategoriesCode() + o.getFineCode();
      if (!this.categoriesFineSet.contains(categoriesFine)) {
        throw new BusinessException("数据异常，明细信息：" + o.getCategoriesCode() + "/" + o.getCategoriesName() + "与" + o.getFineCode() + "/" + o.getFineName() + "关联关系不存在");
      }
      AssertUtils.isNotNull(o.getForecastSalesAmount(), "预估销售额不能为空");
      AssertUtils.isNotEmpty(o.getPolicyCode(), "促销政策编码不能为空");
      AssertUtils.isNotEmpty(o.getOrgCode(), "第[" + (i + 1) + "]条活动明细组织编码不能为空");
      PromotionInfoRespVo promotionVo = promotionMap.get(o.getPolicyCode());
      o.setPolicyName(promotionVo.getPromotionPolicyName());
      //设置政策预估费率
      o.setFeeRate(Optional.ofNullable(promotionVo.getFeeRate()).orElse(BigDecimal.ZERO));
      o.setApplyAmount(o.getFeeRate().divide(BigDecimal.valueOf(100L)).multiply(o.getForecastSalesAmount()));
      if (StringUtils.equals("customer", promotionVo.getScopeType())) {
        //如果促销政策的范围类型为客户类型,活动明细的客户数据必须有值
        AssertUtils.isNotEmpty(o.getCustomerCode(), "第[" + (i + 1) + "]条活动明细客户编码不能为空");
        AssertUtils.isTrue(StringUtils.isEmpty(o.getTerminalCode()), "第[" + (i + 1) + "]条活动明细的促销政策不支持终端类型");
        MdmCustomerMsgSelectRespVo customerVo = customerMap.get(o.getCustomerCode());
        o.setCustomerName(customerVo.getCustomerName());
      }
      if (StringUtils.equals("terminal", promotionVo.getScopeType())) {
        //如果促销政策的范围类型为客户类型,活动明细的客户数据必须有值
        AssertUtils.isNotEmpty(o.getCustomerCode(), "第[" + (i + 1) + "]条活动明细终端编码不能为空");
        AssertUtils.isTrue(StringUtils.isEmpty(o.getCustomerCode()), "第[" + (i + 1) + "]条活动明细的促销政策不支持客户类型");
        MdmTerminalVo terminalVo = terminalMap.get(o.getTerminalCode());
        o.setTerminalName(terminalVo.getTerminalName());
      }
      //检验当前活动明细选定的客户或者终端是否可以使用当前促销政策

      this.checkPromotionCanUse(o);

      if (StringUtils.isEmpty(o.getActDetailCode())) {
        o.setActDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.ACT_DETAIL));
      }
      if (StringUtils.isNotEmpty(reqVo.getBeginDate()) && StringUtils.isNotEmpty(reqVo.getEndDate()) && StringUtils.isEmpty(o.getExecuteBeginDate())) {
        o.setExecuteBeginDate(reqVo.getBeginDate());
        o.setExecuteBeginDateSecond(reqVo.getBeginDateSecond());
        o.setExecuteEndDate(reqVo.getEndDate());
        o.setExecuteEndDateSecond(reqVo.getEndDateSecond());
      }
      //及活动细类发布需求一起控制（如发布到部门，则部门必填；发布到客户，则客户必填；发布到终端，则门店必填），则提示：请输入XXX后（字段名）。
      TpmCostTypeFineEntity fineEntity = fineEntitiesMap.get(o.getFineCode());
      //根据细类要求的必填项做校验
      //获取到每一行明细能够使用的费用预算
      o.setFineName(fineEntity.getFineName());
      //是否需要核销
      o.setIsAudit(fineEntity.getIsAudit());
      //是否完全核销
      o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
      o.setActivityReleaseNeed(fineEntity.getActivityReleaseNeed());
      o.setIsAllowRepeatAudit(fineEntity.getIsAllowRepeatAudit());
      this.getActDetailCanUseBudget(fineEntity, o);
      //累加申请总金额
      totalAmount.set(totalAmount.get().add(o.getApplyAmount()));
      TpmCostTypeCategoriesEntity categoriesEntity = categoriesEntitiesMap.get(o.getCategoriesCode());
      o.setBudgetSubjectsCode(categoriesEntity.getBudgetSubjectsCode());
      o.setCategoriesName(categoriesEntity.getCategoriesName());
      reqVo.setTotalAmount(Optional.ofNullable(reqVo.getTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAmount()));
      MdmOrgRespVo mdmOrgRespVo = orgMap.get(o.getOrgCode());
      if (Objects.nonNull(mdmOrgRespVo)) {
        o.setOrgName(mdmOrgRespVo.getOrgName());
      }
      this.checkDetailProducts(o);

      actDetailMap.put(o.getActDetailCode(), o);
    }
  }

  /**
   * 检验当前活动明细选定的客户或者终端是否可以使用当前促销政策
   *
   * @param detail
   */
  private void checkPromotionCanUse(TpmActDetailReqVo detail) {
    PromotionInfoRespVo promotion = this.promotionMap.get(detail.getPolicyCode());
    List<PromotionPolicyScopeVo> scopeList = promotion.getScopeList();
    //如果促销范围是空的,说明所有的客户终端都可以使用当前政策
    if (CollectionUtils.isNotEmpty(scopeList)) {
      //先把范围按照是否包含分个组,因为需要先判断非包含的数据
      Map<String, List<PromotionPolicyScopeVo>> isContainableMap = scopeList.stream().collect(Collectors.groupingBy(PromotionPolicyScopeVo::getContainable));
      List<PromotionPolicyScopeVo> noContainList = isContainableMap.get(GlobalWhetherEnum.NO.getCode());
//            /** 渠道 */
//            public static final CommonConstant.DictItem CHANNEL = new CommonConstant.DictItem("channel", "渠道");
//            /** 组织 */
//            public static final CommonConstant.DictItem ORG = new CommonConstant.DictItem("org", "组织");
//            /** 客户 */
//            public static final CommonConstant.DictItem CUST = new CommonConstant.DictItem("cust", "客户");
//            /** 终端 */
//            public static final CommonConstant.DictItem TERMINAL = new CommonConstant.DictItem("terminal", "终端");
//            /** 终端组织 */
//            public static final CommonConstant.DictItem TERMINAL_ORG = new CommonConstant.DictItem("terminal_org", "终端组织");
      if (CollectionUtils.isNotEmpty(noContainList)) {
        noContainList.forEach(x -> {
          //如果促销是到客户的,校验客户的数据
          if (StringUtils.equals("customer", promotion.getScopeType())) {
//                        if(StringUtils.equals(x.getScopeType()))
          }

        });
      }
    }

  }

  /**
   * 获取到每一行明细能够使用的费用预算
   *
   * @param fineEntity
   * @param o
   */
  private void getActDetailCanUseBudget(TpmCostTypeFineEntity fineEntity, TpmActDetailReqVo o) {
    MdmOrgRespVo detailOrgVo = orgMap.get(o.getOrgCode());
    AssertUtils.isNotNull(detailOrgVo, "活动明细选择的组织:" + o.getOrgCode() + "不存在");
    AssertUtils.isNotEmpty(this.feeBudgetEntities, "当前活动对应的费用预算不存在");
    for (TpmFeeBudgetEntity r : this.feeBudgetEntities) {
      MdmOrgRespVo engineOrgRespVo = orgMap.get(r.getOrgCode());
      AssertUtils.isNotNull(engineOrgRespVo, "费用预算:" + r.getFeeBudgetCode() + "对应的企业组织不存在");
      List<TpmFeeBudgetEntity> entities = actDetailBudgetMap.get(o.getActDetailCode());
      if (CollectionUtils.isEmpty(entities)) {
        entities = Lists.newArrayList();
      }
      entities.add(r);
      actDetailBudgetMap.put(o.getActDetailCode(), entities);
    }
  }

  /**
   * 校验分摊信息(产品分摊才会单独存,目前只有项目活动会用到产品分摊)
   */
  public void checkShareData() {
    if (CollectionUtils.isNotEmpty(reqVo.getFeeShareVos())) {
      throw new BusinessException("当前活动类型不能分摊费用到产品");
    }
  }

  /**
   * 转换需要保存的数据
   *
   * @return
   */
  @Override
  public PromotionActBuilder convert() {
    //转换活动主表数据
    CrmBeanUtil.copyProperties(reqVo, actEntity);
    //如果页面传的编码为空,从编码工具里面取
    actEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
    actEntity.setAuditTotalAmount(BigDecimal.ZERO);
    actEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
    //转换活动预算表数据
    reqVo.getBudgetVos().stream().forEach(o -> {
      TpmActBudgetEntity actBudgetEntity = new TpmActBudgetEntity();
      CrmBeanUtil.copyProperties(o, actBudgetEntity);
      o.setActCode(actEntity.getActCode());
      actBudgetEntities.add(actBudgetEntity);
    });
    //转换活动明细数据
    reqVo.getDetailVos().forEach(o -> {
      TpmActDetailEntity actDetailEntity = new TpmActDetailEntity();
      CrmBeanUtil.copyProperties(o, actDetailEntity);
      actDetailEntity.setActCode(actEntity.getActCode());
      actDetailEntities.add(actDetailEntity);
    });
    //转换活动分摊数据
    if (CollectionUtils.isNotEmpty(reqVo.getFeeShareVos())) {
      reqVo.getFeeShareVos().forEach(o -> {
        TmpActFeeShareEntity actFeeShareEntity = new TmpActFeeShareEntity();
        CrmBeanUtil.copyProperties(o, actFeeShareEntity);
        actFeeShareEntity.setActCode(actEntity.getActCode());
        shareEntities.add(actFeeShareEntity);
      });
    }
    //转换活动附件表数据
    if (CollectionUtils.isNotEmpty(reqVo.getFileList())) {
      reqVo.getFileList().forEach(o -> {
        TpmActFileEntity fileEntity = new TpmActFileEntity();
        CrmBeanUtil.copyProperties(o, fileEntity);
        fileEntity.setActCode(actEntity.getActCode());
        fileEntities.add(fileEntity);
      });
    }
    return this;
  }

  /**
   * 转换费用预算明细数据
   */
  public void convertFeeBudgetDetailsEntities() {
    String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
    String currentYear = String.valueOf(DateUtil.getCurrentYear());
    actDetailEntities.stream().forEach(o -> {
      TpmFeeBudgetDetailsEntity entity = new TpmFeeBudgetDetailsEntity();
      entity.setMonth(currentMonth);
      entity.setYear(currentYear);
      entity.setBusinessCode(actEntity.getActCode());
      entity.setBusinessLineCode(o.getActDetailCode());
      feeBudgetDetailsEntities.add(entity);
    });
  }

  /**
   * 保存数据
   *
   * @return
   */
  @Override
  public TpmActEntity save() {
    //保存主表数据
    helper.saveOrUpdateAct(actEntity, reqVo);
    //保存预算表数据
    helper.saveActBudgets(actBudgetEntities, reqVo);
    //保存明细表数据
    helper.saveActDetails(actDetailEntities, reqVo);
    //保存分摊表数据
    helper.saveActShares(shareEntities, reqVo);
    //保存附件表数据
    helper.saveActFiles(fileEntities, reqVo);
    //保存费用预算明细表数据
    helper.saveFeeBudgetDetails(feeBudgetDetailsEntities, reqVo);
    //保存费用预算数据
    helper.saveFeeBudgets(feeBudgetEntities, reqVo);
    //保存费用预算控制维度数据
    helper.saveFeeBudgetControls(controlEntities, reqVo);
    //保存活动明细产品表数据
    helper.saveActDetailProducts(detailProductEntities, reqVo);
    return actEntity;
  }

  /**
   * 更新数据
   *
   * @return
   */
  @Override
  public TpmActEntity update() {
    //保存主表数据
    helper.saveOrUpdateAct(actEntity, reqVo);
    //保存预算表数据
    helper.saveActBudgets(actBudgetEntities, reqVo);
    //保存明细表数据
    helper.saveActDetails(actDetailEntities, reqVo);
    //保存分摊表数据
    helper.saveActShares(shareEntities, reqVo);
    //保存附件表数据
    helper.saveActFiles(fileEntities, reqVo);
    //保存费用预算明细表数据
    helper.saveFeeBudgetDetails(feeBudgetDetailsEntities, reqVo);
    //保存费用预算数据
    helper.saveFeeBudgets(feeBudgetEntities, reqVo);
    //保存费用预算控制维度数据
    helper.saveFeeBudgetControls(controlEntities, reqVo);
    //保存活动明细产品表数据
    helper.saveActDetailProducts(detailProductEntities, reqVo);
    return actEntity;
  }

  /**
   * 处理明细的商品数据
   *
   * @param detailReqVo
   */
  public void checkDetailProducts(TpmActDetailReqVo detailReqVo) {
    TpmCostTypeFineEntity fineEntity = fineEntitiesMap.get(detailReqVo.getFineCode());
    if (CollectionUtils.isNotEmpty(detailReqVo.getGiftProductList())) {
      List<TpmActDetailProductVo> giftProductList = detailReqVo.getGiftProductList();
      Set<String> giftProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : giftProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!giftProductCodes.contains(o.getProductCode()), "赠品产品重复");
        giftProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.GIFT.getCode());
        o.setPaymentMethod(fineEntity.getPaymentMethod());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setPrice(mdmProductRespVo.getExt21());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity1 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity1);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getNormalProductList())) {
      List<TpmActDetailProductVo> normalProductList = detailReqVo.getNormalProductList();
      Set<String> normalProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : normalProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!normalProductCodes.contains(o.getProductCode()), "本品产品重复");
        normalProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.NORMAL.getCode());
        o.setPaymentMethod(fineEntity.getPaymentMethod());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setPrice(mdmProductRespVo.getExt21());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getReplenishmentProductList())) {
      List<TpmActDetailProductVo> replenishmentProductList = detailReqVo.getReplenishmentProductList();
      Set<String> replenishmentProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : replenishmentProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!replenishmentProductCodes.contains(o.getProductCode()), "货补产品重复");
        replenishmentProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.REPLENISHMENT.getCode());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getExecutionProductList())) {
      List<TpmActDetailProductVo> executionProductList = detailReqVo.getExecutionProductList();
      Set<String> executionProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : executionProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!executionProductCodes.contains(o.getProductCode()), "执行产品重复");
        executionProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.EXECUTION.getCode());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
  }
}
