package com.biz.crm.actfieldcollect.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动采集字段表;实体类
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_collect_field")
@CrmTable(name = "tpm_act_collect_field",tableNote = "TPM-活动采集字段表")
public class TpmActCollectFieldEntity extends CrmExtEntity<TpmActCollectFieldEntity> {

    /**
     * 字段编码
     */
    @CrmColumn(name = "field_code", length = 32,note = "字段编码")
    private String fieldCode;

    /**
     * 字段名称
     */
    @CrmColumn(name = "field_name", length = 60,note = "字段名称")
    private String fieldName;

    /**
     * 数据字典
     */
    @CrmColumn(name = "data_dict", length = 32,note = "数据字典")
    private String dataDict;

    /**
     * 输入类型
     */
    @CrmColumn(name = "input_type", length = 32,note = "输入类型")
    private String inputType;

    /**
     * 时间格式
     */
    @CrmColumn(name = "time_format", length = 60,note = "时间格式")
    private String timeFormat;

    /**
     * 字段可填大小
     */
    @CrmColumn(name = "field_input_size", length = 32,note = "字段可填大小")
    private String fieldInputSize;

    /**
     * 显示宽度
     */
    @CrmColumn(name = "show_width", length = 32,note = "显示宽度")
    private String showWidth;

    /**
     * 显示高度
     */
    @CrmColumn(name = "show_height", length = 32,note = "显示高度")
    private String showHeight;

}
