package com.biz.crm.actfieldcollect.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.actfieldcollect.model.TpmActCollectFieldEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;

import java.util.List;

/**
 * 活动采集字段表;接口
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
public interface ITpmActCollectFieldService extends IService<TpmActCollectFieldEntity> {

    /**
     * 列表
     * @param tpmActCollectFieldReqVo
     * @return PageResult<TpmActCollectFieldRespVo>
     */
    PageResult<TpmActCollectFieldRespVo> findList(TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 查询
     * @param id
     * @return TpmActCollectFieldRespVo
     */
    TpmActCollectFieldRespVo query(String id);

    /**
     * 新增
     * @param tpmActCollectFieldReqVo
     * @return
     */
    void save(TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 更新
     * @param tpmActCollectFieldReqVo
     * @return
     */
    void update(TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

