package com.biz.crm.actfieldcollect.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.actfieldcollect.mapper.TpmActCollectFieldMapper;
import com.biz.crm.actfieldcollect.model.TpmActCollectFieldEntity;
import com.biz.crm.actfieldcollect.service.ITpmActCollectFieldService;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmActCollectFieldFineMapper;
import com.biz.crm.costtypefine.model.TpmActCollectFieldFineEntity;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 活动采集字段表;接口实现
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmActCollectFieldServiceExpandImpl")
public class TpmActCollectFieldServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActCollectFieldMapper, TpmActCollectFieldEntity> implements ITpmActCollectFieldService {

    @Resource
    private TpmActCollectFieldMapper tpmActCollectFieldMapper;

    @Autowired
    private ActFieldCollectServiceHelper actFieldCollectServiceHelper;

    @Resource
    private TpmActCollectFieldFineMapper fieldFineMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActCollectFieldRespVo> findList(TpmActCollectFieldReqVo reqVo){
        Page<TpmActCollectFieldRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(actFieldCollectServiceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmActCollectFieldRespVo> list = tpmActCollectFieldMapper.findList(page, reqVo);
        actFieldCollectServiceHelper.convertListDate(list);
        return PageResult.<TpmActCollectFieldRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmActCollectFieldRespVo
     */
    @Override
    public TpmActCollectFieldRespVo query(String id){
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmActCollectFieldEntity tpmActCollectFieldEntity = tpmActCollectFieldMapper.selectById(id);
        if(ObjectUtils.isEmpty(tpmActCollectFieldEntity)){
            return new TpmActCollectFieldRespVo();
        }
        TpmActCollectFieldRespVo respVo = CrmBeanUtil.copy(tpmActCollectFieldEntity, TpmActCollectFieldRespVo.class);
        List<TpmActCollectFieldRespVo> list = new ArrayList<>(Arrays.asList(respVo));
//        actFieldCollectServiceHelper.convertListDate(list);
        respVo = list.get(0);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmActCollectFieldReqVo reqVo){
        actFieldCollectServiceHelper.saveCheck(reqVo);
        TpmActCollectFieldEntity entity = CrmBeanUtil.copy(reqVo,TpmActCollectFieldEntity.class);
        this.save(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmActCollectFieldRespVo newData = CrmBeanUtil.copy(entity, TpmActCollectFieldRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getFieldCode(),newData);

    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmActCollectFieldReqVo reqVo){
        actFieldCollectServiceHelper.saveCheck(reqVo);
        TpmActCollectFieldEntity tpmAuditEntity = CrmBeanUtil.copy(reqVo, TpmActCollectFieldEntity.class);
        //日志老数据
        TpmActCollectFieldRespVo oldData = this.query(reqVo.getId());
        //防止修改时FieldCode为""的情况
        tpmAuditEntity.setFieldCode(oldData.getFieldCode());
        this.updateById(tpmAuditEntity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmActCollectFieldRespVo newData = CrmBeanUtil.copy(tpmAuditEntity, TpmActCollectFieldRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getFieldCode(),oldData,newData);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        Assert.notEmpty(ids, "请指定要删除的采集字段数据!");
        List<TpmActCollectFieldEntity> tpmActCollectFieldEntities = tpmActCollectFieldMapper.selectBatchIds(ids);
        Assert.notEmpty(tpmActCollectFieldEntities, "活动采集字段数据不存在");
        //日志老数据
        List<TpmActCollectFieldRespVo> oldDataList = CrmBeanUtil.copyList(tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        Set<String> idConnect = tpmActCollectFieldEntities.stream().map(TpmActCollectFieldEntity::getId).collect(Collectors.toSet());
        tpmActCollectFieldMapper.deleteBatchIds(idConnect);
        //删除活动细类关联的采集字段
        fieldFineMapper.delete(new LambdaQueryWrapper<TpmActCollectFieldFineEntity>().in(TpmActCollectFieldFineEntity::getFieldCode,tpmActCollectFieldEntities.stream().map(TpmActCollectFieldEntity::getFieldCode).collect(Collectors.toList())));
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        oldDataList.stream().forEach(o->{
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),o.getId(),o.getFieldCode(),o);
        });
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmActCollectFieldEntity> tpmActCollectFieldEntities = tpmActCollectFieldMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmActCollectFieldRespVo> oldDataList = CrmBeanUtil.copyList(tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        if(CollectionUtils.isNotEmpty(tpmActCollectFieldEntities)){
            tpmActCollectFieldEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActCollectFieldEntities);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmActCollectFieldRespVo> newDataList = CrmBeanUtil.copyList(tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        for (int i= 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFieldCode(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmActCollectFieldEntity> tpmActCollectFieldEntities = tpmActCollectFieldMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmActCollectFieldRespVo> oldDataList = CrmBeanUtil.copyList(tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        if(CollectionUtils.isNotEmpty(tpmActCollectFieldEntities)){
                tpmActCollectFieldEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActCollectFieldEntities);
        //日志
        List<TpmActCollectFieldRespVo> newDataList = CrmBeanUtil.copyList(tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i= 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFieldCode(),oldDataList.get(i),newDataList.get(i));
        }
    }
}
