package com.biz.crm.advancepay.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动预付明细表 实体类
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_advance_pay_detail")
@CrmTable(name = "tpm_act_advance_pay_detail",tableNote = "TPM-活动预付明细表")
public class TpmActAdvancePayDetailEntity extends CrmExtEntity<TpmActAdvancePayDetailEntity> {

    /**
     * 预付编号
     */
    @CrmColumn(name = "advance_code", length = 32,note = "预付编号")
    private String advanceCode;

    /**
     * 预付明细编码
     */
    @CrmColumn(name = "advance_detail_code", length = 32,note = "预付明细编码")
    private String advanceDetailCode;

    @ApiModelProperty("活动编码")
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;
    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 支付方式(字典编码)
     */
    @CrmColumn(name = "pay_type", length = 32,note = "支付方式(字典编码)")
    private String payType;

    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 60,note = "支付方式名称")
    private String payTypeName;

    /**
     * 费用申请金额
     */
    @CrmColumn(name = "apply_amount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "费用申请金额")
    private BigDecimal applyAmount;

    /**
     * 申请预付金额
     */
    @CrmColumn(name = "apply_advance_amount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "申请预付金额")
    private BigDecimal applyAdvanceAmount;

    /**
     * 已申请预付总金额
     */
    @CrmColumn(name = "already_apply_advance_total_amount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "已申请预付总金额")
    private BigDecimal alreadyApplyAdvanceTotalAmount;

    /**
     * 已预付金额
     */
    @CrmColumn(name = "actual_advance_pay_mount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "已预付金额")
    private BigDecimal actualAdvancePayMount;

    /**
     * 预付原因
     */
    @CrmColumn(name = "advance_reason", length = 200,note = "支付方式(预付原因)")
    private String advanceReason;

    /**
     * 付款方
     */
    @CrmColumn(name = "payer", length = 60,note = "付款方")
    private String payer;

    /**
     * 付款方账号
     */
    @CrmColumn(name = "pay_account", length = 32,note = "付款方账号")
    private String payAccount;

    /**
     * 收款方
     */
    @CrmColumn(name = "receiver", length = 60,note = "收款方")
    private String receiver;

    /**
     * 收款方账号
     */
    @CrmColumn(name = "receiver_account", length = 32,note = "收款方账号")
    private String receiverAccount;

}
