package com.biz.crm.advancepay.service;

import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 活动预付明细表 接口
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
public interface ITpmActAdvancePayDetailService extends IService<TpmActAdvancePayDetailEntity> {

    /**
     * 列表
     * @param tpmActAdvancePayDetailReqVo
     * @return PageResult<TpmActAdvancePayDetailRespVo>
     */
    PageResult<TpmActAdvancePayDetailRespVo> findList(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 查询
     * @param id
     * @return TpmActAdvancePayDetailRespVo
     */
    TpmActAdvancePayDetailRespVo query( String id);

    /**
     * 新增
     * @param tpmActAdvancePayDetailReqVo
     * @return
     */
    void save(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 更新
     * @param tpmActAdvancePayDetailReqVo
     * @return
     */
    void update(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

