package com.biz.crm.advancepay.service;

import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;

import java.util.List;
import java.util.Map;

/**
 * 活动预付主表 接口
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
public interface ITpmActAdvancePayService extends IService<TpmActAdvancePayEntity> {

    /**
     * 列表
     * @param tpmActAdvancePayReqVo
     * @return PageResult<TpmActAdvancePayRespVo>
     */
    PageResult<TpmActAdvancePayRespVo> findList(TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 查询
     * @param id
     * @return TpmActAdvancePayRespVo
     */
    TpmActAdvancePayRespVo query(String id);

    /**
     * 新增
     * @param tpmActAdvancePayReqVo
     * @return
     */
    void save(TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 更新
     * @param tpmActAdvancePayReqVo
     * @return
     */
    void update(TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 提交审批
     * @param tpmActAdvancePayReqVo
     */
    void approve(TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 预付审批回调接口
     * @param activitiCallBackVo
     */
    void activityCallBack(ActivitiCallBackVo activitiCallBackVo);
}

