package com.biz.crm.audit.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileConvertReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 核销申请主表
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@RestController
@RequestMapping("/tpmAuditController")
@Api(tags = "核销申请主表 ")
public class TpmAuditController {
    @Autowired
    private ITpmAuditService tpmAuditService;

    @Autowired
    private ITpmCostTypeFineService tpmCostTypeFineService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAuditRespVo>> list(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        PageResult<TpmAuditRespVo> result=tpmAuditService.findList(tpmAuditReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmAuditRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmAuditRespVo respVo=tpmAuditService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmAuditReqVo.setLockUserName(user.getUsername());
        tpmAuditService.save(tpmAuditReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmAuditReqVo.setLockUserName(user.getUsername());
        tpmAuditService.update(tpmAuditReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids,"编码集合信息不能为空");
        tpmAuditService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAuditService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAuditService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 核销申请新增的活动明细列表
     * @param tpmActReqVo
     * @return
     */
    @ApiOperation(value = "核销申请新增的活动明细列表")
    @PostMapping("/actDetailList")
    @CrmLog
    public Result<PageResult<TpmActDetailRespVo>> actDetailList(@RequestBody TpmActDetailReqVo tpmActReqVo) {
        PageResult<TpmActDetailRespVo> result=tpmAuditService.findActDetailList(tpmActReqVo);
        return Result.ok(result);
    }
    /**
     * 核销申请新增时查询活动列表
     */
    @ApiOperation(value = "核销申请新增时查询活动列表")
    @PostMapping("/actList")
    @CrmLog
    public Result<PageResult<TpmActRespVo>> actList(@RequestBody TpmActReqVo tpmActReqVo) {
        PageResult<TpmActRespVo> result=tpmAuditService.actList(tpmActReqVo);
        return Result.ok(result);
    }

    /**
     * 核销审批
     */
    @ApiOperation(value = "审批通过")
    @PostMapping("/auditApproved")
    @CrmLog
    public Result auditApproved(@RequestBody  TpmAuditReqVo tpmAuditReqVo) {
        tpmAuditService.auditApproved(tpmAuditReqVo);
        return Result.ok("审批通过");
    }

    /**
     * 审批驳回
     */
    @ApiOperation(value = "审批驳回")
    @PostMapping("/reject")
    @CrmLog
    public Result reject(@RequestBody  TpmAuditReqVo tpmAuditReqVo) {
        tpmAuditService.rejectAndInterrupt(tpmAuditReqVo);
        return Result.ok("审批驳回成功");
    }

    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody  TpmAuditReqVo tpmAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmAuditReqVo.setLockUserName(user.getUsername());
        tpmAuditService.approve(tpmAuditReqVo);
        return Result.ok("提交审批成功");
    }

    /**
     * 流程追回
     */
    @ApiOperation(value = "流程追回")
    @PostMapping("/interrupt")
    @CrmLog
    public Result interrupt(@RequestBody  TpmAuditReqVo tpmAuditReqVo) {
        tpmAuditService.rejectAndInterrupt(tpmAuditReqVo);
        return Result.ok("流程追回成功");
    }

    /**
     *  核销申请中核销资料
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "核销申请中核销资料")
    @PostMapping("/costTypeFineListByFineCode")
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> costTypeFineListByFineCode(@RequestBody TpmAuditFileConvertReqVo reqVo) {
        List<TpmCostTypeFineRespVo> respVo = tpmCostTypeFineService.costTypeFineListByFineCode(reqVo);
        return Result.ok(respVo);
    }


    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        log.info("核销收到工作流回调请求,请求参数={}", JSON.toJSONString(activitiCallBackVo));
        tpmAuditService.activityCallBack(activitiCallBackVo);
        return Result.ok("核销审批回调成功");
    }
}
