package com.biz.crm.audit.controller;

import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.util.CodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 核销申请明细表 
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@RestController
@RequestMapping("/tpmAuditDetailController")
@Api(tags = "核销申请明细表 ")
public class TpmAuditDetailController {
    @Autowired
    private ITpmAuditDetailService tpmAuditDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAuditDetailRespVo>> list(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        PageResult<TpmAuditDetailRespVo> result=tpmAuditDetailService.findList(tpmAuditDetailReqVo);
        return Result.ok(result);
    }



    /**
     * 生成上账总单号
     */
    @ApiOperation(value = "生成上账总单号")
    @GetMapping("/generateAccountCode")
    @CrmLog
    public Result generateAccountCode(@RequestParam(value = "num") Integer num) {
        List<String> codeList = CodeUtil.createCodeList(CrmCodeRuleConstants.ACCOUNT_DETAIL, num);
        return Result.ok(codeList);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        tpmAuditDetailService.save(tpmAuditDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        tpmAuditDetailService.update(tpmAuditDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAuditDetailService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAuditDetailService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAuditDetailService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
