package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ITpmAuditFileService;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 核销申请资料表 
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@RestController
@RequestMapping("/tpmAuditFileController")
@Api(tags = "核销申请资料表 ")
public class TpmAuditFileController {
    @Autowired
    private ITpmAuditFileService tpmAuditFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAuditFileRespVo>> list(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo) {
        PageResult<TpmAuditFileRespVo> result=tpmAuditFileService.findList(tpmAuditFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmAuditFileRespVo> query(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo) {
        TpmAuditFileRespVo respVo=tpmAuditFileService.query(tpmAuditFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo) {
        tpmAuditFileService.save(tpmAuditFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo) {
        tpmAuditFileService.update(tpmAuditFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAuditFileService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAuditFileService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAuditFileService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
