package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.TpmAuditEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import java.util.List;
import java.util.Map;

/**
 * 核销申请主表
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface TpmAuditMapper extends BaseMapper<TpmAuditEntity> {
    /**
     * 列表
     * @param page
     * @param tpmAuditReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmAuditRespVo> findList(Page<TpmAuditRespVo> page, @Param("vo") TpmAuditReqVo tpmAuditReqVo);

    /**
     * 查询actDetailCodes中，正在核销中的actDetailCode
     * @param actDetailCodes
     * @return List-actCode
     */
    List<String> findApprovingByActDetailCode(@Param("vo") List<String> actDetailCodes);
}
